/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.facet.FacetFinder;
import com.intellij.ide.DataManager;
import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.Basic;
import com.intellij.javaee.model.common.persistence.mapping.ElementCollection;
import com.intellij.javaee.model.xml.persistence.mapping.Enumerated;
import com.intellij.jpa.actions.NewGroupPersistence;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentObjectNameProvider;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistentObjectManipulator;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.util.Function;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQlModel
extends QlModel {
    @NonNls
    private static final String ID_ATTR = "id";
    private final CachedValue<QlEntity[]> myEntitiesValue;

    public AbstractQlModel(Project project) {
        this.myEntitiesValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)this.getEntitiesInner(), this.getDependenciesForEntitiesCache(project)), false);
    }

    protected abstract void processPersistenceMappings(PairProcessor<PersistenceMappings, PersistenceModelBrowser> var1);

    protected abstract boolean isHibernate();

    @NotNull
    protected abstract List<? extends PersistenceFacet> getPersistenceFacets();

    @Override
    public QlEntity[] getEntities() {
        return (QlEntity[])this.myEntitiesValue.getValue();
    }

    private QlEntity[] getEntitiesInner() {
        THashSet entities = new THashSet();
        this.processPersistenceMappings((PairProcessor<PersistenceMappings, PersistenceModelBrowser>)((PairProcessor)(entityMappings, browser) -> {
            for (PersistentEntity entity : entityMappings.getModelHelper().getPersistentEntities()) {
                ContainerUtil.addIfNotNull((Collection)entities, (Object)AbstractQlModel.getPersistenceEntity(entity, browser, this.isHibernate()));
            }
            return false;
        }));
        return (QlEntity[])entities.toArray((Object[])new QlEntity[entities.size()]);
    }

    protected Object[] getDependenciesForEntitiesCache(Project project) {
        FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
        return new Object[]{PsiModificationTracker.MODIFICATION_COUNT, facetFinder.getAllFacetsOfTypeModificationTracker(JpaFacetType.getInstance().getId()), ProjectRootModificationTracker.getInstance((Project)project)};
    }

    @Nullable
    private static MappingQlEntity getPersistenceEntity(PersistentEntity entity, PersistenceModelBrowser browser, boolean isHibernate) {
        return entity == null ? null : new MappingQlEntity((PersistentObject)entity, browser, isHibernate);
    }

    @Override
    public boolean processInDbTable(@NotNull String tableName, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (tableName == null) {
            AbstractQlModel.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            AbstractQlModel.$$$reportNull$$$0(1);
        }
        if (state == null) {
            AbstractQlModel.$$$reportNull$$$0(2);
        }
        if (place == null) {
            AbstractQlModel.$$$reportNull$$$0(3);
        }
        for (DbDataSource source : this.getDataSources()) {
            DasObject dasTable;
            DbElement table = DbImplUtil.findElement((DbDataSource)source, (DasObject)(dasTable = (DasObject)DasUtil.getTables((DasDataSource)source).filter(DasUtil.byName((String)tableName)).first()));
            if (table == null || table.processDeclarations(processor, state, null, place)) continue;
            return false;
        }
        return super.processInDbTable(tableName, processor, state, place);
    }

    @Override
    public boolean processInDbSchema(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            AbstractQlModel.$$$reportNull$$$0(4);
        }
        if (state == null) {
            AbstractQlModel.$$$reportNull$$$0(5);
        }
        for (DbDataSource source : this.getDataSources()) {
            for (DasTable dasTable : DasUtil.getTables((DasDataSource)source)) {
                DbElement table = DbImplUtil.findElement((DbDataSource)source, (DasObject)dasTable);
                if (table == null || processor.execute((PsiElement)table, state)) continue;
                return false;
            }
        }
        return super.processInDbSchema(processor, state);
    }

    private Collection<DbDataSource> getDataSources() {
        LinkedHashSet<DbDataSource> sources = new LinkedHashSet<DbDataSource>();
        this.processPersistenceMappings((PairProcessor<PersistenceMappings, PersistenceModelBrowser>)((PairProcessor)(mappings, browser) -> {
            sources.addAll(PersistenceUtil.getDataSources((PersistenceMappings)mappings));
            return false;
        }));
        return sources;
    }

    @Override
    public Collection<IntentionAction> getUnresolvedReferenceQuickFixes(QlReferenceExpression referenceExpression, QlEntity entity) {
        QlIdentifier element = referenceExpression.getIdentifier();
        String defaultName = element.getText();
        if (defaultName == null) {
            return super.getUnresolvedReferenceQuickFixes(referenceExpression, entity);
        }
        PersistentObject persistentObject = ((MappingQlEntity)entity).myEntity;
        PersistentObjectManipulator manipulator = (PersistentObjectManipulator)PersistenceHelper.getHelper().getManipulatorsRegistry().getManipulator((Object)persistentObject, PersistentObjectManipulator.class);
        if (manipulator == null) {
            return super.getUnresolvedReferenceQuickFixes(referenceExpression, entity);
        }
        List createActions = manipulator.getCreateActions();
        return ContainerUtil.mapNotNull((Collection)createActions, (Function)((NullableFunction)action -> action.getGroupId() == 50 ? new MyCreateIntentionAction(referenceExpression.getProject(), (PersistenceAction)action, defaultName) : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/AbstractQlModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processInDbTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processInDbSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyCreateIntentionAction
    extends IntentionAndQuickFixAction {
        private final String myDefaultName;
        private final PersistenceAction myCreateAction;
        private final AnAction myAction;

        MyCreateIntentionAction(Project project, PersistenceAction createAction, String defaultName) {
            this.myDefaultName = defaultName;
            this.myCreateAction = createAction;
            this.myAction = NewGroupPersistence.createAnAction(project, createAction, null);
        }

        private DataContext getDataContext(Editor editor) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
            return dataId -> {
                if (PsiElementRenameHandler.DEFAULT_NAME.is(dataId)) {
                    return this.myDefaultName;
                }
                if (PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
                    List<? extends PersistenceFacet> facets = AbstractQlModel.this.getPersistenceFacets();
                    return facets.isEmpty() ? null : facets.get(0);
                }
                return dataContext.getData(dataId);
            };
        }

        @NotNull
        @NonNls
        public String getName() {
            String string = "Add " + this.myCreateAction.getPresentation().getText();
            if (string == null) {
                MyCreateIntentionAction.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                MyCreateIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                MyCreateIntentionAction.$$$reportNull$$$0(2);
            }
            this.myAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myAction, null, (String)"", (DataContext)this.getDataContext(editor)));
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                MyCreateIntentionAction.$$$reportNull$$$0(3);
            }
            this.myAction.update(AnActionEvent.createFromAnAction((AnAction)this.myAction, null, (String)"", (DataContext)this.getDataContext(editor)));
            return this.myCreateAction.getPresentation().isEnabled();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/AbstractQlModel$MyCreateIntentionAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/AbstractQlModel$MyCreateIntentionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SizeQlAttribute
    extends QlAttribute {
        private final PsiClass myCollectionClass;

        SizeQlAttribute(Project project, GlobalSearchScope scope) {
            this.myCollectionClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Collection", scope);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return JavaeeIcons.ATTRIBUTE_ICON;
        }

        @Override
        public final PsiType getPsiType() {
            return PsiType.INT;
        }

        @Override
        @Nullable
        public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
            return component == QlAttribute.ComponentType.SINGLE ? QlAttribute.ComponentTarget.VALUE : null;
        }

        @Override
        @Nullable
        public QlElement getComponentValue(QlAttribute.ComponentType component) {
            return component == QlAttribute.ComponentType.SINGLE ? this : null;
        }

        @Override
        @NotNull
        @NonNls
        public String getPersistenceElementName() {
            return "size";
        }

        public boolean equals(Object obj) {
            return obj instanceof SizeQlAttribute;
        }

        public int hashCode() {
            return 42;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            PsiMethod[] methods;
            if (this.myCollectionClass != null && (methods = this.myCollectionClass.findMethodsByName("size", false)).length >= 1) {
                return methods[0];
            }
            return null;
        }
    }

    private static class ClassQlAttribute
    extends QlAttribute {
        private final Project myProject;
        private final GlobalSearchScope myScope;
        private final PsiClass myObjectClass;

        ClassQlAttribute(Project project, GlobalSearchScope scope) {
            this.myProject = project;
            this.myScope = scope;
            this.myObjectClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", scope);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return JavaeeIcons.ATTRIBUTE_ICON;
        }

        @Override
        @Nullable
        public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
            return component == QlAttribute.ComponentType.SINGLE ? QlAttribute.ComponentTarget.VALUE : null;
        }

        @Override
        @Nullable
        public QlElement getComponentValue(QlAttribute.ComponentType component) {
            return component == QlAttribute.ComponentType.SINGLE ? this : null;
        }

        @Override
        public final PsiType getPsiType() {
            return JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createTypeByFQClassName("java.lang.String", this.myScope);
        }

        @Override
        @NotNull
        @NonNls
        public String getPersistenceElementName() {
            return "class";
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassQlAttribute;
        }

        public int hashCode() {
            return 239;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            PsiMethod[] methods;
            if (this.myObjectClass != null && (methods = this.myObjectClass.findMethodsByName("getClass", false)).length == 1) {
                return methods[0];
            }
            return null;
        }
    }

    public static class MappingQlEntity
    extends QlEntity {
        private final PersistentObject myEntity;
        private final PersistenceModelBrowser myBrowser;
        private final boolean myHibernate;
        private List<QlAttribute> myAttributes;
        private String myElementName;

        public MappingQlEntity(PersistentObject entity, PersistenceModelBrowser browser, boolean hibernate) {
            this.myEntity = entity;
            this.myBrowser = browser;
            this.myHibernate = hibernate;
        }

        @Override
        @Nullable
        public PsiType getPsiType() {
            PsiClass psiClass = (PsiClass)this.myEntity.getClazz().getValue();
            if (psiClass != null) {
                return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
            }
            return null;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return JavaeeIcons.ENTITY_ICON;
        }

        @Override
        public boolean acceptsName(String name) {
            PsiClass aClass;
            if (this.myHibernate && (aClass = (PsiClass)this.myEntity.getClazz().getValue()) != null && (name.equals(aClass.getQualifiedName()) || name.equals(aClass.getName()))) {
                return true;
            }
            return super.acceptsName(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingQlEntity that = (MappingQlEntity)o;
            return !(this.myEntity != null ? !this.myEntity.equals(that.myEntity) : that.myEntity != null);
        }

        public int hashCode() {
            return this.myEntity != null ? this.myEntity.hashCode() : 0;
        }

        @Override
        public List<QlAttribute> getAttributes() {
            if (this.myAttributes == null) {
                this.myAttributes = this.getAttributesInner();
            }
            return this.myAttributes;
        }

        private List<QlAttribute> getAttributesInner() {
            ArrayList<QlAttribute> result = new ArrayList<QlAttribute>();
            ArrayList<PersistentAttribute> pk = new ArrayList<PersistentAttribute>();
            for (PersistentAttribute attribute : this.myBrowser.queryAttributes(this.myEntity)) {
                if (attribute instanceof PersistentTransientAttribute) continue;
                if (attribute instanceof PersistentRelationshipAttribute) {
                    result.add(new MappingRelationshipAttribute((PersistentRelationshipAttribute)attribute, this.myBrowser));
                } else {
                    result.add(new MappingQlAttribute(attribute, this.myBrowser));
                }
                if (!attribute.getAttributeModelHelper().isIdAttribute()) continue;
                pk.add(attribute);
            }
            if (this.myHibernate) {
                PsiFile file = this.myEntity.getContainingFile();
                if (file != null) {
                    result.add(new ClassQlAttribute(this.myEntity.getPsiManager().getProject(), file.getResolveScope()));
                }
                if (pk.size() == 1) {
                    result.add(new MappingQlAttribute((PersistentAttribute)pk.get(0), this.myBrowser){

                        @Override
                        @NotNull
                        public String getPersistenceElementName() {
                            return AbstractQlModel.ID_ATTR;
                        }
                    });
                } else if (pk.size() > 1) {
                    result.add(new CompositeIdQlAttribute(this.myEntity, this.myBrowser, pk));
                }
            }
            return result;
        }

        @Override
        public String getPersistenceElementName() {
            if (this.myElementName == null) {
                this.myElementName = StringUtil.notNullize((String)PersistentObjectNameProvider.getPresentableName((Object)this.myEntity));
            }
            return this.myElementName;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            return this.myEntity.getIdentifyingPsiElement();
        }

        private class MappingRelationshipAttribute
        extends MappingQlAttribute {
            MappingRelationshipAttribute(PersistentRelationshipAttribute attributeBase, PersistenceModelBrowser browser) {
                super((PersistentAttribute)attributeBase, browser);
            }

            public PersistentRelationshipAttribute getAttribute() {
                return (PersistentRelationshipAttribute)super.getAttribute();
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return JavaeeIcons.RELATIONSHIP_ICON;
            }
        }

        private class MappingQlAttribute
        extends QlAttribute {
            private final PersistentAttribute myAttributeBase;
            private final AttributeType myType;
            private final JavaTypeInfo myTypeInfo;

            MappingQlAttribute(PersistentAttribute attributeBase, PersistenceModelBrowser browser) {
                this.myAttributeBase = attributeBase;
                this.myType = AttributeType.getAttributeType((PersistentAttribute)attributeBase);
                this.myTypeInfo = JpaUtil.getSubstitutedTypeInfo(attributeBase, browser, null);
            }

            public PersistentAttribute getAttribute() {
                return this.myAttributeBase;
            }

            public AttributeType getType() {
                return this.myType;
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return JavaeeIcons.ATTRIBUTE_ICON;
            }

            @Override
            public final PsiType getPsiType() {
                return this.myTypeInfo == null ? null : this.myTypeInfo.baseType;
            }

            @Override
            @NotNull
            public String getPersistenceElementName() {
                String string = StringUtil.notNullize((String)((String)this.myAttributeBase.getName().getValue()));
                if (string == null) {
                    MappingQlAttribute.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            public PsiElement getPsiElement() {
                return this.myAttributeBase.getIdentifyingPsiElement();
            }

            @Override
            public List<? extends QlAttribute> getSpecialAttributes() {
                PsiFile file = this.myAttributeBase.getContainingFile();
                if (file != null && (this.myAttributeBase.getAttributeModelHelper().isContainer() || PersistenceCommonUtil.getTypeInfo((PsiType)this.myAttributeBase.getPsiType()).containerType != null)) {
                    return Collections.singletonList(new SizeQlAttribute(file.getProject(), file.getResolveScope()));
                }
                return super.getSpecialAttributes();
            }

            @Override
            public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
                if (this.myTypeInfo == null) {
                    return null;
                }
                switch (component) {
                    case SINGLE: {
                        if (this.myTypeInfo.parameters.length == 0) {
                            return this.getComponentTarget(this.myTypeInfo.baseType);
                        }
                    }
                    case VALUE: {
                        if (this.myTypeInfo.parameters.length >= 1) {
                            return this.getComponentTarget(this.myTypeInfo.parameters[0]);
                        }
                    }
                    case KEY: {
                        if (this.myTypeInfo.parameters.length < 2) break;
                        return this.getComponentTarget(this.myTypeInfo.parameters[1]);
                    }
                }
                return null;
            }

            private QlAttribute.ComponentTarget getComponentTarget(PsiType baseType) {
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)PsiTypesUtil.getPsiClass((PsiType)baseType))) {
                    if (!MappingQlEntity.this.myBrowser.acceptsRole(role) || role.getType() == PersistenceClassRoleEnum.MAPPED_SUPERCLASS) continue;
                    if (role.getType() == PersistenceClassRoleEnum.EMBEDDABLE) {
                        return QlAttribute.ComponentTarget.EMBEDDABLE;
                    }
                    if (role.getType() != PersistenceClassRoleEnum.ENTITY) continue;
                    return QlAttribute.ComponentTarget.ENTITY;
                }
                return QlAttribute.ComponentTarget.VALUE;
            }

            @Override
            public QlElement getComponentValue(QlAttribute.ComponentType component) {
                if (this.myTypeInfo == null) {
                    return null;
                }
                switch (component) {
                    case SINGLE: {
                        return this.myTypeInfo.parameters.length == 0 ? this.getComponentValue(this.myTypeInfo.baseType) : null;
                    }
                    case VALUE: {
                        return this.myTypeInfo.parameters.length >= 1 ? this.getComponentValue(this.myTypeInfo.parameters[0]) : null;
                    }
                    case KEY: {
                        return this.myTypeInfo.parameters.length >= 2 ? this.getComponentValue(this.myTypeInfo.parameters[1]) : null;
                    }
                }
                return null;
            }

            @Nullable
            private QlElement getComponentValue(final PsiType baseType) {
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)PsiTypesUtil.getPsiClass((PsiType)baseType))) {
                    if (!MappingQlEntity.this.myBrowser.acceptsRole(role) || role.getType() == PersistenceClassRoleEnum.MAPPED_SUPERCLASS || role.getType() != PersistenceClassRoleEnum.EMBEDDABLE && role.getType() != PersistenceClassRoleEnum.ENTITY) continue;
                    return new MappingQlEntity(role.getPersistentObject(), MappingQlEntity.this.myBrowser, MappingQlEntity.this.myHibernate);
                }
                final MappingQlAttribute delegate = this;
                return baseType == null ? null : new QlElement(){

                    @Override
                    public String getPersistenceElementName() {
                        return delegate.getPersistenceElementName();
                    }

                    @Override
                    public PsiElement getPsiElement() {
                        return delegate.getPsiElement();
                    }

                    @Override
                    public PsiType getPsiType() {
                        return baseType;
                    }
                };
            }

            @Override
            public boolean isEnumAsString() {
                if (this.myAttributeBase instanceof Basic && ((Basic)this.myAttributeBase).getEnumerated().getValue() == Enumerated.STRING) {
                    return true;
                }
                if (this.myAttributeBase instanceof ElementCollection && ((ElementCollection)this.myAttributeBase).getEnumerated().getValue() == Enumerated.STRING) {
                    return true;
                }
                return super.isEnumAsString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MappingQlAttribute that = (MappingQlAttribute)o;
                return !(this.myAttributeBase != null ? !this.myAttributeBase.equals(that.myAttributeBase) : that.myAttributeBase != null);
            }

            public int hashCode() {
                return this.myAttributeBase != null ? this.myAttributeBase.hashCode() : 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/AbstractQlModel$MappingQlEntity$MappingQlAttribute", "getPersistenceElementName"));
            }
        }

        private class CompositeIdQlAttribute
        extends QlAttribute {
            private final PersistenceModelBrowser myBrowser;
            private final List<PersistentAttribute> myAttributes;
            private final PsiClass myIdClass;

            CompositeIdQlAttribute(PersistentObject entity, PersistenceModelBrowser browser, List<PersistentAttribute> attributes) {
                this.myBrowser = browser;
                this.myAttributes = attributes;
                this.myIdClass = entity instanceof PersistentEntityBase ? (PsiClass)((PersistentEntityBase)entity).getIdClassValue().getValue() : null;
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return JavaeeIcons.ID_ATTRIBUTE_ICON;
            }

            @Override
            public PsiType getPsiType() {
                return this.myIdClass == null ? null : PsiElementFactory.getInstance((Project)this.myIdClass.getProject()).createType(this.myIdClass);
            }

            @Override
            @Nullable
            public QlAttribute.ComponentTarget getComponentTarget(QlAttribute.ComponentType component) {
                return component == QlAttribute.ComponentType.SINGLE ? QlAttribute.ComponentTarget.VALUE : null;
            }

            @Override
            @Nullable
            public QlElement getComponentValue(QlAttribute.ComponentType component) {
                return component == QlAttribute.ComponentType.SINGLE ? this : null;
            }

            @Override
            @NotNull
            @NonNls
            public String getPersistenceElementName() {
                return AbstractQlModel.ID_ATTR;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CompositeIdQlAttribute attribute = (CompositeIdQlAttribute)o;
                if (!this.myAttributes.equals(attribute.myAttributes)) {
                    return false;
                }
                return this.myBrowser.equals(attribute.myBrowser);
            }

            public int hashCode() {
                int result = this.myBrowser.hashCode();
                result = 31 * result + this.myAttributes.hashCode();
                return result;
            }

            @Override
            @Nullable
            public PsiElement getPsiElement() {
                return null;
            }

            @Override
            public List<? extends QlAttribute> getSpecialAttributes() {
                return ContainerUtil.map(this.myAttributes, attribute -> new MappingQlAttribute((PersistentAttribute)attribute, this.myBrowser));
            }
        }
    }
}

