/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.forms.generator;

import com.intellij.javaee.ui.forms.generator.FormGenerator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.NamedEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ComponentFactory {
    private int myCurrentId = 10000;
    private static final Map<Class<?>, String> class2template = new HashMap();

    public XmlTag createComponent(Project project, Class clazz, String key, int rowId) throws Exception {
        String resource = ComponentFactory.getResource(clazz);
        String templateContent = ComponentFactory.getTemplateContent(resource);
        templateContent = StringUtil.replace((String)templateContent, (String)"$ID$", (String)String.valueOf(this.myCurrentId++));
        templateContent = StringUtil.replace((String)templateContent, (String)"$ROW_ID$", (String)String.valueOf(rowId));
        templateContent = StringUtil.replace((String)templateContent, (String)"$BIND$", (String)("my" + key.replaceAll(" ", "")));
        return XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)templateContent);
    }

    private static String getResource(Class<?> clazz) {
        for (Class<?> aClass : class2template.keySet()) {
            if (!aClass.isAssignableFrom(clazz)) continue;
            return class2template.get(aClass);
        }
        return "templates/UnknownComponent.xml";
    }

    public XmlTag createLabelComponent(Project project, String key, int rowId) throws Exception {
        String templateContent = ComponentFactory.getTemplateContent("templates/LabelComponent.xml");
        templateContent = StringUtil.replace((String)templateContent, (String)"$ID$", (String)String.valueOf(this.myCurrentId++));
        templateContent = StringUtil.replace((String)templateContent, (String)"$ROW_ID$", (String)String.valueOf(rowId));
        templateContent = StringUtil.replace((String)templateContent, (String)"$TEXT$", (String)key);
        return XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)templateContent);
    }

    public static String getTemplateContent(String resource) {
        StringBuilder buffer = new StringBuilder();
        try (InputStream inputStream = FormGenerator.class.getResourceAsStream(resource);){
            int ch;
            int prev = 32;
            while ((ch = inputStream.read()) != -1) {
                switch (ch) {
                    case 13: {
                        buffer.append('\n');
                        break;
                    }
                    case 10: {
                        if (prev == 13) break;
                        buffer.append('\n');
                        break;
                    }
                    default: {
                        buffer.append((char)ch);
                    }
                }
                prev = (char)ch;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    static {
        class2template.put(String.class, "templates/TextFieldComponent.xml");
        class2template.put(PsiClass.class, "templates/PsiClassComponent.xml");
        class2template.put(Boolean.class, "templates/CheckBoxComponent.xml");
        class2template.put(NamedEnum.class, "templates/ComboBoxComponent.xml");
        class2template.put(Collection.class, "templates/TableComponent.xml");
    }
}

