/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.ProjectTopics;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkToolWindowViewBase
extends SimpleToolWindowPanel {
    protected final Project myProject;
    protected final StructureTreeModel<?> myModel;
    protected final Tree myTree;

    public FrameworkToolWindowViewBase(@NotNull Project project, @NotNull FrameworkViewTreeStructureProvider treeStructureProvider, @NotNull Disposable parentDisposable) {
        if (project == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(0);
        }
        if (treeStructureProvider == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(2);
        }
        super(true, true);
        this.myTree = new DnDAwareTree();
        this.myProject = project;
        this.myModel = new StructureTreeModel((AbstractTreeStructure)treeStructureProvider.createTreeStructure(project), parentDisposable);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myModel, parentDisposable);
        this.myTree.setModel((TreeModel)asyncTreeModel);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)this.myTree);
        this.initListeners(this.myProject.getMessageBus().connect(parentDisposable), parentDisposable);
    }

    protected void initComponents() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
    }

    protected void updateTree() {
        this.myModel.invalidate();
    }

    private void initListeners(@NotNull MessageBusConnection connection, @NotNull Disposable parentDisposable) {
        if (connection == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(4);
        }
        connection.subscribe(PsiModificationTracker.TOPIC, this::updateTree);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$1", "rootsChanged"));
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(1);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (module == null) {
                    2.$$$reportNull$$$0(3);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (modules == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (oldNameProvider == null) {
                    2.$$$reportNull$$$0(6);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/ui/FrameworkToolWindowViewBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleRemoved";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "after"));
            }
        });
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$4", "fileStatusChanged"));
            }
        }, parentDisposable);
        CopyPasteManager.getInstance().addContentChangedListener((oldTransferable, newTransferable) -> this.updateTree(), parentDisposable);
    }

    public void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(5);
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.addTitleActions(actions);
        toolWindow.setTitleActions(actions.toArray(AnAction.EMPTY_ARRAY));
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearActions(group);
        if (group.getChildrenCount() > 0) {
            toolWindow.setAdditionalGearActions((ActionGroup)group);
        }
    }

    protected void addTitleActions(List<AnAction> actions) {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        actions.add(actionsManager.createExpandAllHeaderAction((JTree)this.myTree));
        actions.add(actionsManager.createCollapseAllHeaderAction((JTree)this.myTree));
    }

    protected void addGearActions(DefaultActionGroup group) {
    }

    @NotNull
    public static Set<Object> getSelectedElements(@NotNull @NonNls JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(6);
        }
        Set<Object> set = (paths = tree.getSelectionPaths()) != null ? Stream.of(paths).map(TreeUtil::getLastUserObject).collect(Collectors.toSet()) : Collections.emptySet();
        if (set == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(7);
        }
        return set;
    }

    public static <T> Set<T> getSelectedElements(@NotNull @NonNls JTree tree, @NotNull Class<T> elementClass) {
        if (tree == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(8);
        }
        if (elementClass == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(9);
        }
        return FrameworkToolWindowViewBase.getSelectedElements(tree).stream().filter(elementClass::isInstance).map(elementClass::cast).collect(Collectors.toSet());
    }

    @Nullable
    private static FrameworkToolWindowViewBase getView(Project project, String toolWindowId) {
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
        Content content = window == null ? null : window.getContentManager().getContent(0);
        return content == null ? null : (FrameworkToolWindowViewBase)content.getDisposer();
    }

    protected static void select(@NotNull String toolWindowId, @NotNull Project project, @Nullable Object element, boolean requestFocus) {
        if (toolWindowId == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(10);
        }
        if (project == null) {
            FrameworkToolWindowViewBase.$$$reportNull$$$0(11);
        }
        if (element == null) {
            return;
        }
        Runnable runnable = () -> {
            FrameworkToolWindowViewBase view = FrameworkToolWindowViewBase.getView(project, toolWindowId);
            if (view == null || view.myModel == null) {
                return;
            }
            Tree tree = view.myTree;
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)tree, true);
            }
            view.myModel.select(element, (JTree)tree, path1 -> {});
        };
        if (requestFocus) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
            if (toolWindow != null) {
                toolWindow.activate(runnable);
            }
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructureProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ui/FrameworkToolWindowViewBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ui/FrameworkToolWindowViewBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initListeners";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupToolWindow";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedElements";
                break;
            }
            case 7: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class FrameworkViewTreeStructureProvider {
        protected FrameworkViewTreeStructureProvider() {
        }

        public abstract SimpleTreeStructure createTreeStructure(@NotNull Project var1);
    }
}

