/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.DynamicBundle;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboBoxFieldPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentDescriptorEditDialog
extends DialogWrapper {
    private ComboBoxFieldPanel myPath;
    @Nls
    private final String myDeploymentDescriptorTitle;
    private JComboBox<ConfigFileVersion> myVersion;
    private JPanel myVersionPanel;
    private JPanel myPanel;
    private final Collection<String> myExistingDescriptorPaths;
    private final boolean myCustomDescriptor;
    private JTextField myOutputDirectory;
    private JPanel myDefaultDirPanel;
    private final ConfigFileMetaData myMetaData;
    @NonNls
    private static final String DEFAULT_OUTPUT_DIRECTORY = "META-INF";
    private final Module myModule;

    public DeploymentDescriptorEditDialog(Component parent, @NotNull Module module, @Nullable ConfigFileMetaData metaData, @Nullable ConfigFileVersion descriptorVersion, Collection<String> suggestedPaths, Collection<String> existingPaths, @Nullable String currentPath) {
        if (module == null) {
            DeploymentDescriptorEditDialog.$$$reportNull$$$0(0);
        }
        super(parent, true);
        this.myModule = module;
        this.$$$setupUI$$$();
        this.myCustomDescriptor = metaData == null;
        this.setTitle(this.myCustomDescriptor ? J2EEBundle.message((String)"dialog.title.resource.location", (Object[])new Object[0]) : J2EEBundle.message((String)"dialog.title.deployment.descriptor.location", (Object[])new Object[0]));
        this.myDeploymentDescriptorTitle = metaData != null ? DeploymentDescriptorEditDialog.createTitle(metaData) : J2EEBundle.message((String)"additional.deployment.descriptor.file.description.additional.resource", (Object[])new Object[0]);
        this.myMetaData = metaData;
        if (this.myDeploymentDescriptorTitle.length() > 0) {
            this.myPath.setLabelText(StringUtil.capitalizeWords((String)this.myDeploymentDescriptorTitle, (boolean)false) + ":");
        }
        this.myPath.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentDescriptorEditDialog.this.chooseDDPath();
            }
        });
        this.myPath.createComponent();
        this.myPath.setChangeListener(() -> this.updateVersion());
        this.myVersion.setRenderer((ListCellRenderer<ConfigFileVersion>)SimpleListCellRenderer.create((String)"", ConfigFileVersion::getName));
        if (metaData != null && descriptorVersion != null) {
            ConfigFileVersion[] versions;
            for (ConfigFileVersion version : versions = metaData.getVersions()) {
                this.myVersion.addItem(version);
            }
            this.setVersion(descriptorVersion);
        } else {
            this.myVersionPanel.setVisible(false);
        }
        this.myExistingDescriptorPaths = existingPaths;
        this.myOutputDirectory.setText(DEFAULT_OUTPUT_DIRECTORY);
        this.myDefaultDirPanel.setVisible(this.myCustomDescriptor);
        this.myPath.setItems(ContainerUtil.map2Array(suggestedPaths, String.class, s -> FileUtil.toSystemDependentName((String)s)));
        if (currentPath == null || currentPath.length() == 0) {
            this.myPath.setText((String)this.myPath.getComboBox().getItemAt(0));
        } else {
            this.myPath.setText(FileUtil.toSystemDependentName((String)currentPath));
        }
        this.updateVersion();
        this.init();
    }

    protected JComponent createCenterPanel() {
        return new JPanel();
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    public String getDimensionServiceKey() {
        return "#com.intellij.javaee.module.view.common.J2EE.J2EEDeploymentDescriptorLocationPanel.changeDDPath";
    }

    protected void doOKAction() {
        if (!this.validateData()) {
            return;
        }
        super.doOKAction();
    }

    @Nls
    private static String createTitle(@NotNull ConfigFileMetaData description) {
        if (description == null) {
            DeploymentDescriptorEditDialog.$$$reportNull$$$0(1);
        }
        return description.getTitle() + " (" + description.getFileName() + ")";
    }

    private void chooseDDPath() {
        String path;
        VirtualFile newFile;
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || DeploymentDescriptorEditDialog.this.myCustomDescriptor || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)StdFileTypes.XML));
            }
        };
        chooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        chooserDescriptor.setTitle(StringUtil.capitalizeWords((String)this.myDeploymentDescriptorTitle, (boolean)true));
        chooserDescriptor.setDescription(J2EEBundle.message((String)"label.choose.or.create.deployment.descriptor.file", (Object[])new Object[]{this.myDeploymentDescriptorTitle}));
        VirtualFile initialDir = null;
        String oldPath = this.myPath.getText();
        if (oldPath != null && oldPath.length() != 0) {
            File oldFile = new File(oldPath);
            initialDir = LocalFileSystem.getInstance().findFileByIoFile(oldFile);
        }
        if (initialDir == null) {
            initialDir = this.myModule.getProject().getBaseDir();
        }
        if ((newFile = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Component)this.myPanel, (Project)this.myModule.getProject(), (VirtualFile)initialDir)) == null) {
            return;
        }
        String newPath = newFile.getPath();
        if (newFile.isDirectory()) {
            newPath = VfsUtilCore.virtualToIoFile((VirtualFile)newFile).getPath();
        }
        if ((path = FileUtil.toSystemDependentName((String)newPath)).length() > 0) {
            this.myPath.setText(path);
        }
    }

    private void updateVersion() {
        String path = this.myPath.getText();
        File file = new File(path);
        this.myVersion.setEnabled(!file.exists());
    }

    public String getPath() {
        String path = this.myPath.getText();
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)path);
    }

    public ConfigFileVersion getVersion() {
        return (ConfigFileVersion)this.myVersion.getSelectedItem();
    }

    public void setOutputDirectory(String relativePath) {
        this.myOutputDirectory.setText(FileUtil.toSystemDependentName((String)relativePath));
    }

    public String getOutputDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myOutputDirectory.getText().trim());
    }

    private boolean validateData() {
        String path = this.getPath();
        if (path == null || path.trim().length() == 0) {
            DeploymentDescriptorEditDialog.reportError(J2EEBundle.message((String)"error.please.specify.path.to.deployment.descriptor", (Object[])new Object[]{this.myDeploymentDescriptorTitle}));
            return false;
        }
        File newFile = new File(path).getAbsoluteFile();
        for (String existingPath : this.myExistingDescriptorPaths) {
            if (!new File(FileUtil.toSystemDependentName((String)existingPath)).getAbsoluteFile().equals(newFile)) continue;
            DeploymentDescriptorEditDialog.reportError(J2EEBundle.message((String)"error.deployment.descriptor.already.exists", (Object[])new Object[]{newFile.getPath()}));
            return false;
        }
        this.updateVersion();
        String outputDirectoryRelativePath = this.myMetaData != null ? this.myMetaData.getDirectoryPath() : this.getOutputDirectory();
        for (String existingPath : this.myExistingDescriptorPaths) {
            if (!existingPath.equals(outputDirectoryRelativePath + newFile.getName())) continue;
            DeploymentDescriptorEditDialog.reportError(J2EEBundle.message((String)"error.deployment.descriptor.target.in.use", (Object[])new Object[]{existingPath}));
            return false;
        }
        return this.checkCanCreateFile(newFile);
    }

    private boolean checkCanCreateFile(File newFile) {
        if (newFile.exists()) {
            return true;
        }
        if (!FileUtil.ensureCanCreateFile((File)newFile)) {
            DeploymentDescriptorEditDialog.reportError(J2EEBundle.message((String)"error.cannot.create.deployment.descriptor", (Object[])new Object[]{this.myDeploymentDescriptorTitle, ""}));
        }
        return true;
    }

    @Nls
    private static void reportError(@Nls String s) {
        Messages.showErrorDialog((String)s, (String)J2EEBundle.message((String)"title.edit.deployment.descriptor", (Object[])new Object[0]));
    }

    private void setVersion(ConfigFileVersion version) {
        this.myVersion.setSelectedItem(version);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/ui/DeploymentDescriptorEditDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBoxFieldPanel comboBoxFieldPanel;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVersionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/J2EEBundle", DeploymentDescriptorEditDialog.class).getString("combobox.deployment.descriptor.version"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myVersion = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myDefaultDirPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/J2EEBundle", DeploymentDescriptorEditDialog.class).getString("deployment.descriptor.panel.directory.path.relative.to.deployment.root.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputDirectory = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPath = comboBoxFieldPanel = new ComboBoxFieldPanel();
        comboBoxFieldPanel.setText("");
        jPanel3.add((Component)comboBoxFieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

