/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.transport;

import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportService;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TransportManager {
    public static TransportManager getInstance() {
        return (TransportManager)ApplicationManager.getApplication().getService(TransportManager.class);
    }

    public boolean hasServices() {
        return TransportService.EP_NAME.hasAnyExtensions();
    }

    public List<TransportType> getTypes() {
        ArrayList<TransportType> result = new ArrayList<TransportType>();
        for (TransportService service : TransportService.EP_NAME.getExtensionList()) {
            result.addAll(service.getTypes());
        }
        return result;
    }

    public List<TransportHost> getAllHosts(@Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : TransportService.EP_NAME.getExtensionList()) {
            result.addAll(service.getHosts(project));
        }
        return result;
    }

    public List<TransportHost> getHostsOfType(TransportType type, @Nullable Project project) {
        ArrayList<TransportHost> result = new ArrayList<TransportHost>();
        for (TransportService service : TransportService.EP_NAME.getExtensionList()) {
            for (TransportHost host : service.getHosts(project)) {
                if (host.getType() != type) continue;
                result.add(host);
            }
        }
        return result;
    }

    @Nullable
    public TransportHost findHost(String hostId, @Nullable Project project) {
        for (TransportService service : TransportService.EP_NAME.getExtensionList()) {
            for (TransportHost host : service.getHosts(project)) {
                if (!host.getId().equals(hostId)) continue;
                return host;
            }
        }
        return null;
    }

    @Nullable
    public TransportHost editHostsOfType(TransportType type, TransportHost selectedHost, @Nullable Project project) {
        for (TransportService service : TransportService.EP_NAME.getExtensionList()) {
            if (!service.getTypes().contains(type)) continue;
            return service.editHostsOfType(type, selectedHost, project);
        }
        return null;
    }

    public static TransportTarget createTarget() {
        TransportTarget result = new TransportTarget();
        result.setId(TransportTarget.getNextId());
        return result;
    }
}

