/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.starter;

import com.intellij.frameworks.starters.local.DependencyConfig;
import com.intellij.frameworks.starters.local.GeneratorAsset;
import com.intellij.frameworks.starters.local.GeneratorEmptyDirectory;
import com.intellij.frameworks.starters.local.GeneratorTemplateFile;
import com.intellij.frameworks.starters.local.Library;
import com.intellij.frameworks.starters.local.LibraryCategory;
import com.intellij.frameworks.starters.local.LinkType;
import com.intellij.frameworks.starters.local.Starter;
import com.intellij.frameworks.starters.local.StarterLanguage;
import com.intellij.frameworks.starters.local.StarterModuleBuilder;
import com.intellij.frameworks.starters.local.StarterPack;
import com.intellij.frameworks.starters.local.StarterWizardContext;
import com.intellij.frameworks.starters.local.TestRunner;
import com.intellij.frameworks.starters.local.gradle.GradleResourcesProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.starter.JavaeeModuleBuilder;
import com.intellij.javaee.starter.JavaeeModuleBuilderInitialStep;
import com.intellij.javaee.starter.JavaeeModuleBuilderIntegration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0014J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\bH\u0014J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\rH\u0016J \u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\b\u0010&\u001a\u0004\u0018\u00010\rH\u0014J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\bH\u0014J\b\u0010)\u001a\u00020*H\u0016J\u0016\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u0010/\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u00100\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u00101\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u00102\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u00103\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J8\u00104\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\t052\u0006\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\r0%2\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\rH\u0002\u00a8\u0006;"}, d2={"Lcom/intellij/javaee/starter/JavaeeModuleBuilder;", "Lcom/intellij/frameworks/starters/local/StarterModuleBuilder;", "()V", "applyAdditionalChanges", "", "module", "Lcom/intellij/openapi/module/Module;", "getAssets", "", "Lcom/intellij/frameworks/starters/local/GeneratorAsset;", "starter", "Lcom/intellij/frameworks/starters/local/Starter;", "getBuilderId", "", "Lorg/jetbrains/annotations/NonNls;", "getCustomOptionsStep", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getDescription", "getFilePathsToOpen", "getGeneratorContextProperties", "", "getLanguages", "Lcom/intellij/frameworks/starters/local/StarterLanguage;", "getName", "getNodeIcon", "Ljavax/swing/Icon;", "getPackagePath", "group", "artifact", "getPresentableName", "getStarterPack", "Lcom/intellij/frameworks/starters/local/StarterPack;", "languageIds", "", "testRunnerId", "getTestRunners", "Lcom/intellij/frameworks/starters/local/TestRunner;", "getWeight", "", "hasWebProfile", "", "libIds", "", "isCdiCapable", "isJpaCapable", "isJsfCapable", "isRsCapable", "isWebCapable", "addIfAvailable", "", "ftManager", "Lcom/intellij/ide/fileTemplates/FileTemplateManager;", "allJ2eeTemplates", "templateFile", "destinationPath", "intellij.javaee.platform.impl"})
public final class JavaeeModuleBuilder
extends StarterModuleBuilder {
    @NotNull
    public String getBuilderId() {
        return "javaee";
    }

    @NotNull
    public String getName() {
        return "Java Enterprise";
    }

    @NotNull
    public String getPresentableName() {
        return "Java Enterprise";
    }

    @NotNull
    public String getDescription() {
        String string = J2EEBundle.message((String)"javaee.starter.module.builder.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"J2EEBundle.message(\"java\u2026ule.builder.description\")");
        return string;
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = JavaUltimateIcons.Javaee.JakartaEE;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Javaee.JakartaEE");
        return icon;
    }

    public int getWeight() {
        return super.getWeight() + 10;
    }

    @NotNull
    public ModuleWizardStep getCustomOptionsStep(@NotNull WizardContext context, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (ModuleWizardStep)new JavaeeModuleBuilderInitialStep(this.getStarterWizardContext(), context, (Collection<TestRunner>)this.getTestRunners(), StarterModuleBuilder.Companion.getImporters(), (Collection<StarterLanguage>)this.getLanguages());
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object[])new StarterLanguage[]{new StarterLanguage("java", "Java", "JAVA", AllIcons.Nodes.PpJdk, true), new StarterLanguage("kotlin", "Kotlin", "kotlin", JavaUltimateIcons.Lang.KotlinLanguage, false, 16, null), new StarterLanguage("groovy", "Groovy", "Groovy", JavaUltimateIcons.Lang.GroovyLanguage, false, 16, null)});
    }

    @NotNull
    protected StarterPack getStarterPack(@NotNull Set<String> languageIds, @Nullable String testRunnerId) {
        List $this$apply;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(languageIds, (String)"languageIds");
        Set fullPlatformLibs = SetsKt.setOf((Object[])new String[]{"web-api", "batch", "bean-validation", "cdi", "concurrency", "connector", "ejb", "json-b", "json-p", "jms", "jpa", "jax-rs", "security", "jsf", "servlet", "transaction", "websocket"});
        Set webProfileLibs = SetsKt.setOf((Object[])new String[]{"bean-validation", "cdi", "ejb", "json-b", "json-p", "jpa", "jax-rs", "security", "jsf", "servlet", "transaction", "websocket"});
        String string = J2EEBundle.message((String)"javaee.starter.category.specifications.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"J2EEBundle.message(\"java\u2026ry.specifications.title\")");
        String string2 = J2EEBundle.message((String)"javaee.starter.category.specifications.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"J2EEBundle.message(\"java\u2026cifications.description\")");
        LibraryCategory specsCategory = new LibraryCategory(AllIcons.Nodes.ModuleGroup, string, string2);
        String string3 = J2EEBundle.message((String)"javaee.starter.category.implementations.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"J2EEBundle.message(\"java\u2026y.implementations.title\")");
        String string4 = J2EEBundle.message((String)"javaee.starter.category.implementations.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"J2EEBundle.message(\"java\u2026ementations.description\")");
        LibraryCategory libsCategory = new LibraryCategory(AllIcons.Nodes.PpLibFolder, string3, string4);
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        DependencyConfig dependencyConfig = this.loadDependencyConfig("/starter/javaee8.pom");
        String string5 = "Java EE 8";
        String string6 = "javaee8";
        int n = 0;
        Object[] objectArray2 = objectArray = new Starter[2];
        String string7 = "javaee8";
        boolean bl4 = false;
        String string8 = J2EEBundle.message((String)"javaee.starter.library.javaee-api8.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"J2EEBundle.message(\"java\u2026javaee-api8.description\")");
        $this$apply.add(new Library("javaee-api", JavaUltimateIcons.Javaee.JavaeeAppModule, "Full Platform", string8, "javax", "javaee-api", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)LinkType.WEBSITE, (Object)"https://www.oracle.com/java/technologies/java-ee-glance.html"), TuplesKt.to((Object)LinkType.SPECIFICATION, (Object)"https://jcp.org/en/jsr/detail?id=366")}), specsCategory, false, false, fullPlatformLibs, 768, null));
        String string9 = J2EEBundle.message((String)"javaee.starter.library.web-api.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"J2EEBundle.message(\"java\u2026ary.web-api.description\")");
        $this$apply.add(new Library("web-api", JavaUltimateIcons.Web.WebModule, "Web Profile", string9, "javax", "javaee-web-api", null, specsCategory, false, false, webProfileLibs, 832, null));
        String string10 = J2EEBundle.message((String)"javaee.starter.library.batch.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"J2EEBundle.message(\"java\u2026brary.batch.description\")");
        $this$apply.add(new Library("batch", JavaUltimateIcons.Javaee.EjbModule, "Batch", string10, "javax.batch", "javax.batch-api", null, specsCategory, false, false, null, 1856, null));
        String string11 = J2EEBundle.message((String)"javaee.starter.library.bean-validation.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"J2EEBundle.message(\"java\u2026-validation.description\")");
        $this$apply.add(new Library("bean-validation", JavaUltimateIcons.Javaee.EjbModule, "Bean Validation", string11, "javax.validation", "validation-api", null, specsCategory, false, false, null, 1856, null));
        String string12 = J2EEBundle.message((String)"javaee.starter.library.cdi.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"J2EEBundle.message(\"java\u2026library.cdi.description\")");
        $this$apply.add(new Library("cdi", JavaUltimateIcons.Javaee.EjbModule, "Contexts and Dependency Injection (CDI)", string12, "javax.enterprise", "cdi-api", null, specsCategory, false, false, null, 1856, null));
        String string13 = J2EEBundle.message((String)"javaee.starter.library.concurrency.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"J2EEBundle.message(\"java\u2026concurrency.description\")");
        $this$apply.add(new Library("concurrency", JavaUltimateIcons.Javaee.EjbModule, "Concurrency Utils", string13, "javax.enterprise.concurrent", "javax.enterprise.concurrent-api", null, specsCategory, false, false, null, 1856, null));
        String string14 = J2EEBundle.message((String)"javaee.starter.library.connector.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"J2EEBundle.message(\"java\u2026y.connector.description\")");
        $this$apply.add(new Library("connector", JavaUltimateIcons.Javaee.EjbModule, "Connector Architecture (JCA)", string14, "javax.resource", "javax.resource-api", null, specsCategory, false, false, null, 1856, null));
        String string15 = J2EEBundle.message((String)"javaee.starter.library.ejb.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"J2EEBundle.message(\"java\u2026library.ejb.description\")");
        $this$apply.add(new Library("ejb", JavaUltimateIcons.Javaee.EjbModule, "Enterprise Java Beans (EJB)", string15, "javax.ejb", "javax.ejb-api", null, specsCategory, false, false, null, 1856, null));
        String string16 = J2EEBundle.message((String)"javaee.starter.library.json-b.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"J2EEBundle.message(\"java\u2026rary.json-b.description\")");
        $this$apply.add(new Library("json-b", JavaUltimateIcons.Javaee.EjbModule, "JSON Binding (JSON-B)", string16, "javax.json.bind", "javax.json.bind-api", null, specsCategory, false, false, null, 1856, null));
        String string17 = J2EEBundle.message((String)"javaee.starter.library.json-p.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"J2EEBundle.message(\"java\u2026rary.json-p.description\")");
        $this$apply.add(new Library("json-p", JavaUltimateIcons.Javaee.EjbModule, "JSON Processing (JSON-P)", string17, "javax.json", "javax.json-api", null, specsCategory, false, false, null, 1856, null));
        String string18 = J2EEBundle.message((String)"javaee.starter.library.jms.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"J2EEBundle.message(\"java\u2026library.jms.description\")");
        $this$apply.add(new Library("jms", JavaUltimateIcons.Javaee.EjbModule, "Message Service (JMS)", string18, "javax.jms", "javax.jms-api", null, specsCategory, false, false, null, 1856, null));
        String string19 = J2EEBundle.message((String)"javaee.starter.library.mvc.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"J2EEBundle.message(\"java\u2026library.mvc.description\")");
        $this$apply.add(new Library("mvc", JavaUltimateIcons.Javaee.EjbModule, "Model View Controller (MVC)", string19, "javax.mvc", "javax.mvc-api", null, specsCategory, false, false, null, 1856, null));
        String string20 = J2EEBundle.message((String)"javaee.starter.library.jpa.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"J2EEBundle.message(\"java\u2026library.jpa.description\")");
        $this$apply.add(new Library("jpa", JavaUltimateIcons.Javaee.EjbModule, "Persistence (JPA)", string20, "javax.persistence", "javax.persistence-api", null, specsCategory, false, false, null, 1856, null));
        String string21 = J2EEBundle.message((String)"javaee.starter.library.jaxrs.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string21, (String)"J2EEBundle.message(\"java\u2026brary.jaxrs.description\")");
        $this$apply.add(new Library("jax-rs", JavaUltimateIcons.Javaee.EjbModule, "RESTful Web Services (JAX-RS)", string21, "javax.ws.rs", "javax.ws.rs-api", null, specsCategory, false, false, null, 1856, null));
        String string22 = J2EEBundle.message((String)"javaee.starter.library.security.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string22, (String)"J2EEBundle.message(\"java\u2026ry.security.description\")");
        $this$apply.add(new Library("security", JavaUltimateIcons.Javaee.EjbModule, "Security", string22, "javax.security.enterprise", "javax.security.enterprise-api", null, specsCategory, false, false, null, 1856, null));
        String string23 = J2EEBundle.message((String)"javaee.starter.library.jsf.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"J2EEBundle.message(\"java\u2026library.jsf.description\")");
        $this$apply.add(new Library("jsf", JavaUltimateIcons.Javaee.EjbModule, "Server Faces (JSF)", string23, "javax.faces", "javax.faces-api", null, specsCategory, false, false, null, 1856, null));
        String string24 = J2EEBundle.message((String)"javaee.starter.library.servlet.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string24, (String)"J2EEBundle.message(\"java\u2026ary.servlet.description\")");
        $this$apply.add(new Library("servlet", JavaUltimateIcons.Javaee.EjbModule, "Servlet", string24, "javax.servlet", "javax.servlet-api", null, specsCategory, false, false, null, 1856, null));
        String string25 = J2EEBundle.message((String)"javaee.starter.library.jta.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"J2EEBundle.message(\"java\u2026library.jta.description\")");
        $this$apply.add(new Library("transaction", JavaUltimateIcons.Javaee.EjbModule, "Transaction (JTA)", string25, "javax.transaction", "javax.transaction-api", null, specsCategory, false, false, null, 1856, null));
        String string26 = J2EEBundle.message((String)"javaee.starter.library.websocket.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string26, (String)"J2EEBundle.message(\"java\u2026y.websocket.description\")");
        $this$apply.add(new Library("websocket", JavaUltimateIcons.Javaee.EjbModule, "WebSocket", string26, "javax.websocket", "javax.websocket-api", null, specsCategory, false, false, null, 1856, null));
        String string27 = J2EEBundle.message((String)"javaee.starter.library.jaxws.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string27, (String)"J2EEBundle.message(\"java\u2026brary.jaxws.description\")");
        $this$apply.add(new Library("jax-ws", JavaUltimateIcons.Javaee.EjbModule, "XML Web Services (JAX-WS)", string27, "javax.xml.ws", "jaxws-api", null, specsCategory, false, false, null, 1856, null));
        String string28 = J2EEBundle.message((String)"javaee.starter.library.bval.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string28, (String)"J2EEBundle.message(\"java\u2026ibrary.bval.description\")");
        $this$apply.add(new Library("bval", AllIcons.Nodes.PpLib, "Apache BVal", string28, "org.apache.bval", "bval-jsr", null, libsCategory, false, false, null, 1856, null));
        String string29 = J2EEBundle.message((String)"javaee.starter.library.cxf.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string29, (String)"J2EEBundle.message(\"java\u2026library.cxf.description\")");
        $this$apply.add(new Library("cxf-rs", AllIcons.Nodes.PpLib, "Apache CXF REST Server (JAX-RS)", string29, "org.apache.cxf", "cxf-rt-frontend-jaxrs", null, libsCategory, false, false, null, 1856, null));
        String string30 = J2EEBundle.message((String)"javaee.starter.library.cxf.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string30, (String)"J2EEBundle.message(\"java\u2026library.cxf.description\")");
        $this$apply.add(new Library("cxf-ws", AllIcons.Nodes.PpLib, "Apache CXF XML Web Service (JAX-WS)", string30, "org.apache.cxf", "cxf-rt-frontend-jaxws", null, libsCategory, false, false, null, 1856, null));
        String string31 = J2EEBundle.message((String)"javaee.starter.library.activemq.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"J2EEBundle.message(\"java\u2026ry.activemq.description\")");
        $this$apply.add(new Library("activemq", AllIcons.Nodes.PpLib, "Apache ActiveMQ Client", string31, "org.apache.activemq", "activemq-client", null, libsCategory, false, false, null, 1856, null));
        String string32 = J2EEBundle.message((String)"javaee.starter.library.jersey.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string32, (String)"J2EEBundle.message(\"java\u2026rary.jersey.description\")");
        $this$apply.add(new Library("jersey-server", AllIcons.Nodes.PpLib, "Eclipse Jersey Server", string32, "org.glassfish.jersey.containers", "jersey-container-servlet", null, libsCategory, false, false, null, 1856, null));
        String string33 = J2EEBundle.message((String)"javaee.starter.library.jersey.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string33, (String)"J2EEBundle.message(\"java\u2026rary.jersey.description\")");
        $this$apply.add(new Library("jersey-client", AllIcons.Nodes.PpLib, "Eclipse Jersey Client", string33, "org.glassfish.jersey.core", "jersey-client", null, libsCategory, false, false, null, 1856, null));
        String string34 = J2EEBundle.message((String)"javaee.starter.library.eclipselink.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string34, (String)"J2EEBundle.message(\"java\u2026eclipselink.description\")");
        $this$apply.add(new Library("eclipselink", AllIcons.Nodes.PpLib, "EclipseLink", string34, "org.eclipse.persistence", "eclipselink", null, libsCategory, false, false, null, 1856, null));
        String string35 = J2EEBundle.message((String)"javaee.starter.library.hibernate.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string35, (String)"J2EEBundle.message(\"java\u2026y.hibernate.description\")");
        $this$apply.add(new Library("hibernate", AllIcons.Nodes.PpLib, "Hibernate", string35, "org.hibernate", "hibernate-entitymanager", null, libsCategory, false, false, null, 1856, null));
        String string36 = J2EEBundle.message((String)"javaee.starter.library.hibernate-validator.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string36, (String)"J2EEBundle.message(\"java\u2026e-validator.description\")");
        $this$apply.add(new Library("hibernate-validator", AllIcons.Nodes.PpLib, "Hibernate Validator", string36, "org.hibernate.validator", "hibernate-validator", null, libsCategory, false, false, null, 1856, null));
        String string37 = J2EEBundle.message((String)"javaee.starter.library.mojarra.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string37, (String)"J2EEBundle.message(\"java\u2026ary.mojarra.description\")");
        $this$apply.add(new Library("mojarra", AllIcons.Nodes.PpLib, "Mojarra Server Faces", string37, "org.glassfish", "jakarta.faces", null, libsCategory, false, false, null, 1856, null));
        String string38 = J2EEBundle.message((String)"javaee.starter.library.resteasy.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string38, (String)"J2EEBundle.message(\"java\u2026ry.resteasy.description\")");
        $this$apply.add(new Library("resteasy", AllIcons.Nodes.PpLib, "RESTEasy", string38, "org.jboss.resteasy", "resteasy-servlet-initializer", null, libsCategory, false, false, null, 1856, null));
        String string39 = J2EEBundle.message((String)"javaee.starter.library.rabbitmq.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string39, (String)"J2EEBundle.message(\"java\u2026ry.rabbitmq.description\")");
        $this$apply.add(new Library("rabbitmq", AllIcons.Nodes.PpLib, "RabbitMQ Client", string39, "com.rabbitmq", "amqp-client", null, libsCategory, false, false, null, 1856, null));
        String string40 = J2EEBundle.message((String)"javaee.starter.library.thymeleaf.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string40, (String)"J2EEBundle.message(\"java\u2026y.thymeleaf.description\")");
        $this$apply.add(new Library("thymeleaf", AllIcons.Nodes.PpLib, "Thymeleaf", string40, "org.thymeleaf", "thymeleaf", null, libsCategory, false, false, null, 1856, null));
        String string41 = J2EEBundle.message((String)"javaee.starter.library.tyrus-server.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string41, (String)"J2EEBundle.message(\"java\u2026yrus-server.description\")");
        $this$apply.add(new Library("tyrus-server", AllIcons.Nodes.PpLib, "Tyrus Server", string41, "org.glassfish.tyrus", "tyrus-container-grizzly-server", null, libsCategory, false, false, null, 1856, null));
        String string42 = J2EEBundle.message((String)"javaee.starter.library.tyrus-client.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string42, (String)"J2EEBundle.message(\"java\u2026yrus-client.description\")");
        $this$apply.add(new Library("tyrus-client", AllIcons.Nodes.PpLib, "Tyrus Client", string42, "org.glassfish.tyrus.bundles", "tyrus-standalone-client", null, libsCategory, false, false, null, 1856, null));
        String string43 = J2EEBundle.message((String)"javaee.starter.library.weld.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string43, (String)"J2EEBundle.message(\"java\u2026ibrary.weld.description\")");
        $this$apply.add(new Library("weld", AllIcons.Nodes.PpLib, "Weld SE", string43, "org.jboss.weld.se", "weld-se-core", null, libsCategory, false, false, null, 1856, null));
        Unit unit = Unit.INSTANCE;
        List list3 = list;
        DependencyConfig dependencyConfig2 = dependencyConfig;
        String string44 = string5;
        String string45 = string6;
        objectArray[n] = new Starter(string45, string44, dependencyConfig2, list3);
        boolean bl5 = false;
        List list4 = new ArrayList();
        bl2 = false;
        bl3 = false;
        $this$apply = list4;
        dependencyConfig = this.loadDependencyConfig("/starter/jakartaee9.pom");
        string5 = "Jakarta EE 9";
        string6 = "jakartaee9";
        n = 1;
        objectArray = objectArray2;
        boolean bl6 = false;
        String string46 = J2EEBundle.message((String)"javaee.starter.library.jakarta-api9.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string46, (String)"J2EEBundle.message(\"java\u2026akarta-api9.description\")");
        $this$apply.add(new Library("javaee-api", JavaUltimateIcons.Javaee.JavaeeAppModule, "Full Platform", string46, "jakarta.platform", "jakarta.jakartaee-api", MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)LinkType.WEBSITE, (Object)"https://jakarta.ee/"), TuplesKt.to((Object)LinkType.SPECIFICATION, (Object)"https://jakarta.ee/specifications/")}), specsCategory, false, false, fullPlatformLibs, 768, null));
        String string47 = J2EEBundle.message((String)"javaee.starter.library.web-api.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string47, (String)"J2EEBundle.message(\"java\u2026ary.web-api.description\")");
        $this$apply.add(new Library("web-api", JavaUltimateIcons.Web.WebModule, "Web Profile", string47, "jakarta.platform", "jakarta.jakartaee-web-api", null, specsCategory, false, false, webProfileLibs, 832, null));
        String string48 = J2EEBundle.message((String)"javaee.starter.library.batch.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string48, (String)"J2EEBundle.message(\"java\u2026brary.batch.description\")");
        $this$apply.add(new Library("batch", JavaUltimateIcons.Javaee.EjbModule, "Batch", string48, "jakarta.batch", "jakarta.batch-api", null, specsCategory, false, false, null, 1856, null));
        String string49 = J2EEBundle.message((String)"javaee.starter.library.bean-validation.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string49, (String)"J2EEBundle.message(\"java\u2026-validation.description\")");
        $this$apply.add(new Library("bean-validation", JavaUltimateIcons.Javaee.EjbModule, "Bean Validation", string49, "jakarta.validation", "jakarta.validation-api", null, specsCategory, false, false, null, 1856, null));
        String string50 = J2EEBundle.message((String)"javaee.starter.library.cdi.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string50, (String)"J2EEBundle.message(\"java\u2026library.cdi.description\")");
        $this$apply.add(new Library("cdi", JavaUltimateIcons.Javaee.EjbModule, "Contexts and Dependency Injection (CDI)", string50, "jakarta.enterprise", "jakarta.enterprise.cdi-api", null, specsCategory, false, false, null, 1856, null));
        String string51 = J2EEBundle.message((String)"javaee.starter.library.concurrency.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string51, (String)"J2EEBundle.message(\"java\u2026concurrency.description\")");
        $this$apply.add(new Library("concurrency", JavaUltimateIcons.Javaee.EjbModule, "Concurrency Utils", string51, "jakarta.enterprise.concurrent", "jakarta.enterprise.concurrent-api", null, specsCategory, false, false, null, 1856, null));
        String string52 = J2EEBundle.message((String)"javaee.starter.library.connector.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string52, (String)"J2EEBundle.message(\"java\u2026y.connector.description\")");
        $this$apply.add(new Library("connector", JavaUltimateIcons.Javaee.EjbModule, "Connector Architecture (JCA)", string52, "jakarta.resource", "jakarta.resource-api", null, specsCategory, false, false, null, 1856, null));
        String string53 = J2EEBundle.message((String)"javaee.starter.library.ejb.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string53, (String)"J2EEBundle.message(\"java\u2026library.ejb.description\")");
        $this$apply.add(new Library("ejb", JavaUltimateIcons.Javaee.EjbModule, "Enterprise Java Beans (EJB)", string53, "jakarta.ejb", "jakarta.ejb-api", null, specsCategory, false, false, null, 1856, null));
        String string54 = J2EEBundle.message((String)"javaee.starter.library.json-b.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string54, (String)"J2EEBundle.message(\"java\u2026rary.json-b.description\")");
        $this$apply.add(new Library("json-b", JavaUltimateIcons.Javaee.EjbModule, "JSON Binding (JSON-B)", string54, "jakarta.json.bind", "jakarta.json.bind-api", null, specsCategory, false, false, null, 1856, null));
        String string55 = J2EEBundle.message((String)"javaee.starter.library.json-p.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string55, (String)"J2EEBundle.message(\"java\u2026rary.json-p.description\")");
        $this$apply.add(new Library("json-p", JavaUltimateIcons.Javaee.EjbModule, "JSON Processing (JSON-P)", string55, "jakarta.json", "jakarta.json-api", null, specsCategory, false, false, null, 1856, null));
        String string56 = J2EEBundle.message((String)"javaee.starter.library.jms.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string56, (String)"J2EEBundle.message(\"java\u2026library.jms.description\")");
        $this$apply.add(new Library("jms", JavaUltimateIcons.Javaee.EjbModule, "Message Service (JMS)", string56, "jakarta.jms", "jakarta.jms-api", null, specsCategory, false, false, null, 1856, null));
        String string57 = J2EEBundle.message((String)"javaee.starter.library.mvc.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string57, (String)"J2EEBundle.message(\"java\u2026library.mvc.description\")");
        $this$apply.add(new Library("mvc", JavaUltimateIcons.Javaee.EjbModule, "Model View Controller (MVC)", string57, "jakarta.mvc", "jakarta.mvc-api", null, specsCategory, false, false, null, 1856, null));
        String string58 = J2EEBundle.message((String)"javaee.starter.library.jpa.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string58, (String)"J2EEBundle.message(\"java\u2026library.jpa.description\")");
        $this$apply.add(new Library("jpa", JavaUltimateIcons.Javaee.EjbModule, "Persistence (JPA)", string58, "jakarta.persistence", "jakarta.persistence-api", null, specsCategory, false, false, null, 1856, null));
        String string59 = J2EEBundle.message((String)"javaee.starter.library.jaxrs.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string59, (String)"J2EEBundle.message(\"java\u2026brary.jaxrs.description\")");
        $this$apply.add(new Library("jax-rs", JavaUltimateIcons.Javaee.EjbModule, "RESTful Web Services (JAX-RS)", string59, "jakarta.ws.rs", "jakarta.ws.rs-api", null, specsCategory, false, false, null, 1856, null));
        String string60 = J2EEBundle.message((String)"javaee.starter.library.security.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string60, (String)"J2EEBundle.message(\"java\u2026ry.security.description\")");
        $this$apply.add(new Library("security", JavaUltimateIcons.Javaee.EjbModule, "Security", string60, "jakarta.security.enterprise", "jakarta.security.enterprise-api", null, specsCategory, false, false, null, 1856, null));
        String string61 = J2EEBundle.message((String)"javaee.starter.library.jsf.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string61, (String)"J2EEBundle.message(\"java\u2026library.jsf.description\")");
        $this$apply.add(new Library("jsf", JavaUltimateIcons.Javaee.EjbModule, "Server Faces (JSF)", string61, "jakarta.faces", "jakarta.faces-api", null, specsCategory, false, false, null, 1856, null));
        String string62 = J2EEBundle.message((String)"javaee.starter.library.servlet.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string62, (String)"J2EEBundle.message(\"java\u2026ary.servlet.description\")");
        $this$apply.add(new Library("servlet", JavaUltimateIcons.Javaee.EjbModule, "Servlet", string62, "jakarta.servlet", "jakarta.servlet-api", null, specsCategory, false, false, null, 1856, null));
        String string63 = J2EEBundle.message((String)"javaee.starter.library.jta.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string63, (String)"J2EEBundle.message(\"java\u2026library.jta.description\")");
        $this$apply.add(new Library("transaction", JavaUltimateIcons.Javaee.EjbModule, "Transaction (JTA)", string63, "jakarta.transaction", "jakarta.transaction-api", null, specsCategory, false, false, null, 1856, null));
        String string64 = J2EEBundle.message((String)"javaee.starter.library.websocket.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string64, (String)"J2EEBundle.message(\"java\u2026y.websocket.description\")");
        $this$apply.add(new Library("websocket", JavaUltimateIcons.Javaee.EjbModule, "WebSocket", string64, "jakarta.websocket", "jakarta.websocket-api", null, specsCategory, false, false, null, 1856, null));
        String string65 = J2EEBundle.message((String)"javaee.starter.library.jaxws.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string65, (String)"J2EEBundle.message(\"java\u2026brary.jaxws.description\")");
        $this$apply.add(new Library("jax-ws", JavaUltimateIcons.Javaee.EjbModule, "XML Web Services (JAX-WS)", string65, "jakarta.xml.ws", "jakarta.xml.ws-api", null, specsCategory, false, false, null, 1856, null));
        String string66 = J2EEBundle.message((String)"javaee.starter.library.jersey.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string66, (String)"J2EEBundle.message(\"java\u2026rary.jersey.description\")");
        $this$apply.add(new Library("jersey-server", AllIcons.Nodes.PpLib, "Eclipse Jersey Server", string66, "org.glassfish.jersey.containers", "jersey-container-servlet", null, libsCategory, false, false, null, 1856, null));
        String string67 = J2EEBundle.message((String)"javaee.starter.library.jersey.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string67, (String)"J2EEBundle.message(\"java\u2026rary.jersey.description\")");
        $this$apply.add(new Library("jersey-client", AllIcons.Nodes.PpLib, "Eclipse Jersey Client", string67, "org.glassfish.jersey.core", "jersey-client", null, libsCategory, false, false, null, 1856, null));
        String string68 = J2EEBundle.message((String)"javaee.starter.library.eclipselink.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string68, (String)"J2EEBundle.message(\"java\u2026eclipselink.description\")");
        $this$apply.add(new Library("eclipselink", AllIcons.Nodes.PpLib, "EclipseLink", string68, "org.eclipse.persistence", "org.eclipse.persistence.jpa", null, libsCategory, false, false, null, 1856, null));
        String string69 = J2EEBundle.message((String)"javaee.starter.library.mojarra.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string69, (String)"J2EEBundle.message(\"java\u2026ary.mojarra.description\")");
        $this$apply.add(new Library("mojarra", AllIcons.Nodes.PpLib, "Mojarra Server Faces", string69, "org.glassfish", "jakarta.faces", null, libsCategory, false, false, null, 1856, null));
        String string70 = J2EEBundle.message((String)"javaee.starter.library.tyrus-server.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string70, (String)"J2EEBundle.message(\"java\u2026yrus-server.description\")");
        $this$apply.add(new Library("tyrus-server", AllIcons.Nodes.PpLib, "Tyrus Server", string70, "org.glassfish.tyrus", "tyrus-container-grizzly-server", null, libsCategory, false, false, null, 1856, null));
        String string71 = J2EEBundle.message((String)"javaee.starter.library.tyrus-client.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string71, (String)"J2EEBundle.message(\"java\u2026yrus-client.description\")");
        $this$apply.add(new Library("tyrus-client", AllIcons.Nodes.PpLib, "Tyrus Client", string71, "org.glassfish.tyrus.bundles", "tyrus-standalone-client", null, libsCategory, false, false, null, 1856, null));
        String string72 = J2EEBundle.message((String)"javaee.starter.library.weld.description", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string72, (String)"J2EEBundle.message(\"java\u2026ibrary.weld.description\")");
        $this$apply.add(new Library("weld", AllIcons.Nodes.PpLib, "Weld SE", string72, "org.jboss.weld.se", "weld-se-core", null, libsCategory, false, false, null, 1856, null));
        unit = Unit.INSTANCE;
        List list5 = list4;
        DependencyConfig dependencyConfig3 = dependencyConfig;
        String string73 = string5;
        String string74 = string6;
        objectArray[n] = new Starter(string74, string73, dependencyConfig3, list5);
        List list6 = CollectionsKt.listOf((Object[])objectArray2);
        String string75 = string7;
        return new StarterPack(string75, list6);
    }

    @NotNull
    protected List<TestRunner> getTestRunners() {
        return CollectionsKt.listOf((Object[])new TestRunner[]{new TestRunner("junit", "JUnit"), new TestRunner("testng", "TestNG")});
    }

    @NotNull
    protected List<GeneratorAsset> getAssets(@NotNull Starter starter) {
        String packagePath;
        Intrinsics.checkNotNullParameter((Object)starter, (String)"starter");
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        FileTemplateManager ftManager = FileTemplateManager.getInstance((Project)projectManager.getDefaultProject());
        boolean bl = false;
        List assets = new ArrayList();
        if (Intrinsics.areEqual((Object)this.getStarterWizardContext().getGeneratorId(), (Object)"gradle")) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("build_" + starter.getId() + ".gradle");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"ftManager.getJ2eeTemplat\u2026ld_${starter.id}.gradle\")");
            assets.add(new GeneratorTemplateFile("build.gradle", fileTemplate));
            FileTemplate fileTemplate2 = ftManager.getJ2eeTemplate("javaee-settings.gradle");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"ftManager.getJ2eeTemplat\u2026roup.JEE_SETTINGS_GRADLE)");
            assets.add(new GeneratorTemplateFile("settings.gradle", fileTemplate2));
            FileTemplate fileTemplate3 = ftManager.getJ2eeTemplate("javaee-gradle-wrapper.properties");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate3, (String)"ftManager.getJ2eeTemplat\u2026p.JEE_GRADLEW_PROPERTIES)");
            assets.add(new GeneratorTemplateFile("gradle/wrapper/gradle-wrapper.properties", fileTemplate3));
            assets.addAll(new GradleResourcesProvider().getGradlewResources());
        } else if (Intrinsics.areEqual((Object)this.getStarterWizardContext().getGeneratorId(), (Object)"maven")) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("pom_" + starter.getId() + ".xml");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"ftManager.getJ2eeTemplate(\"pom_${starter.id}.xml\")");
            assets.add(new GeneratorTemplateFile("pom.xml", fileTemplate));
        }
        String samplesLanguage = this.getSamplesLanguage(this.getStarterWizardContext().getLanguageIds());
        String samplesExt = this.getSamplesExt(samplesLanguage);
        assets.add(new GeneratorEmptyDirectory("src/main/" + samplesLanguage));
        assets.add(new GeneratorEmptyDirectory("src/main/resources"));
        assets.add(new GeneratorEmptyDirectory("src/test/" + samplesLanguage));
        assets.add(new GeneratorEmptyDirectory("src/test/resources"));
        JavaeeModuleBuilderInitialStep.TemplateType applicationType = JavaeeModuleBuilderInitialStep.Companion.getTemplateType(this.getStarterWizardContext());
        Set libIds = this.getStarterWizardContext().getLibraryIds();
        boolean hasWebProfile = this.hasWebProfile(libIds);
        boolean isJakarta = Intrinsics.areEqual((Object)starter.getId(), (Object)"jakartaee9");
        FileTemplateManager fileTemplateManager = ftManager;
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplateManager, (String)"ftManager");
        Set set = ContainerUtil.map2Set((Object[])fileTemplateManager.getAllJ2eeTemplates(), (Function)getAssets.allTemplates.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ContainerUtil.map2Set(ft\u2026me + \".\" + it.extension }");
        Set allTemplates2 = set;
        if (applicationType == JavaeeModuleBuilderInitialStep.TemplateType.WEB_APPLICATION && (hasWebProfile || this.isWebCapable(libIds))) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("javaee-index.jsp");
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"ftManager.getJ2eeTemplate(\"javaee-index.jsp\")");
            assets.add(new GeneratorTemplateFile("src/main/webapp/index.jsp", fileTemplate));
            packagePath = this.getPackagePath(this.getStarterWizardContext().getGroup(), this.getStarterWizardContext().getArtifact());
            String string = "src/main/" + samplesLanguage + '/' + packagePath + "/HelloServlet." + samplesExt;
            FileTemplate fileTemplate4 = ftManager.getJ2eeTemplate("HelloServlet-" + samplesLanguage + '.' + samplesExt);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate4, (String)"ftManager.getJ2eeTemplat\u2026Language}.${samplesExt}\")");
            assets.add(new GeneratorTemplateFile(string, fileTemplate4));
        }
        if (applicationType == JavaeeModuleBuilderInitialStep.TemplateType.WEB_APPLICATION) {
            this.addIfAvailable(assets, ftManager, allTemplates2, isJakarta ? "web.5_0.xml" : "web.4_0.xml", "src/main/webapp/WEB-INF/web.xml");
        }
        if (hasWebProfile || this.isJpaCapable(libIds)) {
            this.addIfAvailable(assets, ftManager, allTemplates2, isJakarta ? "persistence_3_0.xml" : "persistence_2_2.xml", "src/main/resources/META-INF/persistence.xml");
        }
        if (hasWebProfile || this.isCdiCapable(libIds)) {
            this.addIfAvailable(assets, ftManager, allTemplates2, isJakarta ? "cdi.beans_3_0.xml" : "cdi.beans_2_0.xml", "src/main/resources/META-INF/beans.xml");
        }
        if ((applicationType == JavaeeModuleBuilderInitialStep.TemplateType.WEB_APPLICATION || applicationType == JavaeeModuleBuilderInitialStep.TemplateType.REST_SERVICE) && (hasWebProfile || this.isRsCapable(libIds))) {
            packagePath = this.getPackagePath(this.getStarterWizardContext().getGroup(), this.getStarterWizardContext().getArtifact());
            String string = "src/main/" + samplesLanguage + '/' + packagePath + "/HelloResource." + samplesExt;
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate("HelloResource-" + samplesLanguage + '.' + samplesExt);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"ftManager.getJ2eeTemplat\u2026Language}.${samplesExt}\")");
            assets.add(new GeneratorTemplateFile(string, fileTemplate));
            String string2 = "src/main/" + samplesLanguage + '/' + packagePath + "/HelloApplication." + samplesExt;
            FileTemplate fileTemplate5 = ftManager.getJ2eeTemplate("HelloApplication-" + samplesLanguage + '.' + samplesExt);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate5, (String)"ftManager.getJ2eeTemplat\u2026Language}.${samplesExt}\")");
            assets.add(new GeneratorTemplateFile(string2, fileTemplate5));
        }
        return assets;
    }

    private final boolean hasWebProfile(Collection<String> libIds) {
        return libIds.contains("javaee-api") || libIds.contains("web-api");
    }

    private final void addIfAvailable(List<GeneratorAsset> $this$addIfAvailable, FileTemplateManager ftManager, Set<String> allJ2eeTemplates, String templateFile, String destinationPath) {
        if (allJ2eeTemplates.contains(templateFile)) {
            FileTemplate fileTemplate = ftManager.getJ2eeTemplate(templateFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"ftManager.getJ2eeTemplate(templateFile)");
            $this$addIfAvailable.add((GeneratorAsset)new GeneratorTemplateFile(destinationPath, fileTemplate));
        }
    }

    private final boolean isWebCapable(Collection<String> libIds) {
        return libIds.contains("javaee-api") || libIds.contains("web-api") || libIds.contains("servlet") || this.isJsfCapable(libIds) || this.isRsCapable(libIds) || libIds.contains("jax-ws") || libIds.contains("mvc") || libIds.contains("cxf-ws") || libIds.contains("tyrus-server") || libIds.contains("tyrus-client");
    }

    private final boolean isJpaCapable(Collection<String> libIds) {
        return libIds.contains("jpa") || libIds.contains("eclipselink") || libIds.contains("hibernate");
    }

    private final boolean isCdiCapable(Collection<String> libIds) {
        return libIds.contains("cdi") || libIds.contains("weld");
    }

    private final boolean isJsfCapable(Collection<String> libIds) {
        return libIds.contains("jsf") || libIds.contains("mojarra");
    }

    private final boolean isRsCapable(Collection<String> libIds) {
        return libIds.contains("jax-rs") || libIds.contains("jersey-server") || libIds.contains("resteasy") || libIds.contains("cxf-rs");
    }

    @NotNull
    protected Map<String, String> getGeneratorContextProperties() {
        HashMap props = new HashMap(super.getGeneratorContextProperties());
        boolean shouldCreateWar = JavaeeModuleBuilderInitialStep.Companion.getTemplateType(this.getStarterWizardContext()) != JavaeeModuleBuilderInitialStep.TemplateType.LIBRARY && (this.hasWebProfile(this.getStarterWizardContext().getLibraryIds()) || this.isWebCapable(this.getStarterWizardContext().getLibraryIds()));
        ((Map)props).put("war", shouldCreateWar ? "true" : "false");
        return props;
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        boolean bl = false;
        List files = new ArrayList();
        if (Intrinsics.areEqual((Object)this.getStarterWizardContext().getGeneratorId(), (Object)"maven")) {
            files.add("pom.xml");
        } else if (Intrinsics.areEqual((Object)this.getStarterWizardContext().getGeneratorId(), (Object)"gradle")) {
            files.add("build.gradle");
        }
        JavaeeModuleBuilderInitialStep.TemplateType applicationType = JavaeeModuleBuilderInitialStep.Companion.getTemplateType(this.getStarterWizardContext());
        String packagePath = this.getPackagePath(this.getStarterWizardContext().getGroup(), this.getStarterWizardContext().getArtifact());
        String samplesLanguage = this.getSamplesLanguage(this.getStarterWizardContext().getLanguageIds());
        String samplesExt = this.getSamplesExt(samplesLanguage);
        Set libIds = this.getStarterWizardContext().getLibraryIds();
        if (applicationType == JavaeeModuleBuilderInitialStep.TemplateType.WEB_APPLICATION && (this.hasWebProfile(libIds) || this.isWebCapable(libIds))) {
            files.add("src/main/" + samplesLanguage + '/' + packagePath + "/HelloServlet." + samplesExt);
            files.add("src/main/webapp/index.jsp");
        }
        if (applicationType != JavaeeModuleBuilderInitialStep.TemplateType.LIBRARY && (this.hasWebProfile(libIds) || this.isRsCapable(libIds))) {
            files.add("src/main/" + samplesLanguage + '/' + packagePath + "/HelloApplication." + samplesExt);
            files.add("src/main/" + samplesLanguage + '/' + packagePath + "/HelloResource." + samplesExt);
        }
        return files;
    }

    private final String getPackagePath(String group, String artifact) {
        String packageName = StarterModuleBuilder.Companion.getPackageName(group, artifact);
        return StringsKt.removeSuffix((String)StringsKt.replace$default((String)packageName, (String)".", (String)"/", (boolean)false, (int)4, null), (CharSequence)"/");
    }

    public void applyAdditionalChanges(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        JavaeeModuleBuilderInitialStep.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<JavaeeModuleBuilderIntegration>(this, module){
            final /* synthetic */ JavaeeModuleBuilder this$0;
            final /* synthetic */ Module $module;

            public final void accept(JavaeeModuleBuilderIntegration it) {
                it.applySettings(this.$module, JavaeeModuleBuilder.access$getStarterWizardContext$p(this.this$0));
            }
            {
                this.this$0 = javaeeModuleBuilder;
                this.$module = module;
            }
        });
    }

    public JavaeeModuleBuilder() {
        PluginVerifier.verifyUltimatePlugin();
    }

    public static final /* synthetic */ StarterWizardContext access$getStarterWizardContext$p(JavaeeModuleBuilder $this) {
        return $this.getStarterWizardContext();
    }
}

