/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PsiNamedElementNodeDescriptor<T extends PsiNamedElement>
extends JavaeeNodeDescriptor<T> {
    private final T myElement;

    protected PsiNamedElementNodeDescriptor(T element, NodeDescriptor parentDescriptor, Object parameters) {
        super(element.getProject(), parentDescriptor, parameters, element);
        this.myElement = element;
    }

    public Color getNewColor() {
        PsiNamedElement element = (PsiNamedElement)this.getJamElement();
        if (CopyPasteManager.getInstance().isCutElement((Object)element)) {
            return CopyPasteManager.CUT_COLOR;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file == null ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(file).getColor();
    }

    public T updateElement() {
        return this.myElement;
    }

    public Icon getNewIcon() {
        int flags = 2;
        PsiElement element = (PsiElement)this.getJamElement();
        if (ModuleUtilCore.isModuleDisposed((PsiElement)element)) {
            VirtualFile virtualFile = (VirtualFile)((DataManagerImpl)DataManager.getInstance()).getDataRule(CommonDataKeys.VIRTUAL_FILE.getName()).getData((DataProvider)this);
            if (virtualFile == null) {
                return null;
            }
            FileType fileType = virtualFile.getFileType();
            return fileType.getIcon();
        }
        return element.getIcon(flags);
    }

    public String getNewNodeText() {
        return ((PsiNamedElement)this.getJamElement()).getName();
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            PsiNamedElementNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiNamedElement element = (PsiNamedElement)this.getJamElement();
            return element != null && element.isValid() ? element : null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            PsiNamedElement element = (PsiNamedElement)this.getJamElement();
            return element instanceof Navigatable && element.isValid() ? element : null;
        }
        return super.getData(dataId);
    }

    public boolean isValid() {
        PsiNamedElement element = (PsiNamedElement)this.getJamElement();
        return element != null && element.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/javaee/module/view/nodes/PsiNamedElementNodeDescriptor", "getData"));
    }
}

