/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFacetNodeDescriptor<F extends JavaeeFacet>
extends JamNodeDescriptor<F> {
    public static final DataKey<JavaeeFacet> FACET_NODE_KEY = DataKey.create((String)"javaee.facet.context");
    private final F myFacet;

    protected JavaeeFacetNodeDescriptor(F facet, Object parameters) {
        super(facet.getModule().getProject(), null, parameters, facet);
        this.myFacet = facet;
    }

    protected JavaeeFacetNodeDescriptor(F facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(facet.getModule().getProject(), parentDescriptor, parameters, facet);
        this.myFacet = facet;
    }

    public F getFacet() {
        return this.myFacet;
    }

    public String getNewTooltip() {
        F facet = this.getFacet();
        return facet.getType().getPresentableName();
    }

    public String getNewNodeText() {
        if (this.getFacet().isDisposed()) {
            return null;
        }
        return JavaeeUtil.getFacetWithModuleName(this.getFacet());
    }

    @Nullable
    protected final FacetAsVirtualFileImpl getVirtualFile() {
        return FacetAsVirtualFileImpl.fileByPath(this.getFacet());
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            JavaeeFacetNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (FACET_NODE_KEY.is(dataId)) {
            return this.getFacet();
        }
        if (LangDataKeys.MODULE_CONTEXT.getName().equals(dataId)) {
            return ((JavaeeFacet)this.getJamElement()).getModule();
        }
        if (CommonDataKeys.VIRTUAL_FILE.getName().equals(dataId)) {
            return this.getVirtualFile();
        }
        if (CommonDataKeys.NAVIGATABLE.getName().equals(dataId)) {
            return new OpenFileDescriptor(this.getProject(), (VirtualFile)this.getVirtualFile());
        }
        return null;
    }

    public DeleteProvider getDeleteProvider() {
        return null;
    }

    public boolean isValid() {
        return !((JavaeeFacet)this.getJamElement()).isDisposed() && !((JavaeeFacet)this.getJamElement()).getModule().isDisposed() && ((JavaeeFacetEx)this.getFacet()).getCommonPart().isAllDescriptorsValid();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Nullable
    public Icon getNewIcon() {
        return this.getFacet().getType().getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/javaee/module/view/nodes/JavaeeFacetNodeDescriptor", "getData"));
    }
}

