/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.components;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkElementVirtualFileProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyCachingFileSystem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkVirtualFileSystem
extends DummyCachingFileSystem<FrameworkElementAsVirtualFileImpl> {
    @NonNls
    private static final String PROTOCOL = "javaeeDummy";
    @NonNls
    private static final String PATH_PREFIX = "JavaeeElement:/";

    public static FrameworkVirtualFileSystem getJ2EEInstance() {
        return (FrameworkVirtualFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public FrameworkVirtualFileSystem() {
        super(PROTOCOL);
    }

    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(0);
        }
        super.onProjectOpened(project);
        FacetPointersManager.getInstance((Project)project).addListener(JavaeeFacet.class, (FacetPointerListener)new FacetPointerListener<JavaeeFacet>(){

            public void pointerIdChanged(@NotNull FacetPointer<JavaeeFacet> facetPointer, @NotNull String oldId) {
                if (facetPointer == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (oldId == null) {
                    1.$$$reportNull$$$0(1);
                }
                String oldPath = FrameworkVirtualFileSystem.getPath(facetPointer.getProject(), oldId, "Facet", "");
                String oldFacetName = FacetPointersManager.getFacetName((String)oldId);
                String newFacetName = facetPointer.getFacetName();
                FrameworkElementAsVirtualFileImpl file = (FrameworkElementAsVirtualFileImpl)FrameworkVirtualFileSystem.this.findFileByPath(oldPath);
                if (file != null && !oldFacetName.equals(newFacetName)) {
                    FrameworkVirtualFileSystem.this.beforeFileRename(file, this, oldFacetName, newFacetName);
                    FrameworkVirtualFileSystem.this.clearCache();
                    file = (FrameworkElementAsVirtualFileImpl)FrameworkVirtualFileSystem.this.findFileByPath(oldPath);
                    FrameworkVirtualFileSystem.this.fileRenamed(file, this, oldFacetName, newFacetName);
                } else {
                    FrameworkVirtualFileSystem.this.clearCache();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "facetPointer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldId";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/module/components/FrameworkVirtualFileSystem$1";
                objectArray[2] = "pointerIdChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    @Nullable
    public FrameworkElementAsVirtualFileImpl findFileByPathInner(@NotNull String path) {
        if (path == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(1);
        }
        if (!path.startsWith(PATH_PREFIX)) {
            return null;
        }
        int projectIdEnd = path.indexOf(47, PATH_PREFIX.length());
        if (projectIdEnd == -1) {
            return null;
        }
        String projectId = path.substring(PATH_PREFIX.length(), projectIdEnd);
        int nameEnd = path.indexOf(47, projectIdEnd + 1);
        if (nameEnd == -1) {
            return null;
        }
        String elementName = FrameworkVirtualFileSystem.unescapeSlash((String)path.substring(projectIdEnd + 1, nameEnd));
        int typeStart = path.lastIndexOf(47);
        if (typeStart == -1 || typeStart <= nameEnd) {
            return null;
        }
        String elementType = path.substring(typeStart + 1);
        String facetId = path.substring(nameEnd + 1, typeStart);
        Project project = this.getProject(projectId);
        if (project == null) {
            return null;
        }
        FacetPointer facetPointer = FacetPointersManager.getInstance((Project)project).create(facetId);
        for (FrameworkElementVirtualFileProvider provider : FrameworkElementVirtualFileProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            FrameworkElementAsVirtualFileImpl file = provider.createFileByPath((FacetPointer<? extends Facet>)facetPointer, elementType, elementName);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public static String getPath(@NotNull FacetPointer<? extends Facet> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(2);
        }
        return FrameworkVirtualFileSystem.getPath(facetPointer.getProject(), facetPointer.getId(), elementType, elementName);
    }

    public static String getPath(@NotNull Project project, String facetPointerId, String elementType, String elementName) {
        if (project == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(3);
        }
        return PATH_PREFIX + project.getLocationHash() + "/" + FrameworkVirtualFileSystem.escapeSlash((String)StringUtil.notNullize((String)elementName)) + "/" + facetPointerId + "/" + elementType;
    }

    protected void doRenameFile(@NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            FrameworkVirtualFileSystem.$$$reportNull$$$0(5);
        }
        ((FrameworkElementAsVirtualFileImpl)vFile).setElementName(newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetPointer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/module/components/FrameworkVirtualFileSystem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileByPathInner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doRenameFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

