/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jmxremote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.directoryManager.BaseDirectoryAware;
import com.intellij.javaee.jmxremote.JmxRemoteAware;
import com.intellij.javaee.jmxremote.JmxRemotePrepareResult;
import com.intellij.javaee.util.CredentialsGenerator;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JmxRemoteUtil {
    private static final Logger LOG = Logger.getInstance(JmxRemoteUtil.class);

    public static void prepare(@NotNull JmxRemoteAware jmxRemoteAware, @NotNull ParametersList vmParameters) throws ExecutionException {
        if (jmxRemoteAware == null) {
            JmxRemoteUtil.$$$reportNull$$$0(0);
        }
        if (vmParameters == null) {
            JmxRemoteUtil.$$$reportNull$$$0(1);
        }
        JmxRemotePrepareResult prepareResult = JmxRemoteUtil.prepare(jmxRemoteAware);
        JmxRemoteUtil.apply(jmxRemoteAware, prepareResult);
        JmxRemoteUtil.apply(vmParameters, prepareResult);
    }

    @NotNull
    public static JmxRemotePrepareResult prepare(@NotNull BaseDirectoryAware baseDirectoryProvider) throws ExecutionException {
        if (baseDirectoryProvider == null) {
            JmxRemoteUtil.$$$reportNull$$$0(2);
        }
        File baseDirectory = baseDirectoryProvider.getBaseDirectory();
        baseDirectory.mkdirs();
        File accessFile = new File(baseDirectory, "jmxremote.access");
        String username = CredentialsGenerator.generateUsername();
        JmxRemoteUtil.writePropertyFile(accessFile, username, "readwrite");
        File passwordFile = new File(baseDirectory, "jmxremote.password");
        String password = CredentialsGenerator.generatePassword();
        JmxRemoteUtil.writePropertyFile(passwordFile, username, password);
        LOG.debug("JMX auth for :" + baseDirectoryProvider + ": " + baseDirectoryProvider.getBaseDirectory());
        LOG.debug("JMX username: " + username + ", password: " + password);
        return new JmxRemotePrepareResult(username, password, accessFile, passwordFile);
    }

    private static void writePropertyFile(@NotNull File file, @NotNull String key, @NotNull String value) throws ExecutionException {
        if (file == null) {
            JmxRemoteUtil.$$$reportNull$$$0(3);
        }
        if (key == null) {
            JmxRemoteUtil.$$$reportNull$$$0(4);
        }
        if (value == null) {
            JmxRemoteUtil.$$$reportNull$$$0(5);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.ISO_8859_1);){
            writer.write(key + " " + value);
        }
        catch (IOException e) {
            throw new ExecutionException(J2EEBundle.message((String)"dialog.message.can.t.write.file", (Object[])new Object[]{file}), (Throwable)e);
        }
        JmxRemoteUtil.setFileAccessibleForOwnerOnly(file.toPath());
    }

    private static void setFileAccessibleForOwnerOnly(@NotNull Path file) throws ExecutionException {
        if (file == null) {
            JmxRemoteUtil.$$$reportNull$$$0(6);
        }
        try {
            PosixFileAttributeView posixView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixView != null) {
                posixView.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                return;
            }
            AclFileAttributeView aclView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
            if (aclView != null) {
                AclEntry aclEntry = AclEntry.newBuilder().setType(AclEntryType.ALLOW).setPrincipal(aclView.getOwner()).setPermissions(AclEntryPermission.READ_DATA, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.DELETE, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_ACL, AclEntryPermission.SYNCHRONIZE).build();
                aclView.setAcl(Collections.singletonList(aclEntry));
                return;
            }
            throw new ExecutionException(J2EEBundle.message((String)"dialog.message.unable.to.set.permissions.for.file", (Object[])new Object[]{file}));
        }
        catch (IOException e) {
            throw new ExecutionException(J2EEBundle.message((String)"dialog.message.can.t.set.permissions.for.file", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public static void apply(@NotNull JmxRemoteAware jmxRemoteAware, @NotNull JmxRemotePrepareResult prepareResult) {
        if (jmxRemoteAware == null) {
            JmxRemoteUtil.$$$reportNull$$$0(7);
        }
        if (prepareResult == null) {
            JmxRemoteUtil.$$$reportNull$$$0(8);
        }
        jmxRemoteAware.setJmxUsername(prepareResult.getUsername());
        jmxRemoteAware.setJmxPassword(prepareResult.getPassword());
    }

    public static void apply(@NotNull ParametersList vmParameters, @Nullable JmxRemotePrepareResult prepareResult) throws ExecutionException {
        if (vmParameters == null) {
            JmxRemoteUtil.$$$reportNull$$$0(9);
        }
        if (prepareResult == null) {
            vmParameters.defineProperty("com.sun.management.jmxremote.authenticate", "false");
        } else {
            try {
                vmParameters.defineProperty("com.sun.management.jmxremote.password.file", prepareResult.getPasswordFile().getCanonicalPath());
                vmParameters.defineProperty("com.sun.management.jmxremote.access.file", prepareResult.getAccessFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jmxRemoteAware";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectoryProvider";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareResult";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/jmxremote/JmxRemoteUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writePropertyFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setFileAccessibleForOwnerOnly";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

