/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.application;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.appServers.context.DefaultWebModuleContextProvider;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.model.xml.application.JavaeeApplication;
import com.intellij.javaee.application.model.xml.application.JavaeeModule;
import com.intellij.javaee.application.model.xml.application.Web;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.JavaeeApplicationArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.psi.PsiFile;
import gnu.trove.THashMap;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeDescriptorUtil {
    @Deprecated
    @Nullable
    public static String getContextRoot(@Nullable String moduleWebUri, @NotNull JavaeeApplication javaeeApplication) {
        if (javaeeApplication == null) {
            JavaeeDescriptorUtil.$$$reportNull$$$0(0);
        }
        return DefaultWebModuleContextProvider.getContext((JavaeeApplication)javaeeApplication, (String)moduleWebUri);
    }

    public static void checkDescriptor(final JavaeeApplication root, CompositePackagingElement<?> rootElement, ArtifactProblemsHolder manager, JavaeeApplicationArtifactType artifactType) {
        THashMap uri2Facet = new THashMap();
        THashMap facetId2Uri = new THashMap();
        JavaeeDescriptorUtil.processIncludedArtifacts(rootElement, artifactType, (Map<String, JavaeeFacet>)uri2Facet, (Map<String, String>)facetId2Uri, manager.getContext());
        THashMap id2CorrectUri = new THashMap();
        for (JavaeeModule module : root.getModules()) {
            JavaeeFacet facet;
            String id;
            String uri = (String)module.getWeb().getWebUri().getValue();
            if (uri == null) {
                uri = (String)module.getEjb().getValue();
            }
            if (uri != null && uri2Facet.remove(uri) != null || (uri = (String)facetId2Uri.get(id = (String)module.getId().getValue())) == null || (facet = (JavaeeFacet)uri2Facet.remove(uri)) == null) continue;
            id2CorrectUri.put(id, Pair.create((Object)facet, (Object)uri));
        }
        if (!uri2Facet.isEmpty() || !id2CorrectUri.isEmpty()) {
            String facetWithModule;
            String message;
            if (uri2Facet.size() + id2CorrectUri.size() > 1) {
                message = J2EEBundle.message((String)"descriptor.several.facets.not.registered", (Object[])new Object[0]);
            } else if (uri2Facet.size() == 1) {
                facetWithModule = JavaeeUtil.getFacetWithModuleNameDetailed((JavaeeFacet)uri2Facet.values().iterator().next());
                message = J2EEBundle.message((String)"facet.0.not.registered", (Object[])new Object[]{facetWithModule});
            } else {
                facetWithModule = JavaeeUtil.getFacetWithModuleNameDetailed((JavaeeFacet)((Pair)id2CorrectUri.values().iterator().next()).getFirst());
                message = J2EEBundle.message((String)"facet.0.has.incorrect.uri.tag", (Object[])new Object[]{facetWithModule});
            }
            manager.registerError(message, "application.xml-mismatches-artifact", null, new ArtifactProblemQuickFix[]{new ArtifactProblemQuickFix((Map)uri2Facet, (Map)id2CorrectUri){
                final /* synthetic */ Map val$uri2Facet;
                final /* synthetic */ Map val$id2CorrectUri;
                {
                    this.val$uri2Facet = map;
                    this.val$id2CorrectUri = map2;
                }

                public void performFix(ArtifactEditorContext artifactEditorContext) {
                    PsiFile containingFile = root.getContainingFile();
                    if (containingFile == null) {
                        return;
                    }
                    WriteCommandAction.writeCommandAction((Project)artifactEditorContext.getProject(), (PsiFile[])new PsiFile[]{containingFile}).run(() -> JavaeeDescriptorUtil.updateModuleElements(this.val$uri2Facet, this.val$id2CorrectUri, root));
                }
            }});
        }
    }

    private static void processIncludedArtifacts(final CompositePackagingElement<?> rootElement, ArtifactType artifactType, final Map<String, JavaeeFacet> uri2Facet, final Map<String, String> facetId2Uri, final PackagingElementResolvingContext context) {
        PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>(){

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(1);
                }
                JavaeeFacet facet = element.findFacet(context);
                CompositePackagingElement parent = path.getLastParent();
                if (parent != null && facet != null && !(facet instanceof JavaeeApplicationFacet) && !(parent instanceof ArtifactRootElement)) {
                    String uri = StringUtil.trimStart((String)path.getPathStringFrom("/", rootElement), (String)"/");
                    uri2Facet.put(uri, facet);
                    String id = JavaeeDescriptorUtil.getId(facet);
                    facetId2Uri.put(id, uri);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/application/JavaeeDescriptorUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ArtifactUtil.processPackagingElements(rootElement, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true, (ArtifactType)artifactType);
    }

    private static void updateModuleElements(Map<String, JavaeeFacet> uri2Facet, Map<String, Pair<JavaeeFacet, String>> id2CorrectUri, JavaeeApplication root) {
        for (JavaeeModule module : root.getModules()) {
            Pair<JavaeeFacet, String> pair;
            String id = (String)module.getId().getValue();
            if (id == null || (pair = id2CorrectUri.get(id)) == null) continue;
            String uri = (String)pair.getSecond();
            if (pair.getFirst() instanceof WebFacet) {
                module.getWeb().getWebUri().setValue((Object)uri);
                continue;
            }
            module.getEjb().setValue((Object)uri);
        }
        JavaeeDescriptorUtil.addModules(uri2Facet, root);
    }

    public static void addModules(@NotNull JavaeeApplication root, @NotNull Artifact artifact, @NotNull Project project) {
        if (root == null) {
            JavaeeDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (artifact == null) {
            JavaeeDescriptorUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JavaeeDescriptorUtil.$$$reportNull$$$0(3);
        }
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        HashMap<String, JavaeeFacet> uri2Facet = new HashMap<String, JavaeeFacet>();
        JavaeeDescriptorUtil.processIncludedArtifacts(artifact.getRootElement(), artifact.getArtifactType(), uri2Facet, new HashMap<String, String>(), context);
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{root.getContainingFile()}).run(() -> JavaeeDescriptorUtil.addModules(uri2Facet, root));
    }

    private static void addModules(Map<String, JavaeeFacet> uri2Facet, JavaeeApplication root) {
        for (Map.Entry<String, JavaeeFacet> entry : uri2Facet.entrySet()) {
            JavaeeModule module = root.addModule();
            JavaeeFacet facet = entry.getValue();
            module.getId().setValue((Object)JavaeeDescriptorUtil.getId(facet));
            String uri = entry.getKey();
            if (facet instanceof WebFacet) {
                Web web = module.getWeb();
                web.getWebUri().setValue((Object)uri);
                web.getContextRoot().setValue((Object)JavaeeDescriptorUtil.getDefaultContextRoot((WebFacet)facet));
                continue;
            }
            if (!(facet instanceof EjbFacet)) continue;
            module.getEjb().setValue((Object)uri);
        }
    }

    @NotNull
    private static String getDefaultContextRoot(WebFacet webFacet) {
        String string = webFacet.getModule().getName() + webFacet.getName();
        if (string == null) {
            JavaeeDescriptorUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String getId(JavaeeFacet facet) {
        return JavaeeDescriptorUtil.convertNameToXmlName(facet.getModule().getName() + "-" + facet.getName());
    }

    public static String convertNameToXmlName(String baseName) {
        StringBuilder builder = new StringBuilder(baseName.length());
        for (int i = 0; i < baseName.length(); ++i) {
            char c = baseName.charAt(i);
            if (i == 0 && !Verifier.isXMLNameStartCharacter((char)c) || !Verifier.isXMLNameCharacter((char)c)) {
                c = '_';
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeApplication";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/application/JavaeeDescriptorUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/application/JavaeeDescriptorUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContextRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModules";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

