/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\n\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "()V", "buildCommentBlocks", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "dockerFile", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "findFirstNonTrivialCommentText", "", "comment", "Lcom/intellij/psi/PsiComment;", "range", "Lcom/intellij/openapi/util/TextRange;", "getLanguagePlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isRegionCollapsedByDefault", "Companion", "intellij.clouds.docker.file"})
public final class DockerFileFoldingBuilder
extends CustomFoldingBuilder {
    private static final int MAX_PLACEHOLDER_LEN = 40;
    private static final String ELLIPSIS = " ...";
    public static final Companion Companion = new Companion(null);

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement psiElement = root;
        if (!(psiElement instanceof DockerPsiFile)) {
            psiElement = null;
        }
        DockerPsiFile dockerPsiFile = (DockerPsiFile)psiElement;
        if (dockerPsiFile == null) {
            return;
        }
        DockerPsiFile dockerFile = dockerPsiFile;
        if (dockerFile.isContentsLoaded()) {
            this.buildCommentBlocks(descriptors, dockerFile);
        }
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    private final void buildCommentBlocks(List<FoldingDescriptor> descriptors, DockerPsiFile dockerFile) {
        PsiComment blockStart = null;
        for (PsiElement next = dockerFile.getFirstChild(); next != null; next = next.getNextSibling()) {
            String string;
            PsiElement psiElement = next;
            if (psiElement instanceof DockerPsiCommand) {
                blockStart = null;
                continue;
            }
            if (!(psiElement instanceof PsiComment)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((PsiComment)next).getText(), (String)"next.text");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (String)"##", (boolean)false, (int)2, null)) continue;
            if (blockStart == null) {
                blockStart = (PsiComment)next;
                continue;
            }
            TextRange textRange = blockStart.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"blockStart.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = ((PsiComment)next).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"next.textRange");
            TextRange range = new TextRange(n, textRange2.getEndOffset());
            descriptors.add(new FoldingDescriptor((PsiElement)dockerFile, range));
            blockStart = null;
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        PsiElement psiElement = node.getPsi();
        if (!(psiElement instanceof DockerPsiFile)) {
            psiElement = null;
        }
        DockerPsiFile dockerPsiFile = (DockerPsiFile)psiElement;
        if (dockerPsiFile == null) {
            return ELLIPSIS;
        }
        DockerPsiFile psiFile = dockerPsiFile;
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)((PsiFile)psiFile), (int)range.getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return ELLIPSIS;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiComment, (String)"PsiTreeUtil.findElementO\u2026       ?: return ELLIPSIS");
        PsiComment firstCommentInBlock = psiComment;
        return DockerFileFoldingBuilder.Companion.limitLength(com.intellij.docker.dockerFile.DockerFileFoldingBuilder$Companion.ensurePrefix$default(DockerFileFoldingBuilder.Companion, this.findFirstNonTrivialCommentText(firstCommentInBlock, range), "#", null, 2, null)) + ELLIPSIS;
    }

    private final String findFirstNonTrivialCommentText(PsiComment comment, TextRange range) {
        PsiComment current = comment;
        while (current != null && UtilsKt.getStartOffset((PsiElement)((PsiElement)current)) < range.getEndOffset()) {
            String string = current.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"current.text");
            String text = StringsKt.trim((String)string, (char[])new char[]{' ', '#'});
            CharSequence charSequence = text;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return text;
            }
            current = (PsiComment)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)current), PsiComment.class);
        }
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"comment.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0002J\f\u0010\n\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/DockerFileFoldingBuilder$Companion;", "", "()V", "ELLIPSIS", "", "MAX_PLACEHOLDER_LEN", "", "ensurePrefix", "prefix", "padding", "limitLength", "max", "intellij.clouds.docker.file"})
    public static final class Companion {
        private final String limitLength(String $this$limitLength) {
            return this.limitLength($this$limitLength, 40);
        }

        private final String limitLength(String $this$limitLength, int max) {
            String string = $this$limitLength;
            int n = 0;
            int n2 = RangesKt.coerceAtMost((int)max, (int)$this$limitLength.length());
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        private final String ensurePrefix(String $this$ensurePrefix, String prefix, String padding) {
            return StringsKt.startsWith$default((String)$this$ensurePrefix, (String)prefix, (boolean)false, (int)2, null) ? $this$ensurePrefix : prefix + padding + $this$ensurePrefix;
        }

        static /* synthetic */ String ensurePrefix$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 2) != 0) {
                string3 = " ";
            }
            return companion.ensurePrefix(string, string2, string3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

