/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.List;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.intellij.lang.xpath.xslt.impl.references.AttributeReference;
import org.intellij.lang.xpath.xslt.quickfix.CreateTemplateFix;
import org.intellij.lang.xpath.xslt.util.NamedTemplateMatcher;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TemplateReference
extends AttributeReference
implements EmptyResolveMessageProvider,
LocalQuickFixProvider,
PsiPolyVariantReference {
    private final String myName;

    TemplateReference(XmlAttribute attribute) {
        super(attribute, TemplateReference.createMatcher(attribute), false);
        this.myName = attribute.getValue();
    }

    private static ResolveUtil.Matcher createMatcher(XmlAttribute attribute) {
        return new NamedTemplateMatcher((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlDocument.class), attribute.getValue());
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiElement element = this.resolve();
        if (element != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(element)};
            if (resolveResultArray == null) {
                TemplateReference.$$$reportNull$$$0(0);
            }
            return resolveResultArray;
        }
        XmlFile xmlFile = (XmlFile)this.getElement().getContainingFile();
        if (xmlFile != null) {
            SmartList targets = new SmartList();
            XsltIncludeIndex.processBackwardDependencies(xmlFile, (Processor<? super XmlFile>)((Processor)arg_0 -> this.lambda$multiResolve$0((List)targets, arg_0)));
            ResolveResult[] resolveResultArray = targets.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                TemplateReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            TemplateReference.$$$reportNull$$$0(2);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public LocalQuickFix @Nullable [] getQuickFixes() {
        return new LocalQuickFix[]{new CreateTemplateFix(this.myAttribute.getParent(), this.myName)};
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XPathBundle.partialMessage("inspection.message.cannot.resolve.template", 1, new Object[0]);
        if (string == null) {
            TemplateReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    private /* synthetic */ boolean lambda$multiResolve$0(List targets, XmlFile xmlFile1) {
        PsiElement e = ResolveUtil.resolve(new NamedTemplateMatcher(xmlFile1.getDocument(), this.myName));
        if (e != null) {
            targets.add(new PsiElementResolveResult(e));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/references/TemplateReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

