/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;", "element", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Factory", "intellij.android.kotlin.idea"})
public final class KotlinAndroidViewConstructorFix
extends KotlinQuickFixAction<KtSuperTypeEntry> {
    private static final FqName fqNameAnnotation;
    private static final List<String> requiredConstructorParameterTypes;
    public static final Factory Factory;

    @NotNull
    public String getText() {
        return "Add Android View constructors using '@JvmOverloads'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return AndroidFacet.getInstance((PsiElement)((PsiElement)file)) != null;
    }

    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtSuperTypeEntry ktSuperTypeEntry = (KtSuperTypeEntry)this.getElement();
        if (ktSuperTypeEntry == null) {
            return;
        }
        KtSuperTypeEntry element = ktSuperTypeEntry;
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
        if (ktClass == null) {
            return;
        }
        KtClass ktClass2 = ktClass;
        KtPsiFactory factory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element), (boolean)false, (int)2, null);
        KtPrimaryConstructor newPrimaryConstructor = factory.createPrimaryConstructor("(\n            context: android.content.Context, attrs: android.util.AttributeSet? = null, defStyleAttr: Int = 0\n            )");
        PsiElement $this$replaced$iv = (PsiElement)KtClassKt.createPrimaryConstructorIfAbsent((KtClass)ktClass2);
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newPrimaryConstructor);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtPrimaryConstructor)) {
            psiElement2 = null;
        }
        if ((psiElement = (PsiElement)((KtPrimaryConstructor)psiElement2)) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
            }
            psiElement = (PsiElement)((KtPrimaryConstructor)ktExpression);
        }
        KtPrimaryConstructor primaryConstructor = (KtPrimaryConstructor)psiElement;
        KtParameterList ktParameterList = primaryConstructor.getValueParameterList();
        if (ktParameterList != null) {
            KtParameterList ktParameterList2 = ktParameterList;
            boolean bl = false;
            boolean bl2 = false;
            KtParameterList it = ktParameterList2;
            boolean bl3 = false;
            ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtElement)((KtElement)it), null, (int)2, null);
        }
        ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)primaryConstructor), (FqName)fqNameAnnotation, null, null, null, (int)14, null);
        element.replace((PsiElement)factory.createSuperTypeCallEntry(element.getText() + "(context, attrs, defStyleAttr)"));
    }

    public KotlinAndroidViewConstructorFix(@NotNull KtSuperTypeEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    static {
        Factory = new Factory(null);
        fqNameAnnotation = new FqName("kotlin.jvm.JvmOverloads");
        requiredConstructorParameterTypes = CollectionsKt.listOf((Object[])new String[]{"android.content.Context", "android.util.AttributeSet", "kotlin.Int"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\f\u001a\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0018\u00010\u0006*\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidViewConstructorFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "fqNameAnnotation", "Lorg/jetbrains/kotlin/name/FqName;", "requiredConstructorParameterTypes", "", "", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "constructorParameters", "Lorg/jetbrains/kotlin/types/KotlinType;", "getFqNameAsString", "isAndroidView", "", "intellij.android.kotlin.idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtTypeReference ktTypeReference;
            KtSuperTypeEntry superTypeEntry;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    Diagnostic diagnostic2 = Errors.SUPERTYPE_NOT_INITIALIZED.cast(diagnostic);
                    Intrinsics.checkNotNullExpressionValue((Object)diagnostic2, (String)"SUPERTYPE_NOT_INITIALIZED.cast(diagnostic)");
                    PsiElement psiElement = ((SimpleDiagnostic)diagnostic2).getPsiElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SUPERTYPE_NOT_INITIALIZE\u2026st(diagnostic).psiElement");
                    superTypeEntry = (KtSuperTypeEntry)psiElement;
                    KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)superTypeEntry));
                    if (ktClass == null) {
                        return null;
                    }
                    KtClass ktClass2 = ktClass;
                    if (ktClass2.getPrimaryConstructor() != null) {
                        return null;
                    }
                    BindingContext context = ResolutionUtils.analyze$default((KtElement)((KtElement)superTypeEntry), null, (int)1, null);
                    ktTypeReference = superTypeEntry.getTypeReference();
                    if (ktTypeReference == null) break block14;
                    KtTypeReference ktTypeReference2 = ktTypeReference;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtTypeReference it = ktTypeReference2;
                    boolean bl3 = false;
                    ktTypeReference = (KotlinType)context.get((ReadOnlySlice)BindingContext.TYPE, (Object)it);
                    if (ktTypeReference != null) break block15;
                }
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"superTypeEntry.typeRefer\u2026YPE, it] } ?: return null");
            KtTypeReference type = ktTypeReference;
            if (!this.isAndroidView((KotlinType)type)) {
                boolean bl;
                block13: {
                    Iterable $this$none$iv = TypeUtilsKt.supertypes((KotlinType)type);
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl4 = false;
                            if (!Factory.isAndroidView(it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            List<List<String>> list = this.constructorParameters((KotlinType)type);
            if (list == null) {
                return null;
            }
            List<List<String>> names = list;
            if (!names.contains(requiredConstructorParameterTypes)) {
                return null;
            }
            return (IntentionAction)new KotlinAndroidViewConstructorFix(superTypeEntry);
        }

        private final String getFqNameAsString(KotlinType $this$getFqNameAsString) {
            ClassifierDescriptor classifierDescriptor = $this$getFqNameAsString.getConstructor().getDeclarationDescriptor();
            return classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null;
        }

        private final boolean isAndroidView(KotlinType $this$isAndroidView) {
            return Intrinsics.areEqual((Object)this.getFqNameAsString($this$isAndroidView), (Object)"android.view.View");
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<String>> constructorParameters(KotlinType $this$constructorParameters) {
            void $this$mapTo$iv$iv;
            ClassifierDescriptor classifierDescriptor = $this$constructorParameters.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            Collection collection = classDescriptor2.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"classDescriptor.constructors");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void it;
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                List list = v3.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.valueParameters");
                Iterable $this$map$iv2 = list;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void parameter;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl2 = false;
                    void v5 = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"parameter");
                    KotlinType kotlinType = v5.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"parameter.type");
                    String string = Factory.getFqNameAsString(kotlinType);
                    collection3.add(string);
                }
                List list2 = (List)destination$iv$iv2;
                collection2.add(list2);
            }
            return (List)destination$iv$iv;
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

