/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.folding;

import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.folding.ResourceFoldingBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\tH\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000f*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0007*\u00020\u001aH\u0002J'\u0010\u001f\u001a\u0004\u0018\u00010\u000f*\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0082\u0010J\f\u0010%\u001a\u00020\u0004*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "()V", "isFoldingEnabled", "", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "formatArguments", "", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "formatString", "getPlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "getAndroidResourceType", "Lcom/android/resources/ResourceType;", "getAndroidResourceValue", "Lorg/jetbrains/uast/UReferenceExpression;", "resources", "Lcom/android/tools/idea/res/LocalResourceRepository;", "call", "getFoldingDescriptor", "getResourceValue", "Lcom/android/ide/common/resources/ResourceRepository;", "type", "name", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isFoldableGetResourceValueCall", "Companion", "intellij.android.kotlin.idea"})
public final class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private final boolean isFoldingEnabled;
    private static final Pattern FORMAT;
    private static final int FOLD_MAX_LENGTH = 60;
    private static final boolean UNIT_TEST_MODE;
    private static final List<ResourceType> RESOURCE_TYPES;
    public static final Companion Companion;

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Function2<UElement, LocalResourceRepository, String> $fun$unwrapReferenceAndGetValue$1 = new Function2<UElement, LocalResourceRepository, String>(this){
            final /* synthetic */ ResourceFoldingBuilder this$0;

            @Nullable
            public final String invoke(@NotNull UElement $this$unwrapReferenceAndGetValue, @NotNull LocalResourceRepository resources) {
                String string;
                UElement uElement;
                while (true) {
                    Intrinsics.checkNotNullParameter((Object)$this$unwrapReferenceAndGetValue, (String)"$this$unwrapReferenceAndGetValue");
                    Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
                    uElement = $this$unwrapReferenceAndGetValue;
                    if (!(uElement instanceof UQualifiedReferenceExpression)) break;
                    $this$unwrapReferenceAndGetValue = (UElement)((UQualifiedReferenceExpression)$this$unwrapReferenceAndGetValue).getSelector();
                }
                if (uElement instanceof UCallExpression) {
                    Object object = CollectionsKt.firstOrNull((List)((UCallExpression)$this$unwrapReferenceAndGetValue).getValueArguments());
                    if (!(object instanceof UReferenceExpression)) {
                        object = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)object;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.access$getAndroidResourceValue(this.this$0, uReferenceExpression, resources, (UCallExpression)$this$unwrapReferenceAndGetValue) : null;
                } else {
                    UElement uElement2 = $this$unwrapReferenceAndGetValue;
                    if (!(uElement2 instanceof UReferenceExpression)) {
                        uElement2 = null;
                    }
                    UReferenceExpression uReferenceExpression = (UReferenceExpression)uElement2;
                    string = uReferenceExpression != null ? ResourceFoldingBuilder.getAndroidResourceValue$default(this.this$0, uReferenceExpression, resources, null, 2, null) : null;
                }
                return string;
            }
            {
                this.this$0 = resourceFoldingBuilder;
                super(2);
            }
        };
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SourceTreeToPsiMap.treeE\u2026oPsi(node) ?: return null");
        PsiElement element = psiElement;
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance((PsiElement)element);
        if (resourceRepositoryManager == null || (resourceRepositoryManager = resourceRepositoryManager.getAppResources()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"ResourceRepositoryManage\u2026pResources ?: return null");
        ResourceRepositoryManager appResources = resourceRepositoryManager;
        UastContext uastContext = (UastContext)ServiceManager.getService((Project)element.getProject(), UastContext.class);
        if (uastContext == null) {
            return null;
        }
        UastContext uastContext2 = uastContext;
        UElement uElement = uastContext2.convertElement(element, null, null);
        return uElement != null ? $fun$unwrapReferenceAndGetValue$1.invoke(uElement, (LocalResourceRepository)appResources) : null;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof KtFile) || quick && !UNIT_TEST_MODE || !this.isFoldingEnabled || AndroidFacet.getInstance((PsiElement)root) == null) {
            return new FoldingDescriptor[0];
        }
        UElement file = UastContextKt.toUElement((PsiElement)root);
        boolean bl = false;
        ArrayList result = new ArrayList();
        UElement uElement = file;
        if (uElement != null) {
            uElement.accept((UastVisitor)new AbstractUastVisitor(this, result){
                final /* synthetic */ ResourceFoldingBuilder this$0;
                final /* synthetic */ ArrayList $result;

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        FoldingDescriptor foldingDescriptor = ResourceFoldingBuilder.access$getFoldingDescriptor(this.this$0, (UReferenceExpression)node);
                        if (foldingDescriptor == null) break block0;
                        FoldingDescriptor foldingDescriptor2 = foldingDescriptor;
                        boolean bl = false;
                        boolean bl2 = false;
                        FoldingDescriptor it = foldingDescriptor2;
                        boolean bl3 = false;
                        this.$result.add(it);
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
                {
                    this.this$0 = this$0;
                    this.$result = $captured_local_variable$1;
                }
            });
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FoldingDescriptor[] foldingDescriptorArray = thisCollection$iv.toArray(new FoldingDescriptor[0]);
        if (foldingDescriptorArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return foldingDescriptorArray;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isFoldingEnabled;
    }

    private final FoldingDescriptor getFoldingDescriptor(UReferenceExpression $this$getFoldingDescriptor) {
        UCallExpression getResourceValueCall;
        Object object;
        PsiElement psiElement = $this$getFoldingDescriptor.resolve();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolved = psiElement;
        ResourceType resourceType = this.getAndroidResourceType(resolved);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        if (!RESOURCE_TYPES.contains(resourceType2)) {
            return null;
        }
        getFoldingDescriptor.1 $fun$createFoldingDescriptor$1 = getFoldingDescriptor.1.INSTANCE;
        UElement uElement = $this$getFoldingDescriptor.getUastParent();
        if (!(uElement instanceof UQualifiedReferenceExpression)) {
            uElement = null;
        }
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)uElement;
        UReferenceExpression element = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : $this$getFoldingDescriptor;
        UElement uElement2 = element.getUastParent();
        if (!(uElement2 instanceof UCallExpression)) {
            uElement2 = null;
        }
        UCallExpression uCallExpression = (UCallExpression)uElement2;
        if (uCallExpression != null) {
            UCallExpression uCallExpression2 = uCallExpression;
            boolean bl = false;
            boolean bl2 = false;
            UCallExpression it = uCallExpression2;
            boolean bl3 = false;
            object = this.isFoldableGetResourceValueCall(it) ? uCallExpression2 : null;
        } else {
            object = getResourceValueCall = null;
        }
        if (getResourceValueCall != null) {
            UQualifiedReferenceExpression qualifiedCall;
            UElement uElement3 = getResourceValueCall.getUastParent();
            if (!(uElement3 instanceof UQualifiedReferenceExpression)) {
                uElement3 = null;
            }
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = qualifiedCall = (UQualifiedReferenceExpression)uElement3;
            if (Intrinsics.areEqual((Object)(uQualifiedReferenceExpression2 != null ? uQualifiedReferenceExpression2.getSelector() : null), (Object)getResourceValueCall)) {
                return $fun$createFoldingDescriptor$1.invoke((UElement)qualifiedCall);
            }
            return $fun$createFoldingDescriptor$1.invoke((UElement)getResourceValueCall);
        }
        return $fun$createFoldingDescriptor$1.invoke((UElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFoldableGetResourceValueCall(UCallExpression $this$isFoldableGetResourceValueCall) {
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getString")) return true;
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getText")) return true;
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getInteger")) return true;
        String string = $this$isFoldableGetResourceValueCall.getMethodName();
        if (string != null ? StringsKt.startsWith$default((String)string, (String)"getDimension", (boolean)false, (int)2, null) : false) return true;
        String string2 = $this$isFoldableGetResourceValueCall.getMethodName();
        if (string2 == null) return false;
        boolean bl = StringsKt.startsWith$default((String)string2, (String)"getQuantityString", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    private final ResourceType getAndroidResourceType(PsiElement $this$getAndroidResourceType) {
        PsiElement psiElement = $this$getAndroidResourceType.getParent();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return null;
        }
        PsiClass elementType = psiClass;
        PsiElement psiElement2 = elementType.getParent();
        if (!(psiElement2 instanceof PsiClass)) {
            psiElement2 = null;
        }
        PsiClass psiClass2 = (PsiClass)psiElement2;
        if (psiClass2 == null) {
            return null;
        }
        PsiClass elementPackage = psiClass2;
        if (Intrinsics.areEqual((Object)"R", (Object)elementPackage.getName()) ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)elementPackage.getQualifiedName(), (Object)"android.R") ^ true) {
            ResourceType resourceType;
            String string = elementType.getName();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String p1 = string2;
                boolean bl3 = false;
                resourceType = ResourceType.fromClassName((String)p1);
            } else {
                resourceType = null;
            }
            return resourceType;
        }
        return null;
    }

    private final String getAndroidResourceValue(UReferenceExpression $this$getAndroidResourceValue, LocalResourceRepository resources, UCallExpression call) {
        String text;
        PsiElement psiElement = $this$getAndroidResourceValue.resolve();
        if (psiElement == null || (psiElement = this.getAndroidResourceType(psiElement)) == null) {
            return null;
        }
        PsiElement resourceType = psiElement;
        FolderConfiguration folderConfiguration = new FolderConfiguration();
        boolean bl = false;
        boolean bl2 = false;
        FolderConfiguration $this$apply = folderConfiguration;
        boolean bl3 = false;
        $this$apply.setLocaleQualifier(new LocaleQualifier("xx"));
        FolderConfiguration referenceConfig = folderConfiguration;
        String string = $this$getAndroidResourceValue.getResolvedName();
        if (string == null) {
            return null;
        }
        String key = string;
        String string2 = this.getResourceValue((ResourceRepository)resources, (ResourceType)resourceType, key, referenceConfig);
        if (string2 == null) {
            return null;
        }
        String resourceValue = string2;
        String string3 = text = call != null ? this.formatArguments(call, resourceValue) : resourceValue;
        if (resourceType == ResourceType.STRING || resourceType == ResourceType.PLURALS) {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '\"';
            String string4 = StringUtil.shortenTextWithEllipsis((String)text, (int)58, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.shortenTextWi\u2026, FOLD_MAX_LENGTH - 2, 0)");
            String string5 = string4;
            boolean bl4 = false;
            return stringBuilder.append(String.valueOf(c) + string5).append('\"').toString();
        }
        if (text.length() <= 1) {
            return key + ": " + text;
        }
        return StringUtil.shortenTextWithEllipsis((String)text, (int)60, (int)0);
    }

    static /* synthetic */ String getAndroidResourceValue$default(ResourceFoldingBuilder resourceFoldingBuilder, UReferenceExpression uReferenceExpression, LocalResourceRepository localResourceRepository, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return resourceFoldingBuilder.getAndroidResourceValue(uReferenceExpression, localResourceRepository, uCallExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final String getResourceValue(ResourceRepository $this$getResourceValue, ResourceType type, String name, FolderConfiguration referenceConfig) {
        Object object;
        while ((object = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)$this$getResourceValue, (ResourceType)type, (String)name, (FolderConfiguration)referenceConfig)) != null && (object = object.getValue()) != null) {
            ResourceType referencedType;
            void referencedTypeName;
            Object object2;
            Object value = object;
            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)value), (char)'@', (boolean)false, (int)2, null)) {
                return value;
            }
            Object object3 = value;
            int n = 1;
            boolean bl = false;
            Object object4 = object3;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            object3 = StringsKt.split$default((CharSequence)string, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null);
            n = 0;
            bl = false;
            Object it = object3;
            boolean bl2 = false;
            Object object5 = it.size() == 2 ? object3 : null;
            if (object5 == null) {
                return value;
            }
            object3 = object2 = object5;
            n = 0;
            String string2 = (String)object3.get(0);
            object3 = object2;
            n = 0;
            String referencedName = (String)object3.get(1);
            if (ResourceType.fromXmlValue((String)referencedTypeName) == null) {
                return value;
            }
            name = referencedName;
            type = referencedType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatArguments(UCallExpression callExpression, String formatString) {
        if (!StringsKt.contains$default((CharSequence)formatString, (char)'%', (boolean)false, (int)2, null)) {
            return formatString;
        }
        List args = callExpression.getValueArguments();
        if (args.isEmpty() || !((UExpression)CollectionsKt.first((List)args)).isPsiValid()) {
            return formatString;
        }
        Matcher matcher = FORMAT.matcher(formatString);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start = 0;
        StringBuilder sb = new StringBuilder(2 * formatString.length());
        while (matcher.find(index)) {
            int n;
            int n2;
            if (Intrinsics.areEqual((Object)"%", (Object)matcher.group(6))) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = formatString.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            index = matcher.end();
            int number = 0;
            String numberString = matcher.group(1);
            if (numberString != null) {
                String string = numberString;
                int n3 = 0;
                n2 = numberString.length() - 1;
                n = 0;
                String string2 = string.substring(n3, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                numberString = string2;
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.size()) continue;
            UExpression argExpression = (UExpression)args.get(number);
            Object value = argExpression.evaluate();
            if (value == null) {
                value = ((UExpression)args.get(number)).asSourceString();
            }
            n2 = start;
            n = matchStart;
            while (n2 < n) {
                void i;
                sb.append(formatString.charAt((int)i));
                ++i;
            }
            sb.append("{");
            sb.append(value);
            sb.append('}');
            start = index;
        }
        int n = formatString.length();
        for (int i = start; i < n; ++i) {
            sb.append(formatString.charAt(i));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public ResourceFoldingBuilder() {
        AndroidFoldingSettings androidFoldingSettings = AndroidFoldingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidFoldingSettings, (String)"AndroidFoldingSettings.getInstance()");
        this.isFoldingEnabled = androidFoldingSettings.isCollapseAndroidStrings();
    }

    static {
        Companion = new Companion(null);
        FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        UNIT_TEST_MODE = application.isUnitTestMode();
        RESOURCE_TYPES = CollectionsKt.listOf((Object[])new ResourceType[]{ResourceType.STRING, ResourceType.DIMEN, ResourceType.INTEGER, ResourceType.PLURALS});
    }

    public static final /* synthetic */ String access$getAndroidResourceValue(ResourceFoldingBuilder $this, UReferenceExpression $this$access_u24getAndroidResourceValue, LocalResourceRepository resources, UCallExpression call) {
        return $this.getAndroidResourceValue($this$access_u24getAndroidResourceValue, resources, call);
    }

    public static final /* synthetic */ FoldingDescriptor access$getFoldingDescriptor(ResourceFoldingBuilder $this, UReferenceExpression $this$access_u24getFoldingDescriptor) {
        return $this.getFoldingDescriptor($this$access_u24getFoldingDescriptor);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder$Companion;", "", "()V", "FOLD_MAX_LENGTH", "", "FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RESOURCE_TYPES", "", "Lcom/android/resources/ResourceType;", "UNIT_TEST_MODE", "", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

