/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/android/tools/idea/gradle/project/model/JavaModuleModel;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "findLibraryByBinaryPath", "Lcom/intellij/openapi/roots/libraries/Library;", "path", "Ljava/io/File;", "intellij.android.kotlin.idea"})
public final class KotlinAndroidGradleLibraryDataService
extends AbstractProjectDataService<JavaModuleModel, Void> {
    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        Key key = AndroidProjectKeys.JAVA_MODULE_MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"AndroidProjectKeys.JAVA_MODULE_MODEL");
        return key;
    }

    public void postProcess(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<JavaModuleModel> dataNode : toImport) {
            DataNode dataNode2 = dataNode.getParent();
            if (dataNode2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.DataNode<com.intellij.openapi.externalSystem.model.project.ModuleData>");
            }
            IdePlatformKind idePlatformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformKindByPlugin((DataNode)dataNode2);
            PersistentLibraryKind targetLibraryKind = idePlatformKind != null && (idePlatformKind = IdePlatformKindToolingKt.getTooling((IdePlatformKind)idePlatformKind)) != null ? idePlatformKind.getLibraryKind() : null;
            if (targetLibraryKind == null) continue;
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dataNode.data");
            Iterator iterator = ((JavaModuleModel)object).getJarLibraryDependencies().iterator();
            while (iterator.hasNext()) {
                PersistentLibraryKind persistentLibraryKind;
                LibraryEx library;
                JarLibraryDependency dep;
                JarLibraryDependency jarLibraryDependency = dep = (JarLibraryDependency)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)jarLibraryDependency, (String)"dep");
                if ((LibraryEx)this.findLibraryByBinaryPath(modelsProvider, jarLibraryDependency.getBinaryPath()) == null) {
                    continue;
                }
                if (library.getKind() != null) continue;
                Library.ModifiableModel modifiableModel = modelsProvider.getModifiableLibraryModel((Library)library);
                if (modifiableModel == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
                }
                LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)modifiableModel;
                VirtualFile[] virtualFileArray = model.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"model.getFiles(OrderRootType.CLASSES)");
                if (LibraryKindsKt.detectLibraryKind((VirtualFile[])virtualFileArray) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                PersistentLibraryKind it = persistentLibraryKind;
                boolean bl3 = false;
                model.setKind(it);
            }
        }
    }

    private final Library findLibraryByBinaryPath(IdeModifiableModelsProvider $this$findLibraryByBinaryPath, File path) {
        Library library;
        block2: {
            if (path == null) {
                return null;
            }
            String string = FilePaths.pathToIdeaUrl((File)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FilePaths.pathToIdeaUrl(path)");
            String url = string;
            Library[] libraryArray = $this$findLibraryByBinaryPath.getAllLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"allLibraries");
            Library[] $this$firstOrNull$iv = libraryArray;
            boolean $i$f$firstOrNull = false;
            Library[] libraryArray2 = $this$firstOrNull$iv;
            int n = libraryArray2.length;
            for (int i = 0; i < n; ++i) {
                Library element$iv;
                Library it = element$iv = libraryArray2[i];
                boolean bl = false;
                Object[] objectArray = $this$findLibraryByBinaryPath.getModifiableLibraryModel(it).getUrls(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getModifiableLibraryMode\u2026ls(OrderRootType.CLASSES)");
                if (!ArraysKt.contains((Object[])objectArray, (Object)url)) continue;
                library = element$iv;
                break block2;
            }
            library = null;
        }
        return library;
    }
}

