/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;
import org.jetbrains.plugins.gradle.service.project.data.javaee.JavaeeProjectDataService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class JeeArtifactBuildTasksProvider
implements GradleBuildTasksProvider {
    public boolean isApplicable(@NotNull ProjectModelBuildTask artifactBuildTask) {
        ProjectModelBuildableElement buildableElement;
        if (artifactBuildTask == null) {
            JeeArtifactBuildTasksProvider.$$$reportNull$$$0(0);
        }
        if (!((buildableElement = artifactBuildTask.getBuildableElement()) instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)buildableElement;
        GradleArtifactPropertiesProvider artifactPropertiesProvider = GradleArtifactPropertiesProvider.getInstance();
        if (artifactPropertiesProvider == null) {
            return false;
        }
        ArtifactProperties artifactProperties = artifact.getProperties((ArtifactPropertiesProvider)artifactPropertiesProvider);
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return false;
        }
        Optional<Project> project = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).filter(p -> artifact.equals(ArtifactManager.getInstance((Project)p).findArtifact(artifact.getName()))).findFirst();
        if (project.isEmpty()) {
            return false;
        }
        String projectPath = ((GradleArtifactProperties)((Object)artifactProperties.getState())).getExternalProjectPath();
        return StringUtil.isNotEmpty((String)projectPath) && GradleProjectSettings.isDelegatedBuildEnabled((Project)project.get(), (String)projectPath);
    }

    public void addBuildTasks(@NotNull ProjectModelBuildTask artifactBuildTask, @NotNull Consumer<ExternalTaskPojo> cleanTasksConsumer, @NotNull Consumer<ExternalTaskPojo> buildTasksConsumer) {
        if (artifactBuildTask == null) {
            JeeArtifactBuildTasksProvider.$$$reportNull$$$0(1);
        }
        if (cleanTasksConsumer == null) {
            JeeArtifactBuildTasksProvider.$$$reportNull$$$0(2);
        }
        if (buildTasksConsumer == null) {
            JeeArtifactBuildTasksProvider.$$$reportNull$$$0(3);
        }
        ProjectModelBuildableElement buildableElement = artifactBuildTask.getBuildableElement();
        assert (buildableElement instanceof Artifact);
        Artifact artifact = (Artifact)buildableElement;
        ArtifactProperties<GradleArtifactProperties> artifactProperties = JavaeeProjectDataService.getGradleArtifactProperties(artifact);
        if (artifactProperties == null) {
            return;
        }
        GradleArtifactProperties gradleArtifactProperties = (GradleArtifactProperties)((Object)artifactProperties.getState());
        assert (gradleArtifactProperties != null);
        String projectPath = gradleArtifactProperties.getExternalProjectPath();
        if (WebArtifactUtil.getInstance().isWebApplication(artifact.getArtifactType())) {
            if (!artifactBuildTask.isIncrementalBuild()) {
                cleanTasksConsumer.consume((Object)new ExternalTaskPojo("cleanWar", projectPath, null));
            }
            buildTasksConsumer.consume((Object)new ExternalTaskPojo("war", projectPath, null));
        } else if (JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifact.getArtifactType())) {
            if (!artifactBuildTask.isIncrementalBuild()) {
                cleanTasksConsumer.consume((Object)new ExternalTaskPojo("cleanEar", projectPath, null));
            }
            buildTasksConsumer.consume((Object)new ExternalTaskPojo("ear", projectPath, null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactBuildTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanTasksConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTasksConsumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/data/javaee/JeeArtifactBuildTasksProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildTasks";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

