/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.runConfiguration;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainersManager;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ArquillianSettingsConfigurable;
import com.intellij.plugins.jboss.arquillian.runConfiguration.ArquillianRunConfiguration;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ArquillianConfigurationPanel
extends SettingsEditor<ArquillianRunConfiguration> {
    private final Project project;
    private ButtonGroup buttonGroup;
    private List<JBRadioButton> buttons;
    private JBRadioButton selectedButton;
    private String selectedName;
    private JPanel mainPanel;
    private JPanel frameworksPanel;
    private JButton configureButton;

    public ArquillianConfigurationPanel(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        this.configureButton.addActionListener(e -> {
            ArquillianSettingsConfigurable configurable = new ArquillianSettingsConfigurable(project);
            if (ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable)) {
                this.refreshContainerList();
                this.setSelection(this.selectedName);
            }
        });
    }

    private void setSelection(String name) {
        for (JBRadioButton button2 : this.buttons) {
            button2.setSelected(false);
        }
        this.selectedName = name;
        this.selectedButton = (JBRadioButton)JBIterable.from(this.buttons).filter(button -> button.getText().equals(this.selectedName)).first();
        if (this.selectedButton != null) {
            this.selectedButton.setSelected(true);
        }
    }

    protected void resetEditorFrom(@NotNull ArquillianRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            ArquillianConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.setSelection(runConfiguration.getContainerStateName());
    }

    protected void applyEditorTo(@NotNull ArquillianRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            ArquillianConfigurationPanel.$$$reportNull$$$0(1);
        }
        runConfiguration.setContainerStateName(this.selectedName);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            ArquillianConfigurationPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void refreshContainerList() {
        this.frameworksPanel.removeAll();
        this.buttonGroup = new ButtonGroup();
        ArrayList<ArquillianContainerState> states = new ArrayList<ArquillianContainerState>(ArquillianContainersManager.getInstance((Project)this.project).getState().containers);
        Collections.sort(states);
        this.buttons = ContainerUtil.map(states, containerState -> {
            JBRadioButton button = new JBRadioButton(containerState.getName());
            button.setHorizontalAlignment(2);
            this.frameworksPanel.add((Component)button);
            this.buttonGroup.add((AbstractButton)button);
            button.addChangeListener(e -> {
                if (button.isSelected()) {
                    this.selectedButton = button;
                    this.selectedName = button.getText();
                }
            });
            return button;
        });
    }

    private void createUIComponents() {
        this.frameworksPanel = new JPanel();
        this.frameworksPanel.setLayout(new BoxLayout(this.frameworksPanel, 1));
        this.refreshContainerList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianConfigurationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/jboss/arquillian/runConfiguration/ArquillianConfigurationPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = this.frameworksPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.configureButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ArquillianBundle", ArquillianConfigurationPanel.class).getString("arquillian.settings.configure"));
        jPanel.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

