/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArquillianDeploymentSignatureInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static void checkModifiersAndReturnType(@NotNull PsiMethod method, @NotNull PsiAnnotation deploymentAnnotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(0);
        }
        if (deploymentAnnotation == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(2);
        }
        ArrayList<LocalQuickFixAndIntentionActionOnPsiElement> fixes = new ArrayList<LocalQuickFixAndIntentionActionOnPsiElement>();
        if (!method.hasModifierProperty("static")) {
            fixes.add(QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, "static", true, true));
        }
        if (!method.hasModifierProperty("public")) {
            fixes.add(QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, "public", true, true));
        }
        if (fixes.isEmpty()) {
            return;
        }
        holder.registerProblem((PsiElement)deploymentAnnotation, ArquillianBundle.message("arquillian.deployment.wrong.signature", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static void checkWrongParameterCount(@NotNull PsiMethod method, @NotNull PsiAnnotation deploymentAnnotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(3);
        }
        if (deploymentAnnotation == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(5);
        }
        RemoveAnnotationQuickFix removeAnnotationQuickFix = new RemoveAnnotationQuickFix(deploymentAnnotation, (PsiModifierListOwner)method);
        IntentionAction changeMethodSignatureFix = QuickFixFactory.getInstance().createChangeMethodSignatureFromUsageFix(method, PsiExpression.EMPTY_ARRAY, (PsiSubstitutor)EmptySubstitutor.getInstance(), (PsiElement)method, false, 111);
        holder.registerProblem((PsiElement)deploymentAnnotation, ArquillianBundle.message("arquillian.deployment.wrong.signature", new Object[0]), new LocalQuickFix[]{new IntentionWrapper(changeMethodSignatureFix, method.getContainingFile()), removeAnnotationQuickFix});
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation deploymentAnnotation;
        if (method == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            ArquillianDeploymentSignatureInspection.$$$reportNull$$$0(7);
        }
        if ((deploymentAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.jboss.arquillian.container.test.api.Deployment"})) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
        if (method.getParameterList().getParametersCount() > 0) {
            ArquillianDeploymentSignatureInspection.checkWrongParameterCount(method, deploymentAnnotation, holder);
        }
        ArquillianDeploymentSignatureInspection.checkModifiersAndReturnType(method, deploymentAnnotation, holder);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentAnnotation";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkModifiersAndReturnType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWrongParameterCount";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

