/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ui;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModel;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ConfigurationSpecificState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerMode;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerModel;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerTransport;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteJVMSettingsCoordinator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class RemoteDebuggerPanel
extends JPanel {
    private JCheckBox remoteDebugCheckBox;
    private JBRadioButton socketJBRadioButton;
    private JBRadioButton sharedMemoryJBRadioButton;
    private JBRadioButton attachJBRadioButton;
    private JBRadioButton listenJBRadioButton;
    private JPanel settingsPanel;
    private JPanel socketSettingsPanel;
    private JPanel sharedMemorySettingsPanel;
    private JBTextField hostTextField;
    private JBTextField portTextField;
    private JBTextField sharedMemoryAddressTextField;
    private JPanel mainPanel;
    private JBLabel hostLabel;
    private JBLabel portLabel;
    private JBLabel sharedMemoryAddressLabel;
    private ConfigurationArgumentsHelpArea helpArea;
    private ConfigurationArgumentsHelpArea jdk14HelpArea;
    private ConfigurationArgumentsHelpArea jdk13HelpArea;
    private JPanel configurationPanel;
    @NotNull
    private final RemoteDebuggerModel model;

    public RemoteDebuggerPanel(final @NotNull RemoteDebuggerModel model) {
        if (model == null) {
            RemoteDebuggerPanel.$$$reportNull$$$0(0);
        }
        this.model = model;
        this.$$$setupUI$$$();
        this.hostLabel.setLabelFor((Component)this.hostTextField);
        this.portLabel.setLabelFor((Component)this.portTextField);
        this.sharedMemoryAddressLabel.setLabelFor((Component)this.sharedMemoryAddressTextField);
        this.hostTextField.setText(model.getHost());
        this.portTextField.setText(model.getPort());
        this.sharedMemoryAddressTextField.setText(model.getSharedMemoryAddress());
        this.helpArea.setLabelText(ExecutionBundle.message((String)"remote.configuration.remote.debugging.allows.you.to.connect.idea.to.a.running.jvm.label", (Object[])new Object[0]));
        this.helpArea.setToolbarVisible();
        this.jdk13HelpArea.setLabelText(ExecutionBundle.message((String)"environment.variables.helper.use.arguments.jdk13.label", (Object[])new Object[0]));
        this.jdk13HelpArea.setToolbarVisible();
        this.jdk14HelpArea.setLabelText(ExecutionBundle.message((String)"environment.variables.helper.use.arguments.jdk14.label", (Object[])new Object[0]));
        this.jdk14HelpArea.setToolbarVisible();
        this.configurationPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ArquillianBundle.message("arquillian.settings.title", new Object[0])));
        this.modelChanged();
        model.addChangeListener(new ArquillianModel.Listener<ConfigurationSpecificState, RemoteDebuggerModel>(){

            @Override
            public void itemChanged(RemoteDebuggerModel model) {
                RemoteDebuggerPanel.this.modelChanged();
            }
        });
        this.remoteDebugCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setEnabled(RemoteDebuggerPanel.this.remoteDebugCheckBox.isSelected());
            }
        });
        this.hostTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                model.setHost(RemoteDebuggerPanel.this.hostTextField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/ui/RemoteDebuggerPanel$3", "textChanged"));
            }
        });
        this.portTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                model.setPort(RemoteDebuggerPanel.this.portTextField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/ui/RemoteDebuggerPanel$4", "textChanged"));
            }
        });
        this.sharedMemoryAddressTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                model.setSharedMemoryAddress(RemoteDebuggerPanel.this.sharedMemoryAddressTextField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/ui/RemoteDebuggerPanel$5", "textChanged"));
            }
        });
        this.socketJBRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setTransport(RemoteDebuggerPanel.this.socketJBRadioButton.isSelected() ? RemoteDebuggerTransport.Socket : RemoteDebuggerTransport.SharedMemory);
            }
        });
        this.sharedMemoryJBRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setTransport(RemoteDebuggerPanel.this.socketJBRadioButton.isSelected() ? RemoteDebuggerTransport.Socket : RemoteDebuggerTransport.SharedMemory);
            }
        });
        this.listenJBRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setMode(RemoteDebuggerPanel.this.listenJBRadioButton.isSelected() ? RemoteDebuggerMode.Listen : RemoteDebuggerMode.Attach);
            }
        });
        this.attachJBRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setMode(RemoteDebuggerPanel.this.listenJBRadioButton.isSelected() ? RemoteDebuggerMode.Listen : RemoteDebuggerMode.Attach);
            }
        });
    }

    void modelChanged() {
        this.setRemoteDebuggerEnabled(this.model.isEnabled());
        this.setTransport(this.model.getTransport());
        this.setMode(this.model.getMode());
        RemoteJVMSettingsCoordinator.RemoteJVMSettings remoteJVMSettings = this.model.getRemoteJVMSettings();
        this.helpArea.updateText(remoteJVMSettings.jvmSettings);
        this.jdk13HelpArea.updateText(remoteJVMSettings.jvm13Settings);
        this.jdk14HelpArea.updateText(remoteJVMSettings.jvm14Settings);
        this.mainPanel.revalidate();
    }

    private void setRemoteDebuggerEnabled(boolean enabled) {
        this.remoteDebugCheckBox.setSelected(enabled);
        this.settingsPanel.setVisible(enabled);
    }

    private void setTransport(RemoteDebuggerTransport transport) {
        if (transport == RemoteDebuggerTransport.Socket) {
            this.socketJBRadioButton.setSelected(true);
            this.socketSettingsPanel.setVisible(true);
            this.sharedMemorySettingsPanel.setVisible(false);
        } else {
            this.sharedMemoryJBRadioButton.setSelected(true);
            this.sharedMemorySettingsPanel.setVisible(true);
            this.socketSettingsPanel.setVisible(false);
        }
    }

    private void setMode(RemoteDebuggerMode mode) {
        if (mode == RemoteDebuggerMode.Attach) {
            this.attachJBRadioButton.setSelected(true);
            this.hostTextField.setEnabled(true);
        } else {
            this.listenJBRadioButton.setSelected(true);
            this.hostTextField.setEnabled(false);
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/ui/RemoteDebuggerPanel", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBTextField jBTextField;
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        JBTextField jBTextField2;
        JBLabel jBLabel3;
        JBTextField jBTextField3;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JPanel jPanel3;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea2;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.mainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setPreferredSize(new Dimension(-1, -1));
        this.settingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.helpArea = configurationArgumentsHelpArea3 = new ConfigurationArgumentsHelpArea();
        configurationArgumentsHelpArea3.setVisible(true);
        jPanel6.add((Component)configurationArgumentsHelpArea3, new GridConstraints(0, 0, 1, 1, 9, 1, 3, 0, null, null, null));
        this.jdk14HelpArea = configurationArgumentsHelpArea2 = new ConfigurationArgumentsHelpArea();
        configurationArgumentsHelpArea2.setVisible(true);
        jPanel6.add((Component)configurationArgumentsHelpArea2, new GridConstraints(1, 0, 1, 1, 9, 1, 3, 0, null, null, null));
        this.jdk13HelpArea = configurationArgumentsHelpArea = new ConfigurationArgumentsHelpArea();
        configurationArgumentsHelpArea.setVisible(true);
        jPanel6.add((Component)configurationArgumentsHelpArea, new GridConstraints(2, 0, 1, 1, 9, 1, 3, 0, null, null, null));
        this.configurationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.transport"));
        jPanel7.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.mode"));
        jPanel7.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.socketJBRadioButton = jBRadioButton4 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton4, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.transport.socket"));
        jPanel7.add((Component)jBRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.sharedMemoryJBRadioButton = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.transport.shared.memory"));
        jPanel7.add((Component)jBRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.attachJBRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.mode.attach"));
        jPanel7.add((Component)jBRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.listenJBRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.mode.listen"));
        jPanel7.add((Component)jBRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.socketSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.hostTextField = jBTextField3 = new JBTextField();
        jBTextField3.setText("");
        jPanel2.add((Component)jBTextField3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 3, new Dimension(200, -1), new Dimension(200, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.portLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.port"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.portTextField = jBTextField2 = new JBTextField();
        jPanel2.add((Component)jBTextField2, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, new Dimension(100, -1), new Dimension(100, -1), null));
        this.hostLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.host"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.sharedMemorySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.sharedMemoryAddressLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug.shared.memory.address"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.sharedMemoryAddressTextField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(300, -1), null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.remoteDebugCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ArquillianBundle", RemoteDebuggerPanel.class).getString("arquillian.remote.debug"));
        jPanel8.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(107, 36), null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

