/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger;

import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerMode;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerSettingsState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerTransport;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteJVMSettingsCoordinator {
    private final Map<RemoteDebuggerSettingsState, RemoteJVMSettings> results;
    @NotNull
    private final Callback callback;
    @NotNull
    private final Project project;
    @NotNull
    public static final RemoteJVMSettings inProgressStateSettings = new RemoteJVMSettings("Evaluating...", "Evaluating...", "Evaluating...");

    public RemoteJVMSettingsCoordinator(@NotNull Project project, @NotNull Callback callback) {
        if (project == null) {
            RemoteJVMSettingsCoordinator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            RemoteJVMSettingsCoordinator.$$$reportNull$$$0(1);
        }
        this.results = new HashMap<RemoteDebuggerSettingsState, RemoteJVMSettings>();
        this.callback = callback;
        this.project = project;
    }

    public void retrieveSettingsForState(final RemoteDebuggerSettingsState state) {
        RemoteJVMSettings settings = this.results.get(state);
        if (settings == null) {
            settings = inProgressStateSettings;
            this.results.put(state, settings);
            ApplicationManager.getApplication().invokeLater(() -> new Task.Backgroundable(this.project, ArquillianBundle.message("arquillian.jvm.args.retrieve", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RemoteJVMSettings settings = RemoteJVMSettingsCoordinator.doRetrieveRemoteJVMSettings(state);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        RemoteJVMSettingsCoordinator.this.results.put(state, settings);
                        RemoteJVMSettingsCoordinator.this.callback.settingsForState(state, settings);
                    }, ModalityState.any());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteJVMSettingsCoordinator$1", "run"));
                }
            }.queue(), ModalityState.any());
        }
        this.callback.settingsForState(state, settings);
    }

    private static RemoteJVMSettings doRetrieveRemoteJVMSettings(RemoteDebuggerSettingsState state) {
        boolean useSockets = state.transport == RemoteDebuggerTransport.Socket;
        RemoteConnection connection = new RemoteConnection(useSockets, state.host, useSockets ? state.port.trim() : state.sharedMemoryAddress.trim(), state.mode == RemoteDebuggerMode.Listen);
        String cmdLine = connection.getLaunchCommandLine();
        String jvmtiCmdLine = cmdLine.replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
        return new RemoteJVMSettings("-Xnoagent -Djava.compiler=NONE " + cmdLine, cmdLine, jvmtiCmdLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteJVMSettingsCoordinator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemoteJVMSettings {
        @NotNull
        public final String jvmSettings;
        @NotNull
        public final String jvm14Settings;
        @NotNull
        public final String jvm13Settings;

        public RemoteJVMSettings(@NotNull String jvm13Settings, @NotNull String jvm14Settings, @NotNull String jvmSettings) {
            if (jvm13Settings == null) {
                RemoteJVMSettings.$$$reportNull$$$0(0);
            }
            if (jvm14Settings == null) {
                RemoteJVMSettings.$$$reportNull$$$0(1);
            }
            if (jvmSettings == null) {
                RemoteJVMSettings.$$$reportNull$$$0(2);
            }
            this.jvm13Settings = jvm13Settings;
            this.jvm14Settings = jvm14Settings;
            this.jvmSettings = jvmSettings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteJVMSettings settings = (RemoteJVMSettings)o;
            if (!this.jvmSettings.equals(settings.jvmSettings)) {
                return false;
            }
            if (!this.jvm14Settings.equals(settings.jvm14Settings)) {
                return false;
            }
            return this.jvm13Settings.equals(settings.jvm13Settings);
        }

        public int hashCode() {
            int result = this.jvmSettings.hashCode();
            result = 31 * result + this.jvm14Settings.hashCode();
            result = 31 * result + this.jvm13Settings.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jvm13Settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jvm14Settings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jvmSettings";
                    break;
                }
            }
            objectArray[1] = "com/intellij/plugins/jboss/arquillian/configuration/remoteDebugger/RemoteJVMSettingsCoordinator$RemoteJVMSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Callback {
        public void settingsForState(RemoteDebuggerSettingsState var1, RemoteJVMSettings var2);
    }
}

