/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class ArquillianMavenLibraryModel
extends ArquillianLibraryModel {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private String version;
    private boolean downloadSources;
    private boolean downloadJavaDocs;

    public ArquillianMavenLibraryModel(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(1);
        }
        if (version == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(2);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArquillianMavenLibraryModel(ArquillianMavenLibraryState state) {
        this.groupId = state.groupId;
        this.artifactId = state.artifactId;
        this.version = state.version;
        this.downloadSources = state.downloadSources;
        this.downloadJavaDocs = state.downloadJavaDocs;
    }

    @Override
    public boolean hasChanges(ArquillianLibraryState state) {
        if (!(state instanceof ArquillianMavenLibraryState)) {
            return true;
        }
        ArquillianMavenLibraryState mavenLibraryState = (ArquillianMavenLibraryState)state;
        return !this.groupId.equals(mavenLibraryState.groupId) || !this.artifactId.equals(mavenLibraryState.artifactId) || !this.version.equals(mavenLibraryState.version) || this.downloadSources != mavenLibraryState.downloadSources || this.downloadJavaDocs != mavenLibraryState.downloadJavaDocs;
    }

    @Override
    public ArquillianMavenLibraryState getCurrentState() {
        return new ArquillianMavenLibraryState(this.groupId, this.artifactId, this.version, this.downloadSources, this.downloadJavaDocs);
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.version;
        if (string == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            ArquillianMavenLibraryModel.$$$reportNull$$$0(6);
        }
        this.version = version;
        this.notifyMeChanged();
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
        this.notifyMeChanged();
    }

    public boolean isDownloadJavaDocs() {
        return this.downloadJavaDocs;
    }

    public void setDownloadJavaDocs(boolean downloadJavaDocs) {
        this.downloadJavaDocs = downloadJavaDocs;
        this.notifyMeChanged();
    }

    @Override
    public String getDescription() {
        return RepositoryLibraryDescription.findDescription((String)this.groupId, (String)this.artifactId).getDisplayName(this.version);
    }

    @Override
    public Icon getIcon() {
        return RepositoryLibraryType.getInstance().getIcon(new RepositoryLibraryProperties(this.groupId, this.artifactId, this.version));
    }

    @Override
    public void editProperties(Project project) {
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(this.version, this.downloadSources, this.downloadJavaDocs);
        RepositoryLibraryDescription libraryDescription = RepositoryLibraryDescription.findDescription((String)this.groupId, (String)this.artifactId);
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(project, model, libraryDescription, true, false);
        if (!dialog.showAndGet()) {
            return;
        }
        this.version = model.getVersion();
        this.downloadSources = model.isDownloadSources();
        this.downloadJavaDocs = model.isDownloadJavaDocs();
        this.notifyMeChanged();
        JarRepositoryManager.loadDependenciesAsync((Project)project, (RepositoryLibraryProperties)new RepositoryLibraryProperties(this.groupId, this.artifactId, this.version), (boolean)this.downloadSources, (boolean)this.downloadJavaDocs, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianMavenLibraryModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

