/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import icons.ArquillianIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ArquillianExistLibraryModel
extends ArquillianLibraryModel {
    private final Project project;
    @NotNull
    @Nls
    private final String name;
    @NotNull
    private final String level;

    public ArquillianExistLibraryModel(Project project, ArquillianExistLibraryState state) {
        this.project = project;
        this.name = state.name;
        this.level = state.level;
    }

    @Override
    public boolean hasChanges(ArquillianLibraryState state) {
        if (!(state instanceof ArquillianExistLibraryState)) {
            return true;
        }
        ArquillianExistLibraryState existLibraryState = (ArquillianExistLibraryState)state;
        return !this.name.equals(existLibraryState.name) || !this.level.equals(existLibraryState.level);
    }

    @Override
    public ArquillianExistLibraryState getCurrentState() {
        return new ArquillianExistLibraryState(this.name, this.level);
    }

    @Override
    public String getDescription() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        Library library = this.getCurrentState().findLibrary(this.project);
        if (library == null) {
            return null;
        }
        PersistentLibraryKind kind = ((LibraryEx)library).getKind();
        if (kind == null) {
            return ArquillianIcons.Arquillian;
        }
        LibraryType libraryType = LibraryType.findByKind((LibraryKind)kind);
        return libraryType.getIcon(((LibraryEx)library).getProperties());
    }

    @Override
    public void editProperties(Project project) {
    }
}

