/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianExistLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianListModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianMavenLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianModelCreator;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianExistLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ConfigurationSpecificState;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.RemoteDebuggerModel;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianContainerModel
extends ArquillianListModel<ArquillianLibraryState, ArquillianLibraryModel, ArquillianContainerState, ArquillianContainerModel> {
    private final ArquillianContainer arquillianContainer;
    @NotNull
    @Nls
    private String name;
    @NotNull
    private String jvmParameters;
    @NotNull
    Map<String, String> envVariables = new HashMap<String, String>();
    @NotNull
    RemoteDebuggerModel remoteDebuggerModel;

    public ArquillianContainerModel(Project project, String name, ArquillianContainer arquillianContainer) {
        this(project, arquillianContainer.createDefaultState(project, name), arquillianContainer);
    }

    public ArquillianContainerModel(final Project project, ArquillianContainerState state, ArquillianContainer arquillianContainer) {
        super(state, new ArquillianModelCreator<ArquillianLibraryState, ArquillianLibraryModel>(){

            @Override
            public ArquillianLibraryModel createModel(ArquillianLibraryState libraryState) {
                return libraryState.accept(new ArquillianLibraryState.Visitor<ArquillianLibraryModel>(){

                    @Override
                    public ArquillianLibraryModel visitMavenLibrary(ArquillianMavenLibraryState state) {
                        return new ArquillianMavenLibraryModel(state);
                    }

                    @Override
                    public ArquillianLibraryModel visitExistLibrary(ArquillianExistLibraryState state) {
                        return new ArquillianExistLibraryModel(project, state);
                    }
                });
            }
        });
        this.arquillianContainer = arquillianContainer;
        this.name = state.getName();
        this.jvmParameters = state.getJvmParameters();
        this.setEnvVariables(state.getEnvVariables());
        this.remoteDebuggerModel = new RemoteDebuggerModel(project, state.getRemoteDebuggerState());
        this.remoteDebuggerModel.addChangeListener(new ArquillianModel.Listener<ConfigurationSpecificState, RemoteDebuggerModel>(){

            @Override
            public void itemChanged(RemoteDebuggerModel model) {
                ArquillianContainerModel.this.notifyMeChanged();
            }
        });
    }

    @NotNull
    @Nls
    public String getName() {
        String string = this.name;
        if (string == null) {
            ArquillianContainerModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setName(@NotNull @NlsSafe String name) {
        if (name == null) {
            ArquillianContainerModel.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.notifyMeChanged();
    }

    @NotNull
    public String getJvmParameters() {
        String string = this.jvmParameters;
        if (string == null) {
            ArquillianContainerModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setJvmParameters(@NotNull String jvmParameters) {
        if (jvmParameters == null) {
            ArquillianContainerModel.$$$reportNull$$$0(3);
        }
        this.jvmParameters = jvmParameters;
        this.notifyMeChanged();
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map = this.envVariables;
        if (map == null) {
            ArquillianContainerModel.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (envVariables == null) {
            ArquillianContainerModel.$$$reportNull$$$0(5);
        }
        this.envVariables.clear();
        this.envVariables.putAll(envVariables);
        this.notifyMeChanged();
    }

    @NotNull
    public RemoteDebuggerModel getRemoteDebuggerModel() {
        RemoteDebuggerModel remoteDebuggerModel = this.remoteDebuggerModel;
        if (remoteDebuggerModel == null) {
            ArquillianContainerModel.$$$reportNull$$$0(6);
        }
        return remoteDebuggerModel;
    }

    @Nullable
    public Icon getIcon() {
        return this.arquillianContainer.getIcon();
    }

    @NotNull
    public ArquillianContainer getDescription() {
        ArquillianContainer arquillianContainer = this.arquillianContainer;
        if (arquillianContainer == null) {
            ArquillianContainerModel.$$$reportNull$$$0(7);
        }
        return arquillianContainer;
    }

    @Override
    public boolean hasChanges(ArquillianContainerState state) {
        return !this.jvmParameters.equals(state.getJvmParameters()) || !this.name.equals(state.getName()) || !this.envVariables.equals(state.getEnvVariables()) || this.remoteDebuggerModel.hasChanges(state.getRemoteDebuggerState()) || super.hasChanges(state);
    }

    @Override
    public ArquillianContainerState getCurrentState() {
        return new ArquillianContainerState(this.arquillianContainer.getId(), this.name, this.getChildrenStates(), this.jvmParameters, this.envVariables, this.remoteDebuggerModel.getCurrentState());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/jboss/arquillian/configuration/model/ArquillianContainerModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteDebuggerModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setJvmParameters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScopeNameComparator
    implements Comparator<ArquillianContainerModel> {
        @Override
        public int compare(ArquillianContainerModel o1, ArquillianContainerModel o2) {
            ArquillianContainer.Scope scope2;
            ArquillianContainer.Scope scope1 = o1.getDescription().getScope();
            return scope1 == (scope2 = o2.getDescription().getScope()) ? StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true) : scope1.compareTo(scope2);
        }
    }
}

