/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.container;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerParameter;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerUtils;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianMavenCoordinates;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ArquillianContainerSettings;
import com.intellij.util.containers.JBIterable;
import icons.ArquillianIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArquillianContainerImpl
extends ArquillianContainer {
    protected final String id;
    @Nls
    protected final String name;
    protected final String descriptionUri;
    protected final List<ArquillianMavenCoordinates> dependencies;

    public ArquillianContainerImpl(String idSuffix, @Nls(capitalization=Nls.Capitalization.Title) String name, String descriptionUri, ArquillianMavenCoordinates ... dependencies) {
        this.descriptionUri = descriptionUri;
        this.id = "container.arquillian." + idSuffix;
        this.name = name;
        this.dependencies = Arrays.asList(dependencies);
    }

    public ArquillianContainerImpl(String idSuffix, @Nls(capitalization=Nls.Capitalization.Title) String name, String descriptionUri, List<ArquillianMavenCoordinates> dependencies) {
        this.descriptionUri = descriptionUri;
        this.id = "container.arquillian." + idSuffix;
        this.name = name;
        this.dependencies = dependencies;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            ArquillianContainerImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ArquillianContainerImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public String getDescriptionUri() {
        return this.descriptionUri;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = ArquillianIcons.Arquillian;
        if (icon == null) {
            ArquillianContainerImpl.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Override
    @NotNull
    public List<ArquillianMavenCoordinates> getDependencies() {
        List<ArquillianMavenCoordinates> list = this.dependencies;
        if (list == null) {
            ArquillianContainerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public List<ArquillianContainerParameter> getParameters() {
        return new ArrayList<ArquillianContainerParameter>();
    }

    @Override
    @NotNull
    public ArquillianContainerState createDefaultState(Project project, String name) {
        ArquillianContainerState state = new ArquillianContainerState(this.getId(), name, JBIterable.from(this.dependencies).transform(coordinates -> new ArquillianMavenLibraryState((ArquillianMavenCoordinates)coordinates)).toList());
        ArquillianContainerUtils.loadDependenciesAsync(project, state);
        ArquillianContainerState arquillianContainerState = state;
        if (arquillianContainerState == null) {
            ArquillianContainerImpl.$$$reportNull$$$0(4);
        }
        return arquillianContainerState;
    }

    @Override
    public JPanel createSettingsPanel(Project project, ArquillianContainerModel model) {
        ArquillianContainerSettings settings = new ArquillianContainerSettings(project, this, model);
        return settings.getMainPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultState";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

