/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.container;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerParameter;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianMavenCoordinates;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArquillianContainer {
    @NotNull
    public abstract String getId();

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Scope getScope();

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public abstract String getDescriptionUri();

    @NotNull
    public abstract ArquillianContainerState createDefaultState(Project var1, String var2);

    @NotNull
    public abstract List<ArquillianMavenCoordinates> getDependencies();

    public abstract List<ArquillianContainerParameter> getParameters();

    public abstract JPanel createSettingsPanel(Project var1, ArquillianContainerModel var2);

    public abstract boolean canChangeDependencyList();

    public static enum Scope implements Comparable<Scope>
    {
        Manual(ArquillianBundle.messagePointer("arquillian.manual.configuration.name", new Object[0]), 1000),
        Embedded(ArquillianBundle.messagePointer("arquillian.embedded.configuration.name", new Object[0]), 2000),
        Managed(ArquillianBundle.messagePointer("arquillian.managed.configuration.name", new Object[0]), 3000),
        Remote(ArquillianBundle.messagePointer("arquillian.remote.configuration.name", new Object[0]), 4000);

        private final Supplier<@Nls String> description;
        private final int weight;

        private Scope(Supplier<String> description, int weight) {
            this.description = description;
            this.weight = weight;
        }

        public Supplier<@Nls String> getDescription() {
            return this.description;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

