/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerBean;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerManual;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerPredefined;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianContainersAppManager {
    @NotNull
    private final ArquillianContainer manualContainer = new ArquillianContainerManual();
    @NotNull
    private final List<ArquillianContainer> manualContainers = Collections.singletonList(this.manualContainer);
    @NotNull
    private final List<ArquillianContainer> embeddedContainers;
    @NotNull
    private final List<ArquillianContainer> managedContainers;
    @NotNull
    private final List<ArquillianContainer> remoteContainers;
    private final Map<String, ArquillianContainer> registeredContainers;

    public ArquillianContainersAppManager() {
        List<ArquillianContainerBean> extensions = Arrays.asList((ArquillianContainerBean[])ArquillianContainerBean.EP_NAME.getExtensions());
        extensions.sort(Comparator.comparing(left -> left.name));
        List predefined = ContainerUtil.map(extensions, ArquillianContainerPredefined::new);
        this.embeddedContainers = ContainerUtil.filter((Collection)predefined, c -> c.getScope() == ArquillianContainer.Scope.Embedded);
        this.managedContainers = ContainerUtil.filter((Collection)predefined, c -> c.getScope() == ArquillianContainer.Scope.Managed);
        this.remoteContainers = ContainerUtil.filter((Collection)predefined, c -> c.getScope() == ArquillianContainer.Scope.Remote);
        this.registeredContainers = Maps.uniqueIndex((Iterable)Iterables.concat(this.manualContainers, this.embeddedContainers, this.managedContainers, this.remoteContainers), arquillianContainer -> arquillianContainer.getId());
    }

    public static ArquillianContainersAppManager getInstance() {
        return (ArquillianContainersAppManager)ApplicationManager.getApplication().getService(ArquillianContainersAppManager.class);
    }

    @NotNull
    public List<ArquillianContainer> getContainers(ArquillianContainer.Scope scope) {
        switch (scope) {
            default: {
                List<ArquillianContainer> list = this.manualContainers;
                if (list == null) {
                    ArquillianContainersAppManager.$$$reportNull$$$0(0);
                }
                return list;
            }
            case Embedded: {
                List<ArquillianContainer> list = this.embeddedContainers;
                if (list == null) {
                    ArquillianContainersAppManager.$$$reportNull$$$0(1);
                }
                return list;
            }
            case Managed: {
                List<ArquillianContainer> list = this.managedContainers;
                if (list == null) {
                    ArquillianContainersAppManager.$$$reportNull$$$0(2);
                }
                return list;
            }
            case Remote: 
        }
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            ArquillianContainersAppManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getEmbeddedContainers() {
        List<ArquillianContainer> list = this.embeddedContainers;
        if (list == null) {
            ArquillianContainersAppManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManagedContainers() {
        List<ArquillianContainer> list = this.managedContainers;
        if (list == null) {
            ArquillianContainersAppManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManualContainers() {
        List<ArquillianContainer> list = this.manualContainers;
        if (list == null) {
            ArquillianContainersAppManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getRemoteContainers() {
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            ArquillianContainersAppManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public ArquillianContainer findContainerById(String id) {
        ArquillianContainer container = this.registeredContainers.get(id);
        return container == null ? this.manualContainer : container;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedContainers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedContainers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualContainers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteContainers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

