/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.starter;

import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.quarkus.starter.QuarkusOptions;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;

public class QuarkusProjectDownloader
extends WebStarterProjectDownloader<QuarkusOptions> {
    public QuarkusProjectDownloader(WebStarterModuleBuilder<QuarkusOptions> builder) {
        super(builder);
    }

    protected Url buildUrl() {
        Function getShortIdFunc;
        String extensionsSet;
        String serviceUrl = StringUtil.trimTrailing((String)this.myBuilder.getServiceUrl(), (char)'/');
        Url url = Urls.newFromEncoded((String)(serviceUrl + "/api/download"));
        QuarkusOptions options = (QuarkusOptions)this.myBuilder.getOptions();
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("a", options.artifact);
        parameters.put("b", QuarkusProjectDownloader.getParameter(options.buildTool, (boolean)true));
        parameters.put("c", options.group + ".ExampleResource");
        parameters.put("g", options.group);
        parameters.put("p", "/hello");
        parameters.put("v", options.version);
        if (!options.selectedDependenciesIds.isEmpty() && !(extensionsSet = StringUtil.join(options.selectedDependenciesIds, (Function)(getShortIdFunc = id -> {
            QuarkusOptions.ExternalExtensionData data = options.dependencyId2ExternalData.get(id);
            return data.isDefault ? null : data.shortId;
        }), (String)".")).isEmpty()) {
            parameters.put("s", extensionsSet);
        }
        url = url.addParameters(parameters);
        return url;
    }

    protected void unzip(File tempZipFile, File contentEntryDir) throws IOException {
        QuarkusProjectDownloader.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }
}

