/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.starter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoaderIteration;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.quarkus.starter.QuarkusOptions;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class QuarkusOptionsLoader
extends WebStarterOptionsLoader<QuarkusOptions> {
    protected QuarkusOptions createEmptyOptionsContainer() {
        return new QuarkusOptions();
    }

    @NotNull
    protected WebStarterOptionsLoaderIteration<QuarkusOptions> getFirstIteration() {
        return new WebStarterOptionsLoaderIteration<QuarkusOptions>(){

            protected RequestBuilder getPreparedRequestBuilder(String serviceUrl) {
                return HttpRequests.request((String)(serviceUrl + "/api/extensions"));
            }

            public void parseJsonResponse(JsonElement jsonRootElement, @NotNull QuarkusOptions options) {
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuarkusOptionsLoader.parseDependencies(jsonRootElement, options);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/quarkus/starter/QuarkusOptionsLoader$1", "parseJsonResponse"));
            }
        };
    }

    private static void parseDependencies(JsonElement rootElement, QuarkusOptions options) {
        HashMap<String, WebStarterOptions.MultiSelectGroup> groups = new HashMap<String, WebStarterOptions.MultiSelectGroup>();
        JsonArray dependencies = rootElement.getAsJsonArray();
        HashMap<String, Integer> groupAndDep2Order = new HashMap<String, Integer>();
        for (JsonElement dependency : dependencies) {
            JsonObject depObject = dependency.getAsJsonObject();
            @NlsSafe String groupName = depObject.get("category").getAsString();
            String id = depObject.get("id").getAsString();
            String shortId = depObject.get("shortId").getAsString();
            String name = depObject.get("name").getAsString();
            @NlsSafe String description = depObject.get("description").getAsString();
            boolean isDefault = depObject.get("default").getAsBoolean();
            int order = depObject.get("order").getAsInt();
            JsonElement guideLinkElement = depObject.get("guide");
            String guideLink = guideLinkElement != null && !(guideLinkElement instanceof JsonNull) ? guideLinkElement.getAsString() : null;
            WebStarterOptions.MultiSelectGroup registeredGroup = (WebStarterOptions.MultiSelectGroup)groups.get(groupName);
            if (registeredGroup == null) {
                registeredGroup = new WebStarterOptions.MultiSelectGroup(groupName, new ArrayList());
                groups.put(groupName, registeredGroup);
            }
            groupAndDep2Order.put(QuarkusOptionsLoader.getStringKey(groupName, id), order);
            registeredGroup.options.add(new WebStarterOptions.Option(id, name, description));
            options.dependencyId2ExternalData.put(id, new QuarkusOptions.ExternalExtensionData(shortId, isDefault, guideLink));
        }
        options.dependencies = Arrays.asList(groups.values().toArray(new WebStarterOptions.MultiSelectGroup[0]));
        QuarkusOptionsLoader.performSorting(options, groupAndDep2Order);
    }

    private static void performSorting(QuarkusOptions options, HashMap<String, Integer> groupAndDep2Order) {
        HashMap<WebStarterOptions.MultiSelectGroup, Integer> group2order = QuarkusOptionsLoader.calcGroupsOrders(options, groupAndDep2Order);
        options.dependencies.sort(Comparator.comparingInt(group -> group2order.getOrDefault(group, Integer.MAX_VALUE)));
        for (WebStarterOptions.MultiSelectGroup group2 : options.dependencies) {
            group2.options.sort(Comparator.comparingInt(dependency -> groupAndDep2Order.getOrDefault(QuarkusOptionsLoader.getStringKey(group.name, dependency.id), Integer.MAX_VALUE)));
        }
    }

    @NotNull
    private static HashMap<WebStarterOptions.MultiSelectGroup, Integer> calcGroupsOrders(QuarkusOptions options, HashMap<String, Integer> groupAndDep2Order) {
        HashMap<WebStarterOptions.MultiSelectGroup, Integer> group2order = new HashMap<WebStarterOptions.MultiSelectGroup, Integer>();
        for (WebStarterOptions.MultiSelectGroup group : options.dependencies) {
            for (WebStarterOptions.Option dependency : group.options) {
                int order = groupAndDep2Order.getOrDefault(QuarkusOptionsLoader.getStringKey(group.name, dependency.id), Integer.MAX_VALUE);
                if (order >= group2order.getOrDefault(group, Integer.MAX_VALUE)) continue;
                group2order.put(group, order);
            }
        }
        HashMap<WebStarterOptions.MultiSelectGroup, Integer> hashMap = group2order;
        if (hashMap == null) {
            QuarkusOptionsLoader.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    @NotNull
    private static String getStringKey(String groupName, String dependencyId) {
        String string = groupName + "^" + dependencyId;
        if (string == null) {
            QuarkusOptionsLoader.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/quarkus/starter/QuarkusOptionsLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calcGroupsOrders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringKey";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

