/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.starter;

import com.intellij.frameworks.starters.shared.StartersValidationUtils;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.starter.QuarkusOptions;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class QuarkusApplicationInfoStep
extends WebStarterApplicationInfoStep<QuarkusOptions> {
    private JBTextField myGroupField;
    private JBTextField myArtifactField;
    private JBTextField myVersionField;
    private JPanel myBuildToolRadioButtonsPanel;

    public QuarkusApplicationInfoStep(WebStarterModuleBuilder<QuarkusOptions> builder, WizardContext wizardContext) {
        super(builder, wizardContext);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupField;
    }

    protected void fillAppSettingsPanel(WebStarterFormBuilder formBuilder, QuarkusOptions options) {
        this.myBuildToolRadioButtonsPanel = formBuilder.addRadioButtonsGroup(QuarkusBundle.message("label.title.tool", new Object[0]), options.buildTool);
        this.myGroupField = formBuilder.addTextField(QuarkusBundle.message("label.title.group", new Object[0]), options.group);
        this.myArtifactField = formBuilder.addTextField(QuarkusBundle.message("label.title.artifact", new Object[0]), options.artifact);
        this.myVersionField = formBuilder.addTextField(QuarkusBundle.message("label.title.version", new Object[0]), options.version);
        this.registerTextComponentValidation((JTextField)this.myGroupField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_GROUP_FORMAT, StartersValidationUtils.CHECK_NO_RESERVED_WORDS, StartersValidationUtils.CHECK_PACKAGE_NAME});
        this.registerTextComponentValidation((JTextField)this.myArtifactField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_ARTIFACT_FORMAT_FOR_WEB, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
        this.registerTextComponentValidation((JTextField)this.myVersionField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_SIMPLE_NAME_FORMAT});
    }

    protected void setInitialFocus(JBLoadingPanel settingsPanel) {
        Component radioButtonToFocusOn = null;
        for (Component component : this.myBuildToolRadioButtonsPanel.getComponents()) {
            if (!(component instanceof JRadioButton) || !((JRadioButton)component).isSelected()) continue;
            radioButtonToFocusOn = component;
            break;
        }
        if (radioButtonToFocusOn != null) {
            IdeFocusManager.findInstanceByComponent((Component)this.myBuildToolRadioButtonsPanel).requestFocus(radioButtonToFocusOn, true);
        } else {
            Logger.getInstance(QuarkusApplicationInfoStep.class).error("There is no any selected JRadioButton to set focus on");
        }
    }

    public void updateDataModel() {
        super.updateDataModel();
        QuarkusOptions options = (QuarkusOptions)this.myBuilder.getOptions();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
        options.version = this.myVersionField.getText();
    }
}

