/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.maven;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.run.QsDebugState;
import com.intellij.quarkus.run.maven.QsMavenRunConfigurationSettingsEditor;
import com.intellij.quarkus.run.maven.QsMavenState;
import com.intellij.util.SmartList;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.server.MavenServerManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/quarkus/run/maven/QsMavenRunConfiguration;", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "attachDebugger", "", "port", "", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getDefaultLanguageRuntimeType", "", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "removeMavenEventListener", "parameters", "setGoals", "", "intellij.quarkus"})
public final class QsMavenRunConfiguration
extends MavenRunConfiguration {
    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.setGoals();
        if (executor instanceof DefaultDebugExecutor) {
            int port = NetUtils.findAvailableSocketPort();
            QsMavenState mavenState = new QsMavenState(this, environment, true, port);
            RemoteConnection remoteConnection = new RemoteConnection(true, "127.0.0.1", String.valueOf(port), false);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            return (RunProfileState)new QsDebugState(project, remoteConnection, (RunProfileState)mavenState);
        }
        return (RunProfileState)new QsMavenState(this, environment, false, 0);
    }

    @Nullable
    public Void getDefaultLanguageRuntimeType() {
        return null;
    }

    @NotNull
    public final JavaParameters createJavaParameters(boolean attachDebugger, int port) throws ExecutionException {
        JavaParameters parameters;
        MavenRunnerSettings mavenRunnerSettings = this.getRunnerSettings();
        if (mavenRunnerSettings == null || (mavenRunnerSettings = mavenRunnerSettings.clone()) == null) {
            MavenRunner mavenRunner = MavenRunner.getInstance((Project)this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunner, (String)"MavenRunner.getInstance(project)");
            mavenRunnerSettings = mavenRunner.getState().clone();
        }
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings, (String)"runnerSettings?.clone() \u2026ce(project).state.clone()");
        MavenRunnerSettings runnerSettings = mavenRunnerSettings;
        if (attachDebugger) {
            Map map2 = runnerSettings.getMavenProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"runnerSettings.mavenProperties");
            map2.put("debug", String.valueOf(port));
        }
        JavaParameters javaParameters = parameters = MavenExternalParameters.createJavaParameters((Project)this.getProject(), (MavenRunnerParameters)this.getRunnerParameters(), (MavenGeneralSettings)this.getGeneralSettings(), (MavenRunnerSettings)runnerSettings, (MavenRunConfiguration)this);
        Intrinsics.checkNotNullExpressionValue((Object)javaParameters, (String)"parameters");
        return this.removeMavenEventListener(javaParameters);
    }

    private final void setGoals() {
        MavenRunnerParameters mavenRunnerParameters = this.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"runnerParameters");
        mavenRunnerParameters.setGoals((List)new SmartList((Object)"quarkus:dev"));
    }

    private final JavaParameters removeMavenEventListener(JavaParameters parameters) {
        File file = MavenServerManager.getMavenEventListener();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"MavenServerManager.getMavenEventListener()");
        String listenerPath = file.getAbsolutePath();
        String extClassPath = parameters.getVMParametersList().getPropertyValue("maven.ext.class.path");
        if (extClassPath != null) {
            CharSequence charSequence = extClassPath;
            String string = listenerPath;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"listenerPath");
            if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
                parameters.getVMParametersList().replaceOrAppend("-Dmaven.ext.class.path", StringsKt.replace$default((String)extClassPath, (String)listenerPath, (String)"", (boolean)false, (int)4, null));
            }
        }
        return parameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor settingsEditor = super.getConfigurationEditor();
        Intrinsics.checkNotNullExpressionValue((Object)settingsEditor, (String)"super.getConfigurationEditor()");
        SettingsEditor editor = settingsEditor;
        if (editor instanceof SettingsEditorGroup) {
            List list = ((SettingsEditorGroup)editor).getEditors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.editors");
            Collection collection = list;
            boolean bl = false;
            if (!collection.isEmpty()) {
                List list2 = ((SettingsEditorGroup)editor).getEditors();
                if (list2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.openapi.util.Pair<kotlin.String, com.intellij.openapi.options.SettingsEditor<org.jetbrains.idea.maven.execution.MavenRunConfiguration>>>");
                }
                List editors = TypeIntrinsics.asMutableList((Object)list2);
                editors.remove(0);
                String string = QuarkusBundle.message("run.configuration.configuration.tab", new Object[0]);
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Pair pair = Pair.create((Object)string, (Object)((Object)new QsMavenRunConfigurationSettingsEditor(project)));
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"Pair.create(QuarkusBundl\u2026nSettingsEditor(project))");
                editors.add(0, pair);
            }
        }
        return editor;
    }

    public QsMavenRunConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenRunConfigurationType mavenRunConfigurationType = MavenRunConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunConfigurationType, (String)"MavenRunConfigurationType.getInstance()");
        super(project, mavenRunConfigurationType.getConfigurationFactories()[0], "");
    }
}

