/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.maven;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.quarkus.run.QsExternalSystemBridge;
import com.intellij.quarkus.run.maven.QsMavenRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/quarkus/run/maven/QsMavenBridge;", "Lcom/intellij/quarkus/run/QsExternalSystemBridge;", "()V", "createDelegateConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "getDelegate", "module", "Lcom/intellij/openapi/module/Module;", "intellij.quarkus"})
public final class QsMavenBridge
extends QsExternalSystemBridge {
    @Override
    @Nullable
    public RunConfiguration getDelegate(@NotNull Module module) {
        MavenRunnerParameters runnerParameters;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MavenProject mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module);
        if (mavenProject == null) {
            return null;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        QsMavenRunConfiguration configuration = new QsMavenRunConfiguration(project);
        MavenRunnerParameters mavenRunnerParameters = runnerParameters = configuration.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"runnerParameters");
        mavenRunnerParameters.setWorkingDirPath(mavenProject.getDirectory());
        VirtualFile virtualFile = mavenProject.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"mavenProject.file");
        runnerParameters.setPomFileName(virtualFile.getName());
        return (RunConfiguration)configuration;
    }

    @Override
    @NotNull
    public RunConfiguration createDelegateConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (RunConfiguration)new QsMavenRunConfiguration(project);
    }
}

