/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.quarkus.run.QsRunConfigurationType;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService;", "Lcom/intellij/openapi/Disposable;", "()V", "myExecutorService", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "createRunConfiguration", "", "module", "Lcom/intellij/openapi/module/Module;", "dispose", "doCreateRunConfiguration", "runManager", "Lcom/intellij/execution/RunManager;", "Companion", "intellij.quarkus"})
public final class QsRunConfigurationService
implements Disposable {
    private final ExecutorService myExecutorService;
    private static final Logger LOG;
    public static final Companion Companion;

    public final void createRunConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] virtualFileArray = moduleRootManager.getSourceRoots(false);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"moduleRootManager.getSourceRoots(false)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        boolean bl = false;
        if (virtualFileArray2.length == 0) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        List list = ContainerUtil.findAll((Collection)runManager.getConfigurationsList((ConfigurationType)QsRunConfigurationType.Companion.getInstance()), QsRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.findAll(\n \u2026onfiguration::class.java)");
        List allConfigs = list;
        Iterator iterator = allConfigs.iterator();
        while (iterator.hasNext()) {
            QsRunConfiguration config;
            QsRunConfiguration qsRunConfiguration = config = (QsRunConfiguration)((Object)iterator.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)qsRunConfiguration), (String)"config");
            RunConfigurationModule runConfigurationModule = qsRunConfiguration.getConfigurationModule();
            Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"config.configurationModule");
            if (!Intrinsics.areEqual((Object)module, (Object)runConfigurationModule.getModule())) continue;
            return;
        }
        this.doCreateRunConfiguration(module, runManager);
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    private final void doCreateRunConfiguration(Module module, RunManager runManager) {
        try {
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", QsRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0]);
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (runConfiguration == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.quarkus.run.QsRunConfiguration");
            }
            QsRunConfiguration newRunConfig = (QsRunConfiguration)runConfiguration;
            newRunConfig.setModule(module);
            settings.setName(newRunConfig.suggestedName());
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable t) {
            LOG.error("Error creating Quarkus run configuration for module " + module.getName(), t);
        }
    }

    public QsRunConfigurationService() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)(QsRunConfigurationService.class.getSimpleName() + " Pool"), (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026.simpleName + \" Pool\", 1)");
        this.myExecutorService = executorService;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(QsRunConfigurationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/quarkus/run/QsRunConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.quarkus"})
    public static final class Companion {
        @NotNull
        public final QsRunConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, QsRunConfigurationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ServiceManager.getServic\u2026ationService::class.java)");
            return (QsRunConfigurationService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

