/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.inspections;

import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.inspections.QsLocalInspectionTool;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParameterEx;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection;", "Lcom/intellij/quarkus/inspections/QsLocalInspectionTool;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isInjectionPointDefinedInClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "ip", "Lcom/intellij/cdi/beans/InjectionPointDescriptor;", "isMethodDefinedInClass", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "reportPrivateModifier", "", "uElement", "Lorg/jetbrains/uast/UElement;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "reportedMembers", "", "Lcom/intellij/psi/PsiElement;", "RemovePrivateModifierFix", "intellij.quarkus"})
public final class QsPrivateBeanMembersInspection
extends QsLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiModifierListOwner ipOwner;
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass));
        if (module == null || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        HashSet reportedOwners = new HashSet();
        Set injectionPoints = CdiInjectionUtils.getInjectionPoints((PsiClass)psiClass);
        Iterator iterator = injectionPoints.iterator();
        while (iterator.hasNext()) {
            UElement uParameterParent;
            InjectionPointDescriptor injectionPoint;
            InjectionPointDescriptor injectionPointDescriptor = injectionPoint = (InjectionPointDescriptor)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)injectionPointDescriptor, (String)"injectionPoint");
            if (!this.isInjectionPointDefinedInClass(psiClass, injectionPointDescriptor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)injectionPoint.getOwner(), (String)"injectionPoint.owner");
            if (!ipOwner.isValid()) continue;
            UElement uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)((PsiElement)ipOwner), (Class[])new Class[]{UField.class, UParameter.class});
            if (uElement instanceof UFieldEx) {
                if (!((UFieldEx)uElement).getJavaPsi().hasModifierProperty("private")) continue;
                this.reportPrivateModifier(uElement, holder, reportedOwners);
                continue;
            }
            if (!(uElement instanceof UParameterEx) || !((uParameterParent = ((UVariable)uElement).getUastParent()) instanceof UMethod) || !((UMethod)uParameterParent).getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier(uParameterParent, holder, reportedOwners);
        }
        List list = CdiCommonUtils.getObservesMethods((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CdiCommonUtils.getObservesMethods(psiClass)");
        List observesMethods = list;
        ipOwner = observesMethods.iterator();
        while (ipOwner.hasNext()) {
            PsiMethod observesMethod;
            PsiMethod psiMethod = observesMethod = (PsiMethod)ipOwner.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"observesMethod");
            if (!this.isMethodDefinedInClass(psiClass, psiMethod)) continue;
            PsiElement $this$toUElementOfType$iv = (PsiElement)observesMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod == null || !uMethod.getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier((UElement)uMethod, holder, reportedOwners);
        }
        Set set = CdiCommonUtils.getDisposerMethods((PsiClass)psiClass);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CdiCommonUtils.getDisposerMethods(psiClass)");
        Set disposerMethods = set;
        Iterator iterator2 = disposerMethods.iterator();
        while (iterator2.hasNext()) {
            PsiMethod disposerMethod;
            PsiMethod psiMethod = disposerMethod = (PsiMethod)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"disposerMethod");
            if (!this.isMethodDefinedInClass(psiClass, psiMethod)) continue;
            PsiElement $this$toUElementOfType$iv = (PsiElement)disposerMethod;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod == null || !uMethod.getJavaPsi().hasModifierProperty("private")) continue;
            this.reportPrivateModifier((UElement)uMethod, holder, reportedOwners);
        }
        return holder.getResultsArray();
    }

    private final void reportPrivateModifier(UElement uElement, ProblemsHolder holder, Set<PsiElement> reportedMembers) {
        PsiElement sourcePsi = uElement.getSourcePsi();
        if (CollectionsKt.contains((Iterable)reportedMembers, (Object)sourcePsi)) {
            return;
        }
        if (sourcePsi instanceof PsiModifierListOwner) {
            PsiElement[] modifiers;
            PsiModifierList psiModifierList = ((PsiModifierListOwner)sourcePsi).getModifierList();
            Object object = modifiers = psiModifierList != null ? psiModifierList.getChildren() : null;
            if (modifiers != null) {
                for (PsiElement child : modifiers) {
                    if (!child.textMatches((CharSequence)"private")) continue;
                    reportedMembers.add(sourcePsi);
                    holder.registerProblem(child, QuarkusBundle.message("inspection.message.private.bean.members", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemovePrivateModifierFix()});
                    break;
                }
            }
        }
    }

    private final boolean isInjectionPointDefinedInClass(PsiClass psiClass, InjectionPointDescriptor ip) {
        return Intrinsics.areEqual((Object)psiClass, (Object)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ip.getOwner()), PsiClass.class)));
    }

    private final boolean isMethodDefinedInClass(PsiClass psiClass, PsiMethod psiMethod) {
        return Intrinsics.areEqual((Object)psiClass, (Object)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)psiMethod), PsiClass.class)));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/quarkus/inspections/QsPrivateBeanMembersInspection$RemovePrivateModifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.quarkus"})
    private static final class RemovePrivateModifierFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return QuarkusBundle.message("inspection.fix.remove.private.modifier", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement problemElement = descriptor.getPsiElement();
                if (problemElement == null || !problemElement.isValid()) {
                    return;
                }
                if (!(problemElement instanceof PsiModifierListOwner)) {
                    PsiElement $this$parentOfType$iv = problemElement;
                    boolean withSelf$iv = false;
                    boolean $i$f$parentOfType = false;
                    problemElement = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, PsiModifierListOwner.class, (boolean)true);
                }
                if (!(problemElement instanceof PsiModifierListOwner)) break block3;
                PsiModifierList psiModifierList = ((PsiModifierListOwner)problemElement).getModifierList();
                if (psiModifierList != null) {
                    psiModifierList.setModifierProperty("private", false);
                }
            }
        }
    }
}

