/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.quarkus.config.yaml.QsYamlUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlUtils;", "", "()V", "getProfiles", "", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "getQualifiedConfigKeyName", "", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "isInsideApplicationYamlFile", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.quarkus"})
public final class QsYamlUtils {
    public static final QsYamlUtils INSTANCE;

    public final boolean isInsideApplicationYamlFile(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        PsiFile psiFile2 = containingFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"containingFile.originalFile");
        PsiFile originalFile = psiFile2;
        return originalFile instanceof YAMLFile && QsConfigUtils.INSTANCE.isConfigFile(originalFile);
    }

    @NotNull
    public final String getQualifiedConfigKeyName(@Nullable YAMLKeyValue yamlKeyValue) {
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue, (Function)getQualifiedConfigKeyName.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigYamlUtils.getQuali\u2026    keyText\n      }\n    }");
        return string;
    }

    @NotNull
    public final Collection<QsProfileTarget> getProfiles(@NotNull YAMLDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        YAMLValue yAMLValue = document.getTopLevelValue();
        if (!(yAMLValue instanceof YAMLMapping)) {
            yAMLValue = null;
        }
        YAMLMapping yAMLMapping = (YAMLMapping)yAMLValue;
        if (yAMLMapping == null) {
            return CollectionsKt.emptyList();
        }
        YAMLMapping searchElement = yAMLMapping;
        List result = (List)new SmartList();
        Iterator iterator = searchElement.getKeyValues().iterator();
        while (iterator.hasNext()) {
            PsiReference profileReference;
            YAMLKeyValue keyValue;
            YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"keyValue");
            if (QsConfigUtils.INSTANCE.createProfileReference((PsiElement)yAMLKeyValue) == null) {
                continue;
            }
            TextRange textRange = profileReference.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"profileReference.rangeInElement");
            if (textRange.isEmpty()) continue;
            PsiElement psiElement = profileReference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"profileReference.element");
            TextRange textRange2 = profileReference.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"profileReference.rangeInElement");
            result.add(new QsProfileTarget(psiElement, textRange2));
        }
        return result;
    }

    private QsYamlUtils() {
    }

    static {
        QsYamlUtils qsYamlUtils;
        INSTANCE = qsYamlUtils = new QsYamlUtils();
    }
}

