/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileAnnotator;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfilePsiReference;
import com.intellij.quarkus.config.yaml.QsYamlKeyMetaConfigKeyReference;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlAnnotator;", "Lcom/intellij/quarkus/config/QsConfigFileAnnotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateKey", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.quarkus"})
public final class QsYamlAnnotator
extends QsConfigFileAnnotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"holder.currentAnnotationSession");
        PsiFile psiFile = annotationSession.getFile();
        if (!(psiFile instanceof YAMLFile)) {
            psiFile = null;
        }
        YAMLFile yAMLFile = (YAMLFile)psiFile;
        if (yAMLFile == null) {
            return;
        }
        YAMLFile file = yAMLFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project) || !QsConfigUtils.INSTANCE.isConfigFile((PsiFile)file)) {
            return;
        }
        if (((YAMLKeyValue)element).getKey() == null) {
            return;
        }
        this.annotateKey((YAMLKeyValue)element, holder);
        YAMLValue yamlValue = ((YAMLKeyValue)element).getValue();
        if (yamlValue instanceof YAMLScalar) {
            this.annotateValue((PsiElement)yamlValue, holder);
        } else if (yamlValue instanceof YAMLSequence) {
            Iterator iterator = ((YAMLSequence)yamlValue).getItems().iterator();
            while (iterator.hasNext()) {
                YAMLScalar value;
                YAMLSequenceItem item;
                YAMLSequenceItem yAMLSequenceItem = item = (YAMLSequenceItem)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem, (String)"item");
                YAMLValue yAMLValue = yAMLSequenceItem.getValue();
                if (!(yAMLValue instanceof YAMLScalar)) {
                    yAMLValue = null;
                }
                if ((YAMLScalar)yAMLValue == null) {
                    continue;
                }
                this.annotateValue((PsiElement)value, holder);
            }
        }
    }

    @Override
    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = YAMLHighlighter.SCALAR_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"YAMLHighlighter.SCALAR_KEY");
        return textAttributesKey;
    }

    private final void annotateKey(YAMLKeyValue yamlKeyValue, AnnotationHolder holder) {
        PsiReference[] references;
        ASTNode aSTNode = yamlKeyValue.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"yamlKeyValue.node");
        int elementStartOffset = aSTNode.getStartOffset();
        for (PsiReference psiReference : references = yamlKeyValue.getReferences()) {
            TextRange referenceRange;
            if (psiReference instanceof QsProfilePsiReference) {
                TextRange textRange = ((QsProfilePsiReference)psiReference).getRangeInElement().shiftRight(elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"psiReference.rangeInElem\u2026Right(elementStartOffset)");
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
                this.doAnnotateEnforced(holder, textRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                continue;
            }
            if (!(psiReference instanceof QsYamlKeyMetaConfigKeyReference)) continue;
            if (((QsYamlKeyMetaConfigKeyReference)psiReference).getKeyData().getPathType() == ConfigKeyPathReference.PathType.ARBITRARY_ENTRY_KEY) {
                Intrinsics.checkNotNullExpressionValue((Object)((QsYamlKeyMetaConfigKeyReference)psiReference).getRangeInElement().shiftRight(elementStartOffset), (String)"psiReference.rangeInElem\u2026Right(elementStartOffset)");
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
                this.doAnnotateEnforced(holder, referenceRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                continue;
            }
            if (((QsYamlKeyMetaConfigKeyReference)psiReference).getKeyData().getParentKey() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((QsYamlKeyMetaConfigKeyReference)psiReference).getRangeInElement().shiftRight(elementStartOffset), (String)"psiReference.rangeInElem\u2026Right(elementStartOffset)");
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.INSTANCE_METHOD;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DefaultLanguageHighlighterColors.INSTANCE_METHOD");
            this.doAnnotate(holder, referenceRange, textAttributesKey);
        }
    }
}

