/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.quarkus.config.QsMetaConfigKeyManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\f\u001a\u00020\rH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/quarkus/config/yaml/QsConfigYamlAccessor;", "", "root", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "module", "Lcom/intellij/openapi/module/Module;", "(Lorg/jetbrains/yaml/psi/YAMLDocument;Lcom/intellij/openapi/module/Module;)V", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;Lcom/intellij/openapi/module/Module;)V", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;Lcom/intellij/openapi/module/Module;)V", "create", "qualifiedKey", "", "createKeyValue", "keyComponents", "", "indent", "", "findChildRelaxed", "searchElement", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "subKey", "binder", "Lcom/intellij/microservices/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "findExistingKey", "getAllKeys", "getBinder", "getTopLevelValue", "Lorg/jetbrains/yaml/psi/YAMLValue;", "splitQualifiedKey", "intellij.quarkus"})
public final class QsConfigYamlAccessor {
    private final YAMLPsiElement root;
    private final Module module;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final YAMLKeyValue findExistingKey(@NotNull String qualifiedKey) {
        Intrinsics.checkNotNullParameter((Object)qualifiedKey, (String)"qualifiedKey");
        if (StringsKt.isBlank((CharSequence)qualifiedKey)) {
            return null;
        }
        List<String> keyParts = this.splitQualifiedKey(qualifiedKey);
        MetaConfigKeyManager.ConfigKeyNameBinder binder = this.getBinder();
        YAMLValue searchElement = this.getTopLevelValue();
        int n = 0;
        int n2 = ((Collection)keyParts).size();
        while (n < n2) {
            void i;
            if (!(searchElement instanceof YAMLMapping)) {
                return null;
            }
            String subKey = keyParts.get((int)i);
            YAMLKeyValue relaxedChild = this.findChildRelaxed((YAMLMapping)searchElement, subKey, binder);
            if (relaxedChild == null || i + true == keyParts.size()) {
                return relaxedChild;
            }
            searchElement = relaxedChild.getValue();
            ++i;
        }
        throw (Throwable)new IllegalStateException("Should have returned from the loop '" + qualifiedKey + '\'');
    }

    private final List<String> splitQualifiedKey(String qualifiedKey) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(qualifiedKey, ".\"", true);
        String part = "";
        boolean inQuotes = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (Intrinsics.areEqual((Object)token, (Object)"\"")) {
                if (inQuotes) {
                    result.add(part);
                    inQuotes = false;
                    continue;
                }
                part = "";
                inQuotes = true;
                continue;
            }
            if (inQuotes) {
                part = part + token;
                continue;
            }
            if (!(Intrinsics.areEqual((Object)token, (Object)".") ^ true)) continue;
            result.add(token);
        }
        return result;
    }

    private final YAMLKeyValue findChildRelaxed(YAMLMapping searchElement, String subKey, MetaConfigKeyManager.ConfigKeyNameBinder binder) {
        YAMLKeyValue byKey = searchElement.getKeyValueByKey(subKey);
        if (byKey != null) {
            return byKey;
        }
        Iterator iterator = searchElement.getKeyValues().iterator();
        while (iterator.hasNext()) {
            YAMLKeyValue value;
            YAMLKeyValue yAMLKeyValue = value = (YAMLKeyValue)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"value");
            String name = yAMLKeyValue.getName();
            if (name == null || !binder.matchesPart(subKey, name)) continue;
            return value;
        }
        return null;
    }

    private final MetaConfigKeyManager.ConfigKeyNameBinder getBinder() {
        Module module = this.module;
        if (module == null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.root));
        }
        if (module == null) {
            String string = "could not find module for accessor document";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Module module2 = module;
        return QsMetaConfigKeyManager.INSTANCE.getConfigKeyNameBinder(module2);
    }

    private final YAMLValue getTopLevelValue() {
        if (this.root instanceof YAMLDocument) {
            return ((YAMLDocument)this.root).getTopLevelValue();
        }
        if (this.root instanceof YAMLKeyValue) {
            return ((YAMLKeyValue)this.root).getValue();
        }
        return null;
    }

    @Nullable
    public final YAMLKeyValue create(@NotNull String qualifiedKey) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)qualifiedKey, (String)"qualifiedKey");
        List<String> keyParts = this.splitQualifiedKey(qualifiedKey);
        YAMLValue topLevelValue = this.getTopLevelValue();
        Runnable writeRunnable = null;
        if (!(topLevelValue instanceof YAMLMapping)) {
            if (this.root instanceof YAMLKeyValue) {
                int indent = YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)this.root)) + 2;
                YAMLKeyValue dummyKeyValue = this.createKeyValue(keyParts, indent);
                writeRunnable = new Runnable(this, dummyKeyValue){
                    final /* synthetic */ QsConfigYamlAccessor this$0;
                    final /* synthetic */ YAMLKeyValue $dummyKeyValue;

                    public final void run() {
                        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)QsConfigYamlAccessor.access$getRoot$p(this.this$0);
                        YAMLMapping yAMLMapping = this.$dummyKeyValue.getParentMapping();
                        Intrinsics.checkNotNull((Object)yAMLMapping);
                        yAMLKeyValue.setValue((YAMLValue)yAMLMapping);
                    }
                    {
                        this.this$0 = qsConfigYamlAccessor;
                        this.$dummyKeyValue = yAMLKeyValue;
                    }
                };
            } else {
                YAMLElementGenerator generator = YAMLElementGenerator.getInstance((Project)this.root.getProject());
                YAMLFile yAMLFile = generator.createDummyYamlWithText(YAMLElementGenerator.createChainedKey(keyParts, (int)0));
                Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"generator.createDummyYam\u2026eChainedKey(keyParts, 0))");
                YAMLFile dummyFile = yAMLFile;
                Object e = dummyFile.getDocuments().get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"dummyFile.documents[0]");
                YAMLValue yAMLValue = ((YAMLDocument)e).getTopLevelValue();
                Intrinsics.checkNotNull((Object)yAMLValue);
                Intrinsics.checkNotNullExpressionValue((Object)yAMLValue, (String)"dummyFile.documents[0].topLevelValue!!");
                YAMLValue dummyValue = yAMLValue;
                writeRunnable = new Runnable(this, topLevelValue, dummyValue){
                    final /* synthetic */ QsConfigYamlAccessor this$0;
                    final /* synthetic */ YAMLValue $topLevelValue;
                    final /* synthetic */ YAMLValue $dummyValue;

                    public final void run() {
                        YAMLValue yAMLValue = this.$topLevelValue;
                        if (yAMLValue == null || (yAMLValue = yAMLValue.replace((PsiElement)this.$dummyValue)) == null) {
                            yAMLValue = QsConfigYamlAccessor.access$getRoot$p(this.this$0).add((PsiElement)this.$dummyValue);
                        }
                    }
                    {
                        this.this$0 = qsConfigYamlAccessor;
                        this.$topLevelValue = yAMLValue;
                        this.$dummyValue = yAMLValue2;
                    }
                };
            }
        } else {
            Runnable runnable;
            int n;
            YAMLMapping topMostExistingMapping = (YAMLMapping)topLevelValue;
            YAMLKeyValue topMostExistingKey = null;
            int foundHierarchies = 0;
            for (String subKey : keyParts) {
                if (topMostExistingMapping == null || (topMostExistingKey = this.findChildRelaxed(topMostExistingMapping, subKey, this.getBinder())) == null) break;
                topMostExistingMapping = (YAMLMapping)ObjectUtils.tryCast((Object)topMostExistingKey.getValue(), YAMLMapping.class);
                ++foundHierarchies;
            }
            if (foundHierarchies == keyParts.size()) {
                throw (Throwable)new IncorrectOperationException("key exists already: " + qualifiedKey + '\n' + this.root.getText());
            }
            boolean subKey = topMostExistingKey != null || topMostExistingMapping != null;
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !subKey) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            int indent = 0;
            if (topMostExistingMapping != null) {
                n = YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)topMostExistingMapping));
            } else {
                YAMLKeyValue yAMLKeyValue = topMostExistingKey;
                Intrinsics.checkNotNull((Object)yAMLKeyValue);
                n = YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)yAMLKeyValue)) + 2;
            }
            indent = n;
            YAMLKeyValue dummyKeyValue = this.createKeyValue(keyParts.subList(foundHierarchies, keyParts.size()), indent);
            if (topMostExistingMapping == null) {
                YAMLKeyValue finalTopMostExistingKey = topMostExistingKey;
                runnable = new Runnable(finalTopMostExistingKey, dummyKeyValue){
                    final /* synthetic */ YAMLKeyValue $finalTopMostExistingKey;
                    final /* synthetic */ YAMLKeyValue $dummyKeyValue;

                    public final void run() {
                        YAMLKeyValue yAMLKeyValue = this.$finalTopMostExistingKey;
                        Intrinsics.checkNotNull((Object)yAMLKeyValue);
                        YAMLMapping yAMLMapping = this.$dummyKeyValue.getParentMapping();
                        Intrinsics.checkNotNull((Object)yAMLMapping);
                        yAMLKeyValue.setValue((YAMLValue)yAMLMapping);
                    }
                    {
                        this.$finalTopMostExistingKey = yAMLKeyValue;
                        this.$dummyKeyValue = yAMLKeyValue2;
                    }
                };
            } else {
                YAMLMapping finalTopMostExistingMapping = topMostExistingMapping;
                runnable = new Runnable(finalTopMostExistingMapping, dummyKeyValue){
                    final /* synthetic */ YAMLMapping $finalTopMostExistingMapping;
                    final /* synthetic */ YAMLKeyValue $dummyKeyValue;

                    public final void run() {
                        this.$finalTopMostExistingMapping.putKeyValue(this.$dummyKeyValue);
                    }
                    {
                        this.$finalTopMostExistingMapping = yAMLMapping;
                        this.$dummyKeyValue = yAMLKeyValue;
                    }
                };
            }
            writeRunnable = runnable;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.root.getProject(), (String)MicroservicesConfigBundle.message((String)"config.insert.key", (Object[])new Object[]{qualifiedKey}), null, (Runnable)writeRunnable, (PsiFile[])new PsiFile[0]);
        return this.findExistingKey(qualifiedKey);
    }

    private final YAMLKeyValue createKeyValue(List<String> keyComponents, int indent) {
        YAMLKeyValue dummyKeyValue;
        String string = YAMLElementGenerator.createChainedKey(keyComponents, (int)indent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"YAMLElementGenerator.cre\u2026ey(keyComponents, indent)");
        String chainedKey = string;
        YAMLFile yAMLFile = YAMLElementGenerator.getInstance((Project)this.root.getProject()).createDummyYamlWithText(chainedKey);
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"YAMLElementGenerator.get\u2026yYamlWithText(chainedKey)");
        YAMLFile dummyFile = yAMLFile;
        Collection collection = YAMLUtil.getTopLevelKeys((YAMLFile)dummyFile);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"YAMLUtil.getTopLevelKeys(dummyFile)");
        Collection topLevelKeys = collection;
        boolean bl = !topLevelKeys.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "no top level keys (" + chainedKey + "): " + this.root.getText();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        YAMLKeyValue yAMLKeyValue = dummyKeyValue = (YAMLKeyValue)topLevelKeys.iterator().next();
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"dummyKeyValue");
        YAMLMapping yAMLMapping = yAMLKeyValue.getParentMapping();
        bl3 = false;
        boolean bl5 = false;
        if (yAMLMapping == null) {
            boolean bl6 = false;
            String string3 = "no containing mapping for a kv (" + chainedKey + "): " + this.root.getText();
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return dummyKeyValue;
    }

    @NotNull
    public final List<YAMLKeyValue> getAllKeys() {
        List allKeys = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)allKeys);
        Intrinsics.checkNotNullExpressionValue((Object)processor2, (String)"Processors.cancelableCollectProcessor(allKeys)");
        Processor collectProcessor = processor2;
        ConfigYamlAccessor.processAllKeys((YAMLPsiElement)this.root, (Processor)collectProcessor);
        return allKeys;
    }

    private QsConfigYamlAccessor(YAMLPsiElement root, Module module) {
        this.root = root;
        this.module = module;
    }

    public QsConfigYamlAccessor(@NotNull YAMLDocument root, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this((YAMLPsiElement)root, module);
    }

    public /* synthetic */ QsConfigYamlAccessor(YAMLDocument yAMLDocument, Module module, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            module = null;
        }
        this(yAMLDocument, module);
    }

    public QsConfigYamlAccessor(@NotNull YAMLKeyValue root, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this((YAMLPsiElement)root, module);
    }

    public /* synthetic */ QsConfigYamlAccessor(YAMLKeyValue yAMLKeyValue, Module module, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            module = null;
        }
        this(yAMLKeyValue, module);
    }

    public static final /* synthetic */ YAMLPsiElement access$getRoot$p(QsConfigYamlAccessor $this) {
        return $this.root;
    }
}

