/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.QsMetaConfigSubKeyManager;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertySubKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "element", "text", "", "parent", "Lcom/intellij/quarkus/config/QsMetaConfigKey;", "offset", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/quarkus/config/QsMetaConfigKey;I)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getReferenceDisplayText", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.quarkus"})
public final class QsPropertySubKeyMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement> {
    private final int offset;

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        ConfigKeyParts parts;
        TextRange defaultRange;
        TextRange textRange = defaultRange = super.calculateDefaultRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"defaultRange");
        defaultRange = TextRange.create((int)(textRange.getStartOffset() + this.offset), (int)defaultRange.getEndOffset());
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = defaultRange.substring(psiElement.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultRange.substring(element.text)");
        String keyText = string;
        MetaConfigKey configKey = this.getResolvedKey();
        if (configKey != null && !configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL}) && (parts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)keyText, (boolean)false)) != null) {
            TextRange textRange2 = TextRange.allOf((String)parts.getConfigKey()).shiftRight(defaultRange.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"TextRange.allOf(parts.co\u2026defaultRange.startOffset)");
            return textRange2;
        }
        return defaultRange;
    }

    @NotNull
    public String getReferenceDisplayText() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return QsConfigUtils.INSTANCE.trimProfile(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object object;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = psiElement.getText();
        TextRange textRange = super.calculateDefaultRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"super.calculateDefaultRangeInElement()");
        CharSequence prefix = string.subSequence(textRange.getStartOffset(), this.offset);
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        PsiFile psiFile = psiElement2.getContainingFile();
        if (!(psiFile instanceof PropertiesFile)) {
            psiFile = null;
        }
        if ((object = (PropertiesFile)psiFile) == null || (object = object.getProperties()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object existingProperties = object;
        Iterable $this$mapNotNull$iv = (Iterable)existingProperties;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IProperty it2 = (IProperty)element$iv$iv;
            boolean bl2 = false;
            IProperty iProperty = it2;
            Intrinsics.checkNotNullExpressionValue((Object)iProperty, (String)"it");
            if (iProperty.getKey() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            String string3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            if (!StringsKt.startsWith$default((CharSequence)string3, (CharSequence)prefix, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string4;
            String string5;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            int n = prefix.length();
            boolean bl6 = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string6.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            collection.add(string4);
        }
        Set existingKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        PsiElement psiElement3 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"element");
        MetaConfigKeyManager metaConfigKeyManager = this.getConfigKeyManager();
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyManager, (String)"configKeyManager");
        return QsPropertiesUtils.INSTANCE.getMetaConfigKeyVariants(psiElement3, metaConfigKeyManager, existingKeys);
    }

    public QsPropertySubKeyMetaConfigKeyReference(@NotNull PsiElement element, @NotNull String text, @NotNull QsMetaConfigKey parent, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super((MetaConfigKeyManager)new QsMetaConfigSubKeyManager(parent), element, text);
        this.offset = offset;
    }
}

