/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J/\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesUtils;", "", "()V", "getLastResolvedMetaConfigKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "keyElement", "Lcom/intellij/psi/PsiElement;", "getMetaConfigKeyVariants", "", "element", "configKeyManager", "Lcom/intellij/microservices/config/MetaConfigKeyManager;", "existingKeys", "", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/microservices/config/MetaConfigKeyManager;Ljava/util/Set;)[Ljava/lang/Object;", "getPropertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "property", "Lcom/intellij/lang/properties/psi/impl/PropertyImpl;", "getPropertyValue", "Lcom/intellij/lang/properties/psi/impl/PropertyValueImpl;", "intellij.quarkus"})
public final class QsPropertiesUtils {
    public static final QsPropertiesUtils INSTANCE;

    @Nullable
    public final PropertyKeyImpl getPropertyKey(@NotNull PropertyImpl property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ASTNode aSTNode = property.getKeyNode();
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"property.keyNode ?: return null");
        ASTNode keyNode = aSTNode;
        PsiElement keyElement = keyNode.getPsi();
        return keyElement instanceof PropertyKeyImpl ? (PropertyKeyImpl)keyElement : null;
    }

    @Nullable
    public final PropertyValueImpl getPropertyValue(@NotNull PropertyImpl property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        ASTNode aSTNode = property.getValueNode();
        if (aSTNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"property.valueNode ?: return null");
        ASTNode valueNode = aSTNode;
        PsiElement valueElement = valueNode.getPsi();
        return valueElement instanceof PropertyValueImpl ? (PropertyValueImpl)valueElement : null;
    }

    @NotNull
    public final Object[] getMetaConfigKeyVariants(@NotNull PsiElement element, @NotNull MetaConfigKeyManager configKeyManager, @NotNull Set<String> existingKeys) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)configKeyManager, (String)"configKeyManager");
        Intrinsics.checkNotNullParameter(existingKeys, (String)"existingKeys");
        PropertiesCodeStyleSettings propertiesCodeStyleSettings = PropertiesCodeStyleSettings.getInstance((Project)element.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)propertiesCodeStyleSettings, (String)"PropertiesCodeStyleSetti\u2026Instance(element.project)");
        char delimiterChar = propertiesCodeStyleSettings.getDelimiter();
        CharTailType defaultDelimiterType2 = new CharTailType(delimiterChar, delimiterChar){
            final /* synthetic */ char $delimiterChar;

            public int processTail(@NotNull Editor editor, int tailOffset) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int offset = super.processTail(editor, tailOffset);
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                return offset;
            }
            {
                this.$delimiterChar = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        List configKeys = configKeyManager.getAllMetaConfigKeys(element);
        List result = new ArrayList(configKeys.size());
        Iterator iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            String name;
            MetaConfigKey configKey;
            MetaConfigKey metaConfigKey = configKey = (MetaConfigKey)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"configKey");
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey.getName(), (String)"configKey.name");
            if (existingKeys.contains(name)) continue;
            MetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = configKey.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyPresentation, (String)"configKey.presentation");
            LookupElementBuilder builder = metaConfigKeyPresentation.getLookupElement();
            TailType tailType = configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length)) ? QsConfigUtils.INSTANCE.getMapDotTail() : (TailType)defaultDelimiterType2;
            Ref lookupElementRef = new Ref();
            TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)tailType);
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator);
            lookupElementRef.set((Object)lookupElement);
            LookupElement lookupElement2 = lookupElement;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"lookupElement");
            result.add(lookupElement2);
        }
        Collection collection = result;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
        return UtilKt.toArray((Collection)collection, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MetaConfigKey getLastResolvedMetaConfigKey(@NotNull PsiElement keyElement) {
        Intrinsics.checkNotNullParameter((Object)keyElement, (String)"keyElement");
        PsiReference[] references = keyElement.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)references, (String)"references");
        int n = references.length;
        --n;
        boolean bl = false;
        while (n >= 0) {
            void i;
            PsiReference reference = references[i];
            if (reference instanceof MetaConfigKeyReference) {
                return ((MetaConfigKeyReference)reference).getResolvedKey();
            }
            --i;
        }
        return null;
    }

    private QsPropertiesUtils() {
    }

    static {
        QsPropertiesUtils qsPropertiesUtils;
        INSTANCE = qsPropertiesUtils = new QsPropertiesUtils();
    }
}

