/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsMetaConfigKey;
import com.intellij.quarkus.config.properties.QsConfigKeyPathReferenceSet;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/quarkus/config/properties/QsConfigKeyPathReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.quarkus"})
public final class QsConfigKeyPathReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        String elementText;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get(MetaConfigKeyReference.META_CONFIG_KEY);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.quarkus.config.QsMetaConfigKey");
        }
        QsMetaConfigKey configKey = (QsMetaConfigKey)object;
        if (configKey.isAccessType(MetaConfigKey.AccessType.NORMAL)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String string = elementText = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"elementText");
        String trimmedText = QsConfigUtils.INSTANCE.trimProfile(string);
        QsConfigKeyPathReferenceSet set = new QsConfigKeyPathReferenceSet(element, configKey, trimmedText, elementText.length() - trimmedText.length());
        Collection collection = set.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
        return (PsiReference[])UtilKt.toArray((Collection)collection, (Object[])PsiReference.EMPTY_ARRAY);
    }
}

