/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.profiles;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.profiles.QsProfilePsiReference;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/profiles/QsProfilePsiReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/module/Module;)V", "getVariants", "", "", "()[Ljava/lang/Object;", "includeTestScope", "", "isSoft", "resolve", "intellij.quarkus"})
public final class QsProfilePsiReference
extends PsiReferenceBase<PsiElement> {
    private final Module module;

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        Project project = psiElement.getProject();
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        TextRange textRange = this.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"rangeInElement");
        return PomService.convertToPsi((Project)project, (PomTarget)((PomTarget)new QsProfileTarget(psiElement2, textRange)));
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        Collection<String> names = QsConfigUtils.INSTANCE.findProfiles(this.module, this.includeTestScope());
        Object[] objectArray = ContainerUtil.map2Array(names, Object.class, (Function)getVariants.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ContainerUtil.map2Array(\u2026ls.getMapDotTail())\n    }");
        return objectArray;
    }

    private final boolean includeTestScope() {
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)this.module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        return moduleRootManager.getFileIndex().isInTestSourceContent(virtualFile2);
    }

    public QsProfilePsiReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(element, range);
        this.module = module;
    }
}

