/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.hints;

import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.hints.BooleanHintReferenceProvider;
import com.intellij.microservices.config.hints.ClassHintReferenceProvider;
import com.intellij.microservices.config.hints.DoubleHintReferenceProvider;
import com.intellij.microservices.config.hints.EncodingHintReferenceProvider;
import com.intellij.microservices.config.hints.EnumHintReferenceProvider;
import com.intellij.microservices.config.hints.FloatHintReferenceProvider;
import com.intellij.microservices.config.hints.HintReferenceProvider;
import com.intellij.microservices.config.hints.IntegerHintReferenceProvider;
import com.intellij.microservices.config.hints.LocaleHintReferenceProvider;
import com.intellij.microservices.config.hints.LongHintReferenceProvider;
import com.intellij.microservices.config.hints.StaticValuesHintReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.hints.QsDurationHintReferenceProvider;
import com.intellij.quarkus.config.hints.QsMemorySizeHintReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JA\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00042\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/quarkus/config/hints/QsHintReferencesProvider;", "", "()V", "KNOWN_LOGGING_LEVELS", "", "", "[Ljava/lang/String;", "myByTypeProviders", "", "Lcom/intellij/microservices/config/hints/HintReferenceProvider;", "getByTypeProvider", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "valueType", "Lcom/intellij/psi/PsiType;", "getPojoValueProvider", "keyPsiElement", "Lcom/intellij/psi/PsiElement;", "getValueReferences", "Lcom/intellij/psi/PsiReference;", "key", "valuePsiElement", "valueTextRanges", "", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/microservices/config/MetaConfigKey;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.quarkus"})
public final class QsHintReferencesProvider {
    private static final String[] KNOWN_LOGGING_LEVELS;
    private static final Map<String, HintReferenceProvider> myByTypeProviders;
    public static final QsHintReferencesProvider INSTANCE;

    @NotNull
    public final PsiReference[] getValueReferences(@NotNull MetaConfigKey key, @Nullable PsiElement keyPsiElement, @NotNull PsiElement valuePsiElement, @NotNull List<? extends TextRange> valueTextRanges, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)valuePsiElement, (String)"valuePsiElement");
        Intrinsics.checkNotNullParameter(valueTextRanges, (String)"valueTextRanges");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HintReferenceProvider byTypeProvider = this.getByTypeProvider(key);
        if (byTypeProvider != null) {
            PsiReference[] psiReferenceArray2 = byTypeProvider.getReferences(valuePsiElement, valueTextRanges, context);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray2, (String)"byTypeProvider.getRefere\u2026valueTextRanges, context)");
            return psiReferenceArray2;
        }
        if (keyPsiElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray3 = new PsiReference[1];
        PsiReferenceBase psiReferenceBase = PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceBase, (String)"PsiReferenceBase.createS\u2026Element, valuePsiElement)");
        psiReferenceArray3[0] = (PsiReference)psiReferenceBase;
        PsiReference[] overrideOtherReferences = psiReferenceArray3;
        if (!MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)key)) {
            return overrideOtherReferences;
        }
        HintReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray4 = pojoReferenceProvider.getReferences(valuePsiElement, valueTextRanges, context);
            psiReferenceArray = psiReferenceArray4;
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray4, (String)"pojoReferenceProvider.ge\u2026valueTextRanges, context)");
        } else {
            psiReferenceArray = overrideOtherReferences;
        }
        return psiReferenceArray;
    }

    private final HintReferenceProvider getByTypeProvider(MetaConfigKey configKey) {
        PsiType psiType = configKey.getEffectiveValueType();
        if (psiType == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"configKey.effectiveValueType ?: return null");
        PsiType valueType = psiType;
        if (configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length))) {
            MetaConfigKey.AccessType valueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)valueType);
            PsiType psiType2 = valueAccessType.getEffectiveValueType(valueType);
            if (psiType2 == null) {
                return null;
            }
            valueType = psiType2;
        }
        return this.getByTypeProvider(valueType);
    }

    private final HintReferenceProvider getByTypeProvider(PsiType valueType) {
        PsiType type = QsConfigUtils.INSTANCE.unwrapOptional(valueType);
        if (!type.isValid()) {
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            Map<String, HintReferenceProvider> map2 = myByTypeProviders;
            String string = ((PsiPrimitiveType)type).getBoxedTypeName();
            boolean bl = false;
            return map2.get(string);
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"PsiTypesUtil.getPsiClass(type) ?: return null");
        PsiClass typeClass = psiClass;
        if (typeClass.isEnum()) {
            return (HintReferenceProvider)new EnumHintReferenceProvider(typeClass);
        }
        String string = typeClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeClass.qualifiedName ?: return null");
        String typeFqn = string;
        if (Intrinsics.areEqual((Object)"java.lang.Class", (Object)typeFqn)) {
            PsiType psiType = type;
            if (psiType == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiClassType");
            }
            PsiType[] parameters = ((PsiClassType)psiType).getParameters();
            if (parameters.length != 1) {
                return (HintReferenceProvider)new ClassHintReferenceProvider(null, false, Boolean.valueOf(true));
            }
            PsiType psiType2 = parameters[0];
            if (!(psiType2 instanceof PsiWildcardType)) {
                psiType2 = null;
            }
            PsiWildcardType psiWildcardType = (PsiWildcardType)psiType2;
            if (psiWildcardType == null) {
                return null;
            }
            PsiWildcardType typeParameter = psiWildcardType;
            PsiType psiType3 = typeParameter.getExtendsBound();
            Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"typeParameter.extendsBound");
            return (HintReferenceProvider)new ClassHintReferenceProvider(psiType3.getCanonicalText(), false, Boolean.valueOf(true));
        }
        return myByTypeProviders.get(typeFqn);
    }

    private final HintReferenceProvider getPojoValueProvider(PsiElement keyPsiElement) {
        Object object = ArrayUtil.getLastElement((Object[])keyPsiElement.getReferences());
        if (!(object instanceof ConfigKeyPathReference)) {
            object = null;
        }
        ConfigKeyPathReference configKeyPathReference = (ConfigKeyPathReference)object;
        if (configKeyPathReference == null) {
            return null;
        }
        ConfigKeyPathReference lastReference = configKeyPathReference;
        if (lastReference.getPathType() != ConfigKeyPathReference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement psiElement = lastReference.resolve();
        if (!(psiElement instanceof BeanPropertyElement)) {
            psiElement = null;
        }
        BeanPropertyElement beanPropertyElement = (BeanPropertyElement)psiElement;
        if (beanPropertyElement == null) {
            return null;
        }
        BeanPropertyElement resolve = beanPropertyElement;
        PsiType psiType = resolve.getPropertyType();
        Intrinsics.checkNotNull((Object)psiType);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"resolve.propertyType!!");
        return this.getByTypeProvider(psiType);
    }

    private QsHintReferencesProvider() {
    }

    static {
        QsHintReferencesProvider qsHintReferencesProvider;
        INSTANCE = qsHintReferencesProvider = new QsHintReferencesProvider();
        KNOWN_LOGGING_LEVELS = new String[]{"ALL", "OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
        myByTypeProviders = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"java.lang.Boolean", (Object)new BooleanHintReferenceProvider()), TuplesKt.to((Object)"java.lang.Integer", (Object)new IntegerHintReferenceProvider()), TuplesKt.to((Object)"java.lang.Long", (Object)new LongHintReferenceProvider()), TuplesKt.to((Object)"java.lang.Double", (Object)new DoubleHintReferenceProvider()), TuplesKt.to((Object)"java.lang.Float", (Object)new FloatHintReferenceProvider()), TuplesKt.to((Object)"java.util.OptionalInt", (Object)new IntegerHintReferenceProvider()), TuplesKt.to((Object)"java.util.OptionalLong", (Object)new LongHintReferenceProvider()), TuplesKt.to((Object)"java.util.OptionalDouble", (Object)new DoubleHintReferenceProvider()), TuplesKt.to((Object)"java.nio.charset.Charset", (Object)new EncodingHintReferenceProvider()), TuplesKt.to((Object)"java.util.Locale", (Object)new LocaleHintReferenceProvider()), TuplesKt.to((Object)"java.time.Duration", (Object)((Object)new QsDurationHintReferenceProvider())), TuplesKt.to((Object)"io.quarkus.runtime.configuration.MemorySize", (Object)((Object)new QsMemorySizeHintReferenceProvider())), TuplesKt.to((Object)"java.util.logging.Level", (Object)new StaticValuesHintReferenceProvider(true, false, null, Arrays.copyOf(KNOWN_LOGGING_LEVELS, KNOWN_LOGGING_LEVELS.length)))});
    }
}

