/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.hints;

import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.microservices.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.util.ProcessingContext;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/quarkus/config/hints/QsDurationHintReferenceProvider;", "Lcom/intellij/microservices/config/hints/HintReferenceProviderBase;", "()V", "createReference", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/util/ProcessingContext;", "Companion", "intellij.quarkus"})
public final class QsDurationHintReferenceProvider
extends HintReferenceProviderBase {
    private static final String PERIOD_OF_TIME = "PT";
    private static final Pattern DIGITS;
    private static final Pattern START_WITH_DIGITS;
    private static final Pattern ISO8601;
    public static final Companion Companion;

    @NotNull
    protected PsiReference createReference(@Nullable PsiElement element, @Nullable TextRange textRange, @Nullable ProcessingContext context) {
        PsiElement psiElement = element;
        Intrinsics.checkNotNull((Object)psiElement);
        return (PsiReference)new HintReferenceBase(element, textRange, psiElement, textRange){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ TextRange $textRange;

            @Nullable
            protected PsiElement doResolve() {
                String string = this.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                String value = string;
                if (QsDurationHintReferenceProvider.access$getDIGITS$cp().matcher(value).matches()) {
                    String string2;
                    try {
                        string2 = value;
                        boolean bl = false;
                        Long.parseLong(string2);
                        string2 = this.getElement();
                    }
                    catch (NumberFormatException e) {
                        string2 = null;
                    }
                    return string2;
                }
                if (QsDurationHintReferenceProvider.access$getSTART_WITH_DIGITS$cp().matcher(value).matches()) {
                    PsiElement psiElement;
                    try {
                        Duration.parse("PT" + value);
                        psiElement = this.getElement();
                    }
                    catch (DateTimeParseException e) {
                        psiElement = null;
                    }
                    return psiElement;
                }
                if (QsDurationHintReferenceProvider.access$getISO8601$cp().matcher(value).matches()) {
                    PsiElement psiElement;
                    try {
                        Duration.parse(value);
                        psiElement = this.getElement();
                    }
                    catch (DateTimeParseException e) {
                        psiElement = null;
                    }
                    return psiElement;
                }
                return null;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                return QuarkusBundle.message("quarkus.config.unresolved.duration.value", new Object[0]);
            }
            {
                this.$element = $captured_local_variable$0;
                this.$textRange = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    static {
        Companion = new Companion(null);
        DIGITS = Pattern.compile("^[-+]?\\d+$");
        START_WITH_DIGITS = Pattern.compile("^[-+]?\\d+.*");
        ISO8601 = Pattern.compile("^[+\\-]?P.*$");
    }

    public static final /* synthetic */ Pattern access$getDIGITS$cp() {
        return DIGITS;
    }

    public static final /* synthetic */ Pattern access$getSTART_WITH_DIGITS$cp() {
        return START_WITH_DIGITS;
    }

    public static final /* synthetic */ Pattern access$getISO8601$cp() {
        return ISO8601;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/quarkus/config/hints/QsDurationHintReferenceProvider$Companion;", "", "()V", "DIGITS", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ISO8601", "PERIOD_OF_TIME", "", "START_WITH_DIGITS", "intellij.quarkus"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

