/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.jam.MicroprofileConfigProperty;
import com.intellij.util.Processor;
import com.intellij.util.containers.SmartHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/quarkus/config/QsConfigMethodUsageSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processConfigPropertiesClassKey", "", "parameters", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "processConfigPropertiesInterfaceKey", "processQuery", "consumer", "Lcom/intellij/util/Processor;", "intellij.quarkus"})
public final class QsConfigMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project)) {
            return;
        }
        PsiMethod psiMethod = parameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"parameters.method");
        PsiMethod psiMethod2 = psiMethod;
        if (psiMethod2.hasModifier(JvmModifier.STATIC) || !psiMethod2.hasModifier(JvmModifier.PUBLIC)) {
            return;
        }
        PsiClass psiClass = psiMethod2.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiMethod.containingClass ?: return");
        PsiClass psiClass2 = psiClass;
        if (!psiClass2.isValid()) {
            return;
        }
        if (psiClass2.isInterface()) {
            this.processConfigPropertiesInterfaceKey(parameters, psiMethod2);
        } else {
            this.processConfigPropertiesClassKey(parameters, psiMethod2);
        }
    }

    private final void processConfigPropertiesInterfaceKey(MethodReferencesSearch.SearchParameters parameters, PsiMethod psiMethod) {
        MicroprofileConfigProperty configProperty;
        JvmParameter[] jvmParameterArray = psiMethod.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"psiMethod.parameters");
        JvmParameter[] jvmParameterArray2 = jvmParameterArray;
        boolean bl = false;
        JvmParameter[] jvmParameterArray3 = jvmParameterArray2;
        boolean bl2 = false;
        if (!(jvmParameterArray3.length == 0)) {
            return;
        }
        SmartHashSet names = new SmartHashSet();
        MicroprofileConfigProperty microprofileConfigProperty = configProperty = (MicroprofileConfigProperty)JamService.getJamService((Project)parameters.getProject()).getJamElement((PsiElement)psiMethod, new JamMemberMeta[]{(JamMemberMeta)MicroprofileConfigProperty.Companion.getMETHOD_META()});
        String configName = microprofileConfigProperty != null ? microprofileConfigProperty.getName() : null;
        CharSequence charSequence = configName;
        boolean bl3 = false;
        boolean bl4 = false;
        if (charSequence == null || charSequence.length() == 0) {
            String string = PropertyUtilBase.getPropertyName((PsiMethod)psiMethod);
            if (string == null) {
                string = psiMethod.getName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertyUtilBase.getProp\u2026Method) ?: psiMethod.name");
            String name = string;
            names.add((Object)name);
            String string2 = RelaxedNames.camelCaseToHyphen((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RelaxedNames.camelCaseToHyphen(name)");
            String string3 = string2;
            bl4 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            names.add((Object)string5);
        } else {
            names.add((Object)configName);
        }
        names.remove((Object)psiMethod.getName());
        if (names.isEmpty()) {
            return;
        }
        SearchScope searchScope = parameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
        SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
        for (String name : names) {
            parameters.getOptimizer().searchWord(name, searchScope2, (short)255, true, (PsiElement)psiMethod);
        }
    }

    private final void processConfigPropertiesClassKey(MethodReferencesSearch.SearchParameters parameters, PsiMethod psiMethod) {
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
            return;
        }
        String string = PropertyUtilBase.getPropertyName((PsiMethod)psiMethod);
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertyUtilBase.getProp\u2026Name(psiMethod) ?: return");
        String name = string;
        SearchScope searchScope = parameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"parameters.effectiveSearchScope");
        SearchScope searchScope2 = QsConfigFileContributor.Companion.getReferenceSearchScope(searchScope);
        parameters.getOptimizer().searchWord(name, searchScope2, (short)255, true, (PsiElement)psiMethod);
        String string2 = RelaxedNames.camelCaseToHyphen((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RelaxedNames.camelCaseToHyphen(name)");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String hyphenedName = string5;
        if (Intrinsics.areEqual((Object)hyphenedName, (Object)name) ^ true) {
            parameters.getOptimizer().searchWord(hyphenedName, searchScope2, (short)255, true, (PsiElement)psiMethod);
        }
    }

    public QsConfigMethodUsageSearcher() {
        super(true);
    }
}

