/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config;

import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.quarkus.config.QsConfigKeyNameBinder;
import java.util.Arrays;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/quarkus/config/QsConfigKeyNameBinder;", "Lcom/intellij/microservices/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "()V", "bindsTo", "", "key", "Lcom/intellij/microservices/config/MetaConfigKey;", "configKeyText", "", "bindsToKeyProperty", "keyProperty", "matchesFirstChar", "keyName", "matchesPart", "keyPart", "text", "matchesPrefix", "prefixText", "intellij.quarkus"})
public final class QsConfigKeyNameBinder
implements MetaConfigKeyManager.ConfigKeyNameBinder {
    public static final QsConfigKeyNameBinder INSTANCE;

    public boolean bindsTo(@NotNull MetaConfigKey key, @NotNull String configKeyText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
        if (!this.matchesFirstChar(string, configKeyText)) {
            return false;
        }
        boolean exactMatch = Intrinsics.areEqual((Object)key.getName(), (Object)configKeyText);
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return exactMatch;
        }
        if (key.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length))) {
            return exactMatch || StringUtil.startsWith((CharSequence)configKeyText, (CharSequence)(key.getName() + "."));
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)configKeyText, (char)'[')) {
                return false;
            }
            String string2 = StringUtil.substringBefore((String)configKeyText, (String)"[");
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.substringBefore(configKeyText, \"[\")!!");
            String beforeIndexAccess = string2;
            String string3 = StringUtil.trimEnd((String)beforeIndexAccess, (char)'.');
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.trimEnd(beforeIndexAccess, '.')");
            beforeIndexAccess = string3;
            return Intrinsics.areEqual((Object)key.getName(), (Object)beforeIndexAccess);
        }
        throw (Throwable)new IllegalArgumentException("unknown access type for " + key);
    }

    public boolean matchesPrefix(@NotNull MetaConfigKey key, @NotNull String prefixText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)prefixText, (String)"prefixText");
        return StringUtil.startsWith((CharSequence)key.getName(), (CharSequence)prefixText);
    }

    public boolean matchesPart(@NotNull String keyPart, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)keyPart, (String)"keyPart");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return Intrinsics.areEqual((Object)keyPart, (Object)text);
    }

    @Nullable
    public String bindsToKeyProperty(@NotNull MetaConfigKey key, @Nullable String keyProperty, @NotNull String configKeyText) {
        ConfigKeyParts parts;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configKeyText, (String)"configKeyText");
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return null;
        }
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
        String keyName = string;
        if (!this.matchesFirstChar(keyName, configKeyText)) {
            return null;
        }
        ConfigKeyParts configKeyParts = parts = ConfigKeyParts.splitToParts((MetaConfigKey)key, (String)configKeyText, (boolean)false);
        return configKeyParts != null ? configKeyParts.getKeyIndexIfMatches(keyName, keyProperty, (BiPredicate)bindsToKeyProperty.1.INSTANCE) : null;
    }

    private final boolean matchesFirstChar(String keyName, String configKeyText) {
        CharSequence charSequence = configKeyText;
        boolean bl = false;
        return charSequence.length() > 0 && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    private QsConfigKeyNameBinder() {
    }

    static {
        QsConfigKeyNameBinder qsConfigKeyNameBinder;
        INSTANCE = qsConfigKeyNameBinder = new QsConfigKeyNameBinder();
    }
}

