/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.symbols;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.virtual.DasVirtualParameterSymbol;
import com.intellij.sql.symbols.virtual.DasVirtualVariableSymbol;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasSymbolUtil {
    private DasSymbolUtil() {
    }

    @Nullable
    public static DasSymbol getSymbol(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getTargetSymbol() : null;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static DasSymbol wrapObjectToSymbol(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            DasSymbolUtil.$$$reportNull$$$0(0);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof DasSymbol) {
            return (DasSymbol)object;
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @Nullable
    public static DasSymbol getSymbolByPsi(@Nullable PsiElement element2) {
        if (element2 instanceof DasSymbol) {
            return (DasSymbol)element2;
        }
        if (element2 instanceof SqlReferenceExpression) {
            return DasSymbolUtil.getInlineSymbol(((SqlReferenceExpression)element2).getReference());
        }
        return null;
    }

    @Nullable
    public static DasSymbol getOrResolveSymbol(@Nullable PsiElement element2) {
        if (element2 instanceof DasSymbol) {
            return (DasSymbol)element2;
        }
        if (element2 instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)element2).resolveSymbol();
        }
        return null;
    }

    @NotNull
    public static DasSymbol getInlineSymbol(@NotNull SqlReference reference) {
        if (reference == null) {
            DasSymbolUtil.$$$reportNull$$$0(1);
        }
        DasSymbol dasSymbol = (DasSymbol)CachedValuesManager.getCachedValue((PsiElement)reference.getElement(), () -> new CachedValueProvider.Result((Object)new DasInlineSymbol(reference), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (dasSymbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(2);
        }
        return dasSymbol;
    }

    @Nullable
    public static PsiElement getSinglePsiSource(@Nullable DasSymbol symbol) {
        return symbol != null ? (PsiElement)symbol.getPsiDeclarations().single() : null;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialect(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(3);
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)((Object)ObjectUtils.notNull((Object)((SqlLanguageDialect)SqlLanguageDialect.EP.forDbms(symbol.getDbms())), (Object)SqlDialectMappings.getDefaultSqlDialect()));
        if (sqlLanguageDialectEx == null) {
            DasSymbolUtil.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static Icon getIcon(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(5);
        }
        if (symbol instanceof PsiPresentableMetaData) {
            return ((PsiPresentableMetaData)symbol).getIcon();
        }
        if (symbol instanceof PsiElement) {
            return ((PsiElement)symbol).getIcon(0);
        }
        DasObject dasObject = symbol.getDasObject();
        return dasObject != null ? DbPresentation.getIcon(dasObject) : DbPresentation.getIcon(symbol.getKind());
    }

    @Nls
    @NotNull
    public static String getTypeName(@NotNull DasSymbol symbol) {
        if (symbol == null) {
            DasSymbolUtil.$$$reportNull$$$0(6);
        }
        String string = DbPresentation.getPresentableName(symbol.getKind(), symbol.getDbms());
        if (string == null) {
            DasSymbolUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static DasVirtualVariableSymbol createSimpleVariable(@NotNull SqlElement context, @NotNull String name, final @NotNull DataType dataType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(9);
        }
        if (dataType == null) {
            DasSymbolUtil.$$$reportNull$$$0(10);
        }
        return new DasVirtualVariableSymbol(context, name){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$1", "getDataType"));
            }
        };
    }

    public static DasVirtualParameterSymbol createDelegatingParameter(@NotNull SqlElement context, @NotNull DasRoutine routine, @NotNull String name, @NotNull ArgumentDirection direction, short position, final @NotNull DasTypedObject delegate) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(11);
        }
        if (routine == null) {
            DasSymbolUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(13);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(14);
        }
        if (delegate == null) {
            DasSymbolUtil.$$$reportNull$$$0(15);
        }
        return new DasVirtualParameterSymbol(context, routine, name, direction, position){

            @NotNull
            public DataType getDataType() {
                DataType dataType = delegate.getDataType();
                if (dataType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType;
            }

            @Override
            public boolean isNotNull() {
                return delegate.isNotNull();
            }

            @Override
            @Nullable
            public String getDefault() {
                return delegate.getDefault();
            }

            @Override
            public boolean isQuoted() {
                return DbSqlUtil.isQuoted((DasObject)delegate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$2", "getDataType"));
            }
        };
    }

    public static DasVirtualParameterSymbol createSimpleParameter(@NotNull SqlElement context, @NotNull DasRoutine routine, @NotNull String name, @NotNull ArgumentDirection direction, short position, final @NotNull DataType dataType) {
        if (context == null) {
            DasSymbolUtil.$$$reportNull$$$0(16);
        }
        if (routine == null) {
            DasSymbolUtil.$$$reportNull$$$0(17);
        }
        if (name == null) {
            DasSymbolUtil.$$$reportNull$$$0(18);
        }
        if (direction == null) {
            DasSymbolUtil.$$$reportNull$$$0(19);
        }
        if (dataType == null) {
            DasSymbolUtil.$$$reportNull$$$0(20);
        }
        return new DasVirtualParameterSymbol(context, routine, name, direction, position){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/symbols/DasSymbolUtil$3", "getDataType"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/symbols/DasSymbolUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInlineSymbol";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlDialect";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleVariable";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDelegatingParameter";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

