/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlSemicolonFixer
extends SmartEnterProcessorWithFixers.Fixer {
    public void apply(@NotNull Editor editor, @NotNull SmartEnterProcessorWithFixers processor, @NotNull PsiElement element2) {
        Object insDelim;
        if (editor == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            SqlSemicolonFixer.$$$reportNull$$$0(2);
        }
        if (!(element2 instanceof SqlStatement)) {
            return;
        }
        SqlStatement statement = (SqlStatement)element2;
        String delim = DbSqlUtil.getDelimiterAt(element2.getContainingFile(), element2.getTextOffset());
        Object object = insDelim = !DbSqlUtil.delimiterNeedsSpacing(delim) ? delim : " " + delim;
        if (PsiTreeUtil.hasErrorElements((PsiElement)statement)) {
            int offset;
            int textLength = editor.getDocument().getTextLength();
            int lineEnd = editor.getCaretModel().getVisualLineEnd();
            int n = offset = lineEnd > 0 ? lineEnd - 1 : lineEnd;
            if (offset == 0 || !editor.getDocument().getText(TextRange.from((int)(offset - delim.length()), (int)delim.length())).equals(delim)) {
                editor.getDocument().insertString(lineEnd == textLength ? lineEnd : offset, (CharSequence)insDelim);
            }
        } else {
            PsiElement nonWsSiblingPsi = PsiTreeUtil.nextVisibleLeaf((PsiElement)statement);
            ASTNode nonWhitespaceSibling = nonWsSiblingPsi == null ? null : nonWsSiblingPsi.getNode();
            PsiElement lastChild = statement.getLastChild();
            TokenSet seps = SqlImplUtil.getSqlDialectSafe(element2).getStatementSeparators();
            if (lastChild != null && seps.contains(lastChild.getNode().getElementType())) {
                return;
            }
            if (nonWhitespaceSibling == null || !seps.contains(nonWhitespaceSibling.getElementType())) {
                editor.getDocument().insertString(statement.getTextRange().getEndOffset(), (CharSequence)insDelim);
            }
        }
        SmartEnterProcessor.commitDocument((Editor)editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/smartenter/SqlSemicolonFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

