/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.Dbms;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.translator.ToDatabaseScriptTranslator;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.script.Script;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlScriptModel
extends ScriptModel<PsiElement> {
    private final Script<PsiElement> myScript;

    public SqlScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            SqlScriptModel.$$$reportNull$$$0(0);
        }
        this(file.getProject(), file.getViewProvider().getVirtualFile(), null);
    }

    public SqlScriptModel(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable Language language) {
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            SqlScriptModel.$$$reportNull$$$0(2);
        }
        this(SqlScriptModel.newScriptFor(project, virtualFile, language));
    }

    private SqlScriptModel(@NotNull Script<PsiElement> script) {
        if (script == null) {
            SqlScriptModel.$$$reportNull$$$0(3);
        }
        this.myScript = script;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myScript.getLanguage();
        if (language == null) {
            SqlScriptModel.$$$reportNull$$$0(4);
        }
        return language;
    }

    @NotNull
    private static Script<PsiElement> newScriptFor(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable Language language) {
        Document document;
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            SqlScriptModel.$$$reportNull$$$0(6);
        }
        boolean needParsing = language != null && SqlScriptModel.getLanguage(virtualFile, project) != language;
        Document document2 = document = needParsing ? null : ScriptModelUtil.getScriptDocument(virtualFile);
        if (document != null) {
            return new TrackingDocScript(project, virtualFile, document);
        }
        return new FileScript(project, virtualFile, null, language);
    }

    @NotNull
    private Project getProject() {
        Project project = this.myScript.getProject();
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(7);
        }
        return project;
    }

    public VirtualFile getVirtualFile() {
        return this.myScript.getVirtualFile();
    }

    public SqlScriptModel subModel(@Nullable TextRange range) {
        return new SqlScriptModel((Script<PsiElement>)this.myScript.subScript(range));
    }

    public JBIterable<PsiElement> everything() {
        return this.myScript.getScript().flatten(t -> ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots(t.getRoots())).preOrderDfsTraversal());
    }

    public JBIterable<? extends ScriptModel.StatementIt<PsiElement>> statements() {
        return new SIt((JBIterable<SyntaxTraverser<PsiElement>>)this.myScript.getScript(), this.TO_STATEMENTS()).cursor();
    }

    public JBIterable<? extends ScriptModel.ParamIt<PsiElement>> parameters() {
        return new PIt((JBIterable<SyntaxTraverser<PsiElement>>)this.myScript.getScript(), this.TO_PARAMETERS()).cursor();
    }

    public TextRange getTextRange() {
        return this.myScript.getRange();
    }

    public void dispose() {
        super.dispose();
        if (this.myScript instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myScript));
        }
    }

    @NotNull
    private Function<SyntaxTraverser<PsiElement>, SyntaxTraverser<PsiElement>> TO_STATEMENTS() {
        Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.myScript.getLanguage())).statements(this.myScript.getRange(), this.myScript.getLanguage(), s2);
        if (function2 == null) {
            SqlScriptModel.$$$reportNull$$$0(8);
        }
        return function2;
    }

    @NotNull
    private Function<SyntaxTraverser<PsiElement>, Iterable<PsiElement>> TO_PARAMETERS() {
        Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.myScript.getLanguage())).parameters(this.myScript.getRange(), this.myScript.getLanguage(), s2);
        if (function2 == null) {
            SqlScriptModel.$$$reportNull$$$0(9);
        }
        return function2;
    }

    @NotNull
    public static Language getLanguage(@NotNull VirtualFile vFile, Project project) {
        Language language;
        if (vFile == null) {
            SqlScriptModel.$$$reportNull$$$0(10);
        }
        Object object = (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)vFile)) != PlainTextLanguage.INSTANCE && language != null ? language : SqlLanguageSubstitutor.getSqlLanguage(vFile, project);
        if (object == null) {
            SqlScriptModel.$$$reportNull$$$0(11);
        }
        return object;
    }

    @NotNull
    public ScriptModel<PsiElement> rawTransform(Function<SyntaxTraverser<PsiElement>, SyntaxTraverser<PsiElement>> function2) {
        class A
        extends ScriptBase<A> {
            final Script<PsiElement> delegate;
            final /* synthetic */ Function val$function;
            final /* synthetic */ SqlScriptModel this$0;

            A(Script<PsiElement> delegate) {
                this.this$0 = this$0;
                this.val$function = var3_3;
                super(delegate.getProject(), delegate.getVirtualFile(), delegate.getRange());
                this.delegate = delegate;
            }

            public JBIterable<SyntaxTraverser<PsiElement>> getScript() {
                return this.delegate.getScript().transform(this.val$function);
            }

            @Override
            public A subScript(@Nullable TextRange range) {
                return new A(this.this$0, this.delegate.subScript(range), this.val$function);
            }

            public UserDataHolder getParamDataHolder() {
                return this.delegate.getParamDataHolder();
            }
        }
        return new SqlScriptModel(new A(this, this.myScript.subScript(this.myScript.getRange()), function2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_STATEMENTS";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_PARAMETERS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newScriptFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PIt
    extends MIt<PIt>
    implements ScriptModel.ParamIt<PsiElement> {
        PIt(JBIterable<SyntaxTraverser<PsiElement>> s2, Function<SyntaxTraverser<PsiElement>, Iterable<PsiElement>> transform) {
            super(s2, transform);
        }

        public String displayName() {
            String base = this.nameBase();
            return base != null ? base : this.adjustName(null);
        }

        public Iterable<String> description() {
            return ScriptModelUtil.getRelativeSnippet((PsiElement)this.current(), this.traverser.api);
        }

        public String name() {
            return this.adjustName(this.nameBase());
        }

        @NotNull
        protected String adjustName(String base) {
            String known = ScriptModelUtil.ParamHelper.getParameterId(this, base, SqlScriptModel.this.myScript.getParamDataHolder());
            Object object = known != null ? known : (base != null ? base : this.text() + " #" + ((long)this.range().getStartOffset() + this.rangeOffset()));
            if (object == null) {
                PIt.$$$reportNull$$$0(0);
            }
            return object;
        }

        private String nameBase() {
            PsiElement o = (PsiElement)this.current();
            String name = o instanceof SqlParameter ? ((SqlParameter)o).getName() : null;
            return StringUtil.nullize((String)name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$PIt", "adjustName"));
        }
    }

    private class SIt
    extends MIt<SIt>
    implements ScriptModel.StatementIt<PsiElement> {
        @Nullable
        private final ToDatabaseScriptTranslator myTranslator;

        SIt(JBIterable<SyntaxTraverser<PsiElement>> s2, Function<SyntaxTraverser<PsiElement>, ? extends Iterable<PsiElement>> transform) {
            super(s2, transform);
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.findSqlDialect(DbSqlUtil.getDbms(SqlScriptModel.this.getLanguage()));
            this.myTranslator = sqlLanguageDialect == null ? null : (ToDatabaseScriptTranslator)ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect);
        }

        public String text(ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<PsiElement>> paramCondition) throws TranslateException {
            PsiElement current = (PsiElement)this.current();
            if (this.myTranslator != null && current instanceof SqlElement) {
                ScriptModelUtil.updateOriginVirtualFile(current, SqlScriptModel.this.getVirtualFile());
                return this.myTranslator.translate(current);
            }
            return ScriptModelUtil.statementText(this, storage, paramCondition);
        }

        public JBIterable<? extends ScriptModel.ParamIt<PsiElement>> parameters() {
            return new PIt((JBIterable<SyntaxTraverser<PsiElement>>)JBIterable.of((Object)((SyntaxTraverser)this.traverser.withRoot((Object)((PsiElement)this.current())))), SqlScriptModel.this.TO_PARAMETERS()).cursor();
        }
    }

    private static class MIt<Self extends MIt<Self>>
    extends ScriptModel.ModelItBase<PsiElement, Self> {
        long rangeOffset;
        JBIterator<PsiElement> vIt;
        SyntaxTraverser<PsiElement> nextTr;

        MIt(JBIterable<SyntaxTraverser<PsiElement>> s2, Function<SyntaxTraverser<PsiElement>, ? extends Iterable<PsiElement>> transform) {
            this.vIt = JBIterator.from((Iterator)s2.flatten(vs -> {
                this.nextTr = vs;
                return (Iterable)transform.fun(vs);
            }).iterator());
        }

        protected PsiElement nextImpl() {
            return this.vIt.hasNext() ? (PsiElement)this.vIt.next() : (PsiElement)this.stop();
        }

        protected void currentChanged() {
            if (this.nextTr == null) {
                return;
            }
            this.traverser = this.nextTr;
            this.nextTr = null;
            this.rangeOffset = ScriptModelUtil.getPartOffset(this.traverser);
        }

        public long rangeOffset() {
            return this.rangeOffset;
        }
    }

    private static class FileScript
    extends ScriptBase<FileScript>
    implements Disposable {
        final Language forcedLanguage;

        FileScript(Project project, VirtualFile virtualFile, TextRange range, Language forcedLanguage) {
            super(project, virtualFile, range);
            this.forcedLanguage = forcedLanguage;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.forcedLanguage == null ? super.getLanguage() : this.forcedLanguage;
            if (language == null) {
                FileScript.$$$reportNull$$$0(0);
            }
            return language;
        }

        public UserDataHolder getParamDataHolder() {
            return this.vFile;
        }

        @Override
        public FileScript subScript(@Nullable TextRange range) {
            return new FileScript(this.project, this.vFile, range, this.forcedLanguage);
        }

        public JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            boolean atPosition = this.range instanceof ScriptModel.PositionRange;
            boolean inRange = !atPosition && this.range != null && this.range.getLength() > 0;
            Language language = this.getLanguage();
            JBIterable result = SqlReaderImpl.parseFile(this.project, language, this.vFile, this, (EvaluationHelper)EvaluationHelper.EP.forLanguage(language));
            if (inRange) {
                result = result.transform(ScriptModelUtil.LIMIT_TO_RANGE(this.range));
            }
            return result;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$FileScript", "getLanguage"));
        }
    }

    private static class SealedDocScript
    extends DocScript {
        final SealedDocScript parent;
        final Language myLanguage;
        final CharSequence text;
        final long timeStamp;
        final long settingsModificationCount;
        SyntaxTraverser<PsiElement> raw;
        JBIterable<SyntaxTraverser<PsiElement>> cached;

        SealedDocScript(Project project, VirtualFile file, Document document, @NotNull Language language, long settingsModificationCount) {
            if (language == null) {
                SealedDocScript.$$$reportNull$$$0(0);
            }
            super(project, file, document);
            this.text = document.getImmutableCharSequence();
            this.timeStamp = document.getModificationStamp();
            this.myLanguage = language;
            this.settingsModificationCount = settingsModificationCount;
            this.parent = null;
        }

        SealedDocScript(SealedDocScript sealed, TextRange range) {
            super(sealed, range);
            this.text = sealed.text;
            this.timeStamp = sealed.timeStamp;
            this.myLanguage = sealed.myLanguage;
            this.parent = sealed;
            this.settingsModificationCount = sealed.settingsModificationCount;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.myLanguage;
            if (language == null) {
                SealedDocScript.$$$reportNull$$$0(1);
            }
            return language;
        }

        @NotNull
        public JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            JBIterable<SyntaxTraverser<PsiElement>> jBIterable = this.cached != null ? this.cached : (this.cached = this.getScriptImpl());
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        public DocScript subScript(@Nullable TextRange range) {
            SealedDocScript p2 = this.parent == null ? this : this.parent;
            return range == null ? p2 : new SealedDocScript(p2, range);
        }

        @NotNull
        SyntaxTraverser<PsiElement> parseRaw() {
            EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(this.getLanguage());
            Object object = this.parent != null ? this.parent.parseRaw() : (this.raw != null ? this.raw : (this.raw = helper.parse(this.project, this.myLanguage, this.text, this.getHostLanguage())));
            if (object == null) {
                SealedDocScript.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        protected Function<SyntaxTraverser<PsiElement>, SyntaxTraverser<PsiElement>> toStatements() {
            Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.getLanguage())).statements(this.getRange(), this.getLanguage(), s2);
            if (function2 == null) {
                SealedDocScript.$$$reportNull$$$0(4);
            }
            return function2;
        }

        @NotNull
        JBIterable<SyntaxTraverser<PsiElement>> getScriptImpl() {
            boolean positionOrChosen = this.range instanceof ScriptModel.PositionRange || this.range instanceof ScriptModel.ChosenRange;
            boolean inRange = !positionOrChosen && this.range != null;
            Language hostLanguage = this.getHostLanguage();
            this.raw = this.parseRaw();
            if (inRange) {
                boolean justOne;
                JBIterable adjusted = ((SyntaxTraverser)this.toStatements().fun(this.raw)).traverse();
                Language language = this.getLanguage();
                Dbms dbms = DbSqlUtil.getDbms(language);
                boolean singleBatch = dbms.isTransactSql() && adjusted.filter(SqlBatchBlock.class).isEmpty();
                int selectionOption = ScriptModelUtil.getSelectionOption(this.range);
                boolean bl = justOne = selectionOption == 1 || selectionOption == 2 || adjusted.take(2).size() == 1 || singleBatch && adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.IN_RANGE(this.range))).isEmpty() || adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtil.CONTAINS_RANGE(this.range))).isEmpty();
                if (justOne) {
                    PsiElement first2;
                    SyntaxTraverser exact = ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).parse(this.project, this.myLanguage, this.range.subSequence(this.text), hostLanguage);
                    exact.putUserData(ScriptModelUtil.PART_OFFSET, (Object)this.range.getStartOffset());
                    if (selectionOption == 3 && adjusted.take(2).size() == 1 && ((first2 = (PsiElement)exact.traverse().first()) == null || first2.getTextRange().getStartOffset() != 0)) {
                        JBIterable jBIterable = JBIterable.of(this.raw);
                        if (jBIterable == null) {
                            SealedDocScript.$$$reportNull$$$0(5);
                        }
                        return jBIterable;
                    }
                    JBIterable jBIterable = JBIterable.of((Object)exact);
                    if (jBIterable == null) {
                        SealedDocScript.$$$reportNull$$$0(6);
                    }
                    return jBIterable;
                }
            }
            JBIterable jBIterable = JBIterable.of(this.raw);
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScript";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRaw";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toStatements";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TrackingDocScript
    extends DocScript {
        SealedDocScript sealed;

        TrackingDocScript(Project project, VirtualFile file, Document document) {
            super(project, file, document);
        }

        @Override
        public DocScript subScript(@Nullable TextRange range) {
            return this.getSealed().subScript(range);
        }

        public JBIterable<SyntaxTraverser<PsiElement>> getScript() {
            return this.getSealed().getScript();
        }

        SealedDocScript getSealed() {
            Language dialect = this.getLanguage();
            long settingsModificationCount = DatabaseSettings.getSettings().getModificationCount();
            if (this.sealed == null || this.sealed.timeStamp != this.document.getModificationStamp() || this.sealed.settingsModificationCount != settingsModificationCount || this.sealed.myLanguage != dialect) {
                this.sealed = new SealedDocScript(this.project, this.vFile, this.document, dialect, settingsModificationCount);
            }
            return this.sealed;
        }
    }

    private static abstract class DocScript
    extends ScriptBase<DocScript> {
        final Document document;

        DocScript(Project project, VirtualFile file, Document document) {
            super(project, file, null);
            this.document = document;
        }

        DocScript(DocScript script, TextRange range) {
            super(script.project, script.vFile, range);
            this.document = script.document;
        }

        public UserDataHolder getParamDataHolder() {
            return this.document;
        }
    }

    private static abstract class ScriptBase<Self extends ScriptBase<Self>>
    implements Script<PsiElement> {
        final Project project;
        final VirtualFile vFile;
        final TextRange range;

        ScriptBase(Project project, VirtualFile vFile, TextRange range) {
            this.project = project;
            this.vFile = vFile;
            this.range = range;
        }

        @NotNull
        public Language getLanguage() {
            Language language = SqlScriptModel.getLanguage(this.vFile, this.project);
            if (language == null) {
                ScriptBase.$$$reportNull$$$0(0);
            }
            return language;
        }

        public abstract Self subScript(@Nullable TextRange var1);

        @Nullable
        public Language getHostLanguage() {
            return ScriptModelUtil.getHostLanguage(this.vFile);
        }

        @Nullable
        public TextRange getRange() {
            return this.range;
        }

        @NotNull
        public Project getProject() {
            Project project = this.project;
            if (project == null) {
                ScriptBase.$$$reportNull$$$0(1);
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.vFile;
            if (virtualFile == null) {
                ScriptBase.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/script/SqlScriptModel$ScriptBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

