/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInsertDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlCteInplaceIntroducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSubqueryUtils {
    private static final String INLINE_CTE_HELP_ID = null;

    public static SqlExpression smartFindQuery(Editor editor, PsiFile file) {
        return SqlSubqueryUtils.findCteAbleParent(file.findElementAt(editor.getCaretModel().getOffset()), false);
    }

    @Nullable
    public static SqlExpression findCteAbleParent(@Nullable PsiElement el, boolean strict) {
        if (strict && el != null) {
            el = el.getParent();
        }
        while (el != null) {
            if (el instanceof SqlResultSetExpression && !(el instanceof SqlNAryExpression)) {
                return (SqlExpression)el;
            }
            el = el.getParent();
        }
        return null;
    }

    public static SqlWithClause extractWithClause(PsiElement query) {
        SqlWithQueryExpression withQuery = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query, SqlWithQueryExpression.class);
        return withQuery != null ? withQuery.getWithClause() : null;
    }

    public static SqlExpression removeCteDefinition(SqlAsExpression q) {
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        assert (with != null);
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)with.getParent(), SqlWithQueryExpression.class);
        assert (withEx != null);
        SqlAsExpression sibling = (SqlAsExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)q, SqlAsExpression.class);
        if (sibling != null) {
            with.deleteChildRange((PsiElement)q, sibling.getPrevSibling());
            return withEx;
        }
        sibling = (SqlAsExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)q, SqlAsExpression.class);
        if (sibling != null) {
            with.deleteChildRange(sibling.getNextSibling(), (PsiElement)q);
            return withEx;
        }
        SqlExpression query = withEx.getExpression();
        if (query != null) {
            query = (SqlExpression)withEx.getParent().addAfter((PsiElement)query, (PsiElement)withEx);
            withEx.delete();
            return query;
        }
        return withEx;
    }

    public static SqlExpression findEnclosingQueryWithContext(PsiElement el) {
        PsiElement possibleWithClause;
        SqlExpression ex;
        if (el == null) {
            return null;
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent(), SqlWithQueryExpression.class);
        if (withEx != null) {
            if (withEx.getExpression() != el) {
                return null;
            }
            el = el.getParent();
        }
        if ((ex = SqlSubqueryUtils.findCteAbleParent(el, true)) == null || ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class) != null) {
            return null;
        }
        PsiElement parent2 = ex.getParent();
        if (parent2 instanceof SqlNamedQueryDefinitionImpl && (possibleWithClause = parent2.getParent()) instanceof SqlWithClause) {
            parent2 = possibleWithClause.getParent();
        }
        return (withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)parent2, SqlWithQueryExpression.class)) != null ? withEx : ex;
    }

    public static SqlParenthesizedExpression parenthesized(@NotNull SqlExpression q) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(0);
        }
        if (q instanceof SqlParenthesizedExpression) {
            return (SqlParenthesizedExpression)q;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = SqlSubqueryUtils.createSelectStarFromBuilder(q, dialect);
        int check = ddl.length();
        ddl.symbol("(").plain(q.getText()).symbol(")");
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlParenthesizedExpression res2 = (SqlParenthesizedExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlParenthesizedExpression.class);
        assert (res2 != null && res2.getTextRange().getStartOffset() == check);
        return res2;
    }

    public static SqlAsExpression aliased(@NotNull SqlExpression q, @NotNull String alias) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(1);
        }
        if (alias == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(2);
        }
        boolean appendParentheses = !(q instanceof SqlParenthesizedExpression);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)q);
        DdlBuilder ddl = SqlSubqueryUtils.createSelectStarFromBuilder(q, dialect);
        int check = ddl.length();
        if (appendParentheses) {
            ddl.symbol("(");
        }
        ddl.plain(q.getText());
        if (appendParentheses) {
            ddl.symbol(")");
        }
        ddl.space().alias(alias);
        SqlStatement el = SqlPsiElementFactory.createStatementFromText(ddl.getStatement(), dialect, q.getProject(), (PsiElement)q);
        SqlAsExpression res2 = (SqlAsExpression)PsiTreeUtil.findChildOfType((PsiElement)el, SqlAsExpression.class);
        assert (res2 != null && res2.getTextRange().getStartOffset() == check);
        return res2;
    }

    @NotNull
    private static DdlBuilder createSelectStarFromBuilder(@NotNull SqlExpression q, @NotNull SqlLanguageDialectEx dialect) {
        if (q == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(3);
        }
        if (dialect == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(4);
        }
        DdlBuilder ddl = new DdlBuilder().applyCodeStyle(q.getProject(), dialect).withDialect(dialect.getDatabaseDialect());
        ddl.keyword("select").space().symbol("*").space().keyword("from").space();
        DdlBuilder ddlBuilder = ddl;
        if (ddlBuilder == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public static boolean isSubquery(SqlExpression query, SqlExpression el) {
        return query != null && PsiTreeUtil.isAncestor((PsiElement)query, (PsiElement)el, (boolean)true);
    }

    public static void extractCte(Project project, Editor editor, PsiFile file, SqlExpression subquery, SqlExpression query) {
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)SqlBundle.message("command.name.extract.cte", new Object[0]), (String)"Extract CTE", () -> new SqlCteInplaceIntroducer(project, editor, SqlSubqueryUtils.fixCteSubquery(subquery), SqlSubqueryUtils.fixCteContext(query), file.getFileType()).startInplaceIntroduceTemplate(), (PsiFile[])new PsiFile[]{file}));
    }

    @NotNull
    private static SqlExpression fixCteSubquery(@NotNull SqlExpression subquery) {
        PsiElement parent2;
        if (subquery == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(6);
        }
        while ((parent2 = subquery.getParent()) instanceof SqlNAryExpression) {
            subquery = (SqlExpression)parent2;
        }
        SqlExpression sqlExpression = subquery;
        if (sqlExpression == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(7);
        }
        return sqlExpression;
    }

    @NotNull
    private static PsiElement fixCteContext(@NotNull SqlExpression context) {
        if (context == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(8);
        }
        SqlExpression ctx = context;
        PsiElement parent2 = context.getParent();
        if (parent2 instanceof SqlInsertDmlInstructionImpl) {
            ctx = parent2.getParent();
        }
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)context).getDbms().isMicrosoft()) {
            while (ctx != null && !(ctx instanceof SqlStatement) && !(ctx instanceof SqlWithQueryExpression)) {
                ctx = ctx.getParent();
            }
        }
        SqlExpression sqlExpression = ctx == null ? context : ctx;
        if (sqlExpression == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(9);
        }
        return sqlExpression;
    }

    public static SqlExpression expanded(SqlExpression query) {
        if (query.getParent() instanceof SqlParenthesizedExpression) {
            return (SqlExpression)query.getParent();
        }
        return query;
    }

    public static SqlExpression expandedToAlias(SqlExpression query) {
        SqlExpression expandedExpression = SqlSubqueryUtils.expanded(query);
        PsiElement parent2 = expandedExpression.getParent();
        return parent2 instanceof SqlAsExpression ? (SqlAsExpression)parent2 : expandedExpression;
    }

    public static boolean canExtractWithoutContextLoss(SqlExpression subquery) {
        PsiElement parent2 = (subquery = SqlSubqueryUtils.expanded(subquery)).getParent();
        if (!(parent2 instanceof SqlAsExpression)) {
            return true;
        }
        if (((SqlAsExpression)parent2).getColumnAliasList().isEmpty()) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)subquery);
        Dbms dbms = dialect.getDbms();
        return !dbms.isMicrosoft() && !dbms.isMysql();
    }

    public static boolean isCTESupported(@NotNull PsiFile file) {
        if (file == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(10);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDatabaseDialect().supportsCommonTableExpression();
    }

    @Nullable
    public static SqlAsExpression resolveToNamedQueryDefinition(@Nullable PsiElement element2) {
        PsiElement target = element2;
        SqlIdentifier identifier = (SqlIdentifier)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlIdentifier.class, (boolean)false, (Class[])new Class[]{SqlExpression.class});
        if (identifier != null) {
            PsiElement parent2 = identifier.getParent();
            target = parent2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent2).resolve() : parent2;
        }
        return target instanceof SqlAsExpression ? (SqlAsExpression)target : null;
    }

    public static boolean canInlineCTE(PsiElement element2) {
        SqlAsExpression q = SqlSubqueryUtils.resolveToNamedQueryDefinition(element2);
        if (q == null) {
            return false;
        }
        SqlWithClause with = (SqlWithClause)ObjectUtils.tryCast((Object)q.getParent(), SqlWithClause.class);
        return with != null && !with.isRecursive();
    }

    public static void inlineElement(@NotNull Project project, Editor editor, PsiElement element2) {
        SqlAsExpression query;
        if (project == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(11);
        }
        if ((query = SqlSubqueryUtils.resolveToNamedQueryDefinition(element2)) == null) {
            return;
        }
        Collection refs = ReferencesSearch.search((PsiElement)query, (SearchScope)query.getUseScope(), (boolean)false).findAll();
        if (refs.size() < 2) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)SqlBundle.message("dialog.message.no.usages.found", new Object[0]), (String)SqlBundle.message("dialog.title.inline.cte", new Object[0]), (String)INLINE_CTE_HELP_ID);
            return;
        }
        PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)SqlBundle.message("command.name.inline.cte", new Object[0]), (String)"Inline CTE", () -> SqlSubqueryUtils.inlineOp(project, editor, refs, query), (PsiFile[])new PsiFile[]{element2.getContainingFile()}));
    }

    @Nullable
    private static PsiElement trySimplify(@NotNull PsiElement element2, @NotNull SqlAsExpression query) {
        if (element2 == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(12);
        }
        if (query == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(13);
        }
        PsiElement elementToReplace = element2;
        SqlAsExpression qualifier = query;
        PsiElement parent2 = element2.getParent();
        if (parent2 instanceof SqlAsExpression) {
            qualifier = parent2;
            elementToReplace = parent2;
            parent2 = parent2.getParent();
        }
        if (!(parent2 instanceof SqlFromClause)) {
            return null;
        }
        SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlQueryExpression.class, (boolean)true);
        if (queryExpression == null) {
            return null;
        }
        SqlExpression expression = query.getExpression();
        SqlExpression sqlExpression = expression = expression != null ? UtilsKt.deparenthesize(expression) : null;
        if (!(expression instanceof SqlQueryExpression)) {
            return null;
        }
        PsiElement lastChild = expression.getLastChild();
        if (lastChild instanceof SqlTableExpression) {
            lastChild = lastChild.getLastChild();
        }
        if (lastChild != null && !(lastChild instanceof SqlSelectClause) && !(lastChild instanceof SqlFromClause)) {
            return null;
        }
        SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
        SqlFromClause fromClause = tableExpression != null ? tableExpression.getFromClause() : null;
        SqlExpression fromExpression = fromClause != null ? fromClause.getFromExpression() : null;
        SqlType type = expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            return null;
        }
        SqlTableType tableType = (SqlTableType)type;
        HashMap<String, PsiElement> substitutionMap = new HashMap<String, PsiElement>();
        for (int i2 = 0; i2 < tableType.getColumnCount(); ++i2) {
            String name;
            PsiElement source = tableType.getImmediateSourceColumnElement(i2);
            if (!(source instanceof SqlColumnSymbol)) {
                return null;
            }
            PsiElement columnPsi = source.getContext();
            if (!(columnPsi instanceof SqlExpression)) {
                return null;
            }
            if (columnPsi instanceof SqlAsExpression) {
                SqlAsExpression asExpression = (SqlAsExpression)columnPsi;
                name = asExpression.getName();
                columnPsi = asExpression.getExpression();
            } else {
                if (!((columnPsi = UtilsKt.deparenthesize((SqlExpression)columnPsi)) instanceof SqlReferenceExpression)) {
                    return null;
                }
                name = ((SqlReferenceExpression)columnPsi).getName();
            }
            if (name == null || columnPsi == null) {
                return null;
            }
            PsiElement replacement = columnPsi instanceof SqlLiteralExpression || columnPsi instanceof SqlReferenceExpression ? columnPsi : SqlSubqueryUtils.parenthesized((SqlExpression)columnPsi);
            substitutionMap.put(name, replacement);
        }
        JBIterable references = ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)queryExpression).expandAndSkip(e -> !(e instanceof SqlReferenceExpression))).filter(SqlReferenceExpression.class);
        for (SqlReferenceExpression reference : references) {
            PsiElement replacementParent;
            PsiElement replacement;
            if (SqlImplUtil.getQualifier(reference.resolveSingle()) != qualifier || (replacement = (PsiElement)substitutionMap.get(reference.getName())) == null) continue;
            SqlReferenceExpression exprToReplace = reference;
            SqlExpression topExpr = (SqlExpression)ObjectUtils.notNull((Object)UtilsKt.topParenthesized((SqlExpression)reference), (Object)reference);
            if (!(topExpr.getParent() instanceof SqlExpression) && (replacementParent = replacement.getParent()) instanceof SqlAsExpression) {
                exprToReplace = topExpr;
                replacement = replacementParent;
            }
            exprToReplace.replace(replacement);
        }
        if (fromExpression == null) {
            parent2.delete();
            return queryExpression;
        }
        return elementToReplace.replace((PsiElement)fromExpression);
    }

    @NotNull
    private static List<PsiElement> inlineSubQuery(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2, @NotNull Collection<PsiElement> alias, @NotNull SqlAsExpression query) {
        PsiElement replaceResult;
        if (project == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(15);
        }
        if (element2 == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(16);
        }
        if (alias == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(17);
        }
        if (query == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(18);
        }
        SqlExpression expression = query.getExpression();
        assert (expression != null);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        String subQueryAlias = query.getName();
        if (StringUtil.isEmpty((String)subQueryAlias)) {
            subQueryAlias = "cte_alias";
        }
        if ((replaceResult = SqlSubqueryUtils.trySimplify(element2, query)) == null) {
            SqlAsExpression asExpression = (SqlAsExpression)ObjectUtils.tryCast((Object)element2.getParent(), SqlAsExpression.class);
            if (asExpression != null) {
                subQueryAlias = asExpression.getName();
                element2.replace((PsiElement)SqlSubqueryUtils.parenthesized(expression));
                replaceResult = asExpression;
            } else {
                replaceResult = element2.replace((PsiElement)SqlSubqueryUtils.aliased(expression, subQueryAlias));
            }
        }
        result.add(replaceResult);
        for (PsiElement a : alias) {
            if (!a.isValid()) continue;
            SqlReferenceExpression identifier = (SqlReferenceExpression)ObjectUtils.tryCast((Object)a, SqlReferenceExpression.class);
            if (identifier == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)SqlBundle.message("dialog.message.alias.not.identifier", new Object[0]), (String)SqlBundle.message("dialog.title.inline.cte", new Object[0]), (String)INLINE_CTE_HELP_ID);
                continue;
            }
            identifier.setName(subQueryAlias);
            result.add((PsiElement)identifier);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static void inlineOp(@NotNull Project project, @NotNull Editor editor, @NotNull Collection<PsiReference> refs, @NotNull SqlAsExpression query) {
        if (project == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(21);
        }
        if (refs == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(22);
        }
        if (query == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(23);
        }
        ArrayList<PsiElement> substitute = new ArrayList<PsiElement>();
        ArrayList<PsiElement> alias = new ArrayList<PsiElement>();
        SqlSubqueryUtils.classifyRefs(project, editor, (PsiElement)query, refs, substitute, alias);
        if (!SqlSubqueryUtils.checkCanInline(project, editor, query, substitute)) {
            return;
        }
        List<PsiElement> res2 = SqlSubqueryUtils.inlineSubQuery(project, editor, (PsiElement)substitute.get(0), alias, query);
        SqlExpression ex = SqlSubqueryUtils.getQueryExpression(project, editor, query);
        if (ex == null) {
            return;
        }
        int offset = res2.get(0).getTextOffset() - ex.getTextRange().getStartOffset();
        ex = SqlSubqueryUtils.removeCteDefinition(query);
        ex = SqlSubqueryUtils.getExpressionFromExOrWithEx(ex);
        int caretOffset = ex.getTextRange().getStartOffset() + offset;
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(caretOffset);
        TextRange range = ex.getTextRange();
        CodeStyleManager.getInstance((Project)project).reformatText(ex.getContainingFile(), range.getStartOffset(), range.getEndOffset());
    }

    private static SqlExpression getExpressionFromExOrWithEx(SqlExpression ex) {
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)ex, SqlWithQueryExpression.class);
        SqlExpression ex2 = withEx != null ? withEx.getExpression() : null;
        return ex2 != null ? ex2 : ex;
    }

    private static SqlExpression getQueryExpression(Project project, Editor editor, SqlAsExpression el) {
        SqlWithQueryExpression with = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)el.getParent().getParent(), SqlWithQueryExpression.class);
        if (with == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)SqlBundle.message("dialog.message.failed.to.find.with.expression", new Object[0]), (String)SqlBundle.message("dialog.title.inline.cte", new Object[0]), (String)INLINE_CTE_HELP_ID);
            return null;
        }
        return with.getExpression();
    }

    private static void classifyRefs(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement exclude, @NotNull Collection<PsiReference> refs, @NotNull Collection<PsiElement> substitute, @NotNull Collection<PsiElement> alias) {
        if (project == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(25);
        }
        if (exclude == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(26);
        }
        if (refs == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(27);
        }
        if (substitute == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(28);
        }
        if (alias == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(29);
        }
        for (PsiReference ref : refs) {
            PsiElement el = ref.getElement();
            if (el == exclude) continue;
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE || el.getNode().getElementType() == SqlCompositeElementTypes.SQL_REFERENCE) {
                alias.add(el);
                continue;
            }
            if (el.getNode().getElementType() == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                substitute.add(el);
                continue;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)SqlBundle.message("dialog.message.unexpected.reference.type", new Object[0]), (String)SqlBundle.message("dialog.title.inline.cte", new Object[0]), (String)INLINE_CTE_HELP_ID);
        }
    }

    private static boolean checkCanInline(@NotNull Project project, @NotNull Editor editor, @NotNull SqlAsExpression query, @NotNull List<PsiElement> substitute) {
        String error2;
        if (project == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(30);
        }
        if (editor == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(31);
        }
        if (query == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(32);
        }
        if (substitute == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(33);
        }
        if ((error2 = SqlSubqueryUtils.getError(query, substitute)) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error2, (String)SqlBundle.message("dialog.title.inline.cte", new Object[0]), (String)INLINE_CTE_HELP_ID);
            return false;
        }
        return true;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String getError(@NotNull SqlAsExpression query, @NotNull List<PsiElement> substitute) {
        if (query == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(34);
        }
        if (substitute == null) {
            SqlSubqueryUtils.$$$reportNull$$$0(35);
        }
        if (substitute.size() != 1) {
            return substitute.isEmpty() ? SqlBundle.message("dialog.message.nothing.to.inline", new Object[0]) : SqlBundle.message("dialog.message.too.many.places.to.inline", new Object[0]);
        }
        SqlWithQueryExpression withEx = (SqlWithQueryExpression)ObjectUtils.tryCast((Object)query.getParent().getParent(), SqlWithQueryExpression.class);
        if (withEx == null) {
            return SqlBundle.message("dialog.message.with.clause.can.not.be.found", new Object[0]);
        }
        if (withEx.getWithClause().isRecursive()) {
            return SqlBundle.message("dialog.message.can.not.inline.recursive.cte", new Object[0]);
        }
        if (withEx.getExpression() == null || query.getExpression() == null) {
            return SqlBundle.message("dialog.message.with.clause.without.query", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "q";
                break;
            }
            case 2: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/SqlSubqueryUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subquery";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 15: 
            case 21: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclude";
                break;
            }
            case 28: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/SqlSubqueryUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectStarFromBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCteSubquery";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCteContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineSubQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parenthesized";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "aliased";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSelectStarFromBuilder";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixCteSubquery";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixCteContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCTESupported";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inlineElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trySimplify";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "inlineSubQuery";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inlineOp";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "classifyRefs";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkCanInline";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

