/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase$smartChooseExpression$;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.util.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0012H$\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0086\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bH$J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\"\u001a\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u001eH\u0002J\"\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010%\u001a\u00020\u0006H\u0004J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002J-\u0010'\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)J\u001b\u0010*\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b+*\u00020\u000f2\u0006\u0010,\u001a\u00020-H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006."}, d2={"Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Helper", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/lang/ContextAwareActionHandler;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getExpressionBySelection", "Lcom/intellij/sql/psi/SqlExpression;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "getHelper", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "expression", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableForQuickList", "", "isCalleeExpression", "e", "showError", "message", "showNoContainerError", "smartChooseExpression", "helper", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/sql/psi/SqlFile;Lcom/intellij/sql/refactoring/SqlIntroduceHelper;)V", "getPossiblyInjectedElement", "Lorg/jetbrains/annotations/Nullable;", "offset", "", "intellij.database.sql.impl"})
public abstract class SqlIntroduceHandlerBase<Helper extends SqlIntroduceHelper>
implements RefactoringActionHandler,
ContextAwareActionHandler {
    @NotNull
    private final String name;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return file instanceof SqlFile;
    }

    @Nullable
    protected abstract Helper getHelper(@NotNull SqlLanguageDialectEx var1);

    protected abstract void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull SqlExpression var3);

    protected final void showError(@NotNull Project project, @NotNull Editor editor, @NlsContexts.DialogMessage @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)SqlBundle.message("dialog.title.cannot.perform.refactoring", new Object[0]), null);
    }

    public final void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        if (!(file instanceof SqlFile)) {
            return;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Helper helper = this.getHelper(dialect);
        if (helper == null) {
            String string = SqlBundle.message("dialog.message.not.supported.for", this.name, dialect.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"dialo\u2026ame, dialect.displayName)");
            this.showError(project, editor, string);
            return;
        }
        if (editor.getSelectionModel().hasSelection()) {
            SqlExpression expression = this.getExpressionBySelection(editor, (SqlFile)file);
            if (expression == null) {
                String string = SqlBundle.message("dialog.message.selected.fragment.must.be.valid.expression", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"dialo\u2026ust.be.valid.expression\")");
                this.showError(project, editor, string);
                return;
            }
            if (helper.findTopmostBlock((PsiElement)expression) == null) {
                this.showNoContainerError(project, editor);
                return;
            }
            this.invoke(project, editor, expression);
        } else {
            this.smartChooseExpression(project, editor, (SqlFile)file, helper);
        }
    }

    private final void showNoContainerError(Project project, Editor editor) {
        String string = SqlBundle.message("dialog.message.not.available.in.this.context", this.name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"dialo\u2026e.in.this.context\", name)");
        this.showError(project, editor, string);
    }

    private final boolean isCalleeExpression(PsiElement e) {
        return e instanceof SqlReferenceExpression && ((SqlReferenceExpression)e).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private final PsiElement getPossiblyInjectedElement(SqlFile $this$getPossiblyInjectedElement, int offset) {
        PsiElement psiElement = InjectedLanguageManager.getInstance((Project)$this$getPossiblyInjectedElement.getProject()).findInjectedElementAt((PsiFile)$this$getPossiblyInjectedElement, offset);
        if (psiElement == null) {
            psiElement = $this$getPossiblyInjectedElement.findElementAt(offset);
        }
        return psiElement;
    }

    private final SqlExpression getExpressionBySelection(Editor editor, SqlFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        PsiElement element1 = this.getPossiblyInjectedElement(file, selectionModel.getSelectionStart());
        SelectionModel selectionModel2 = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"editor.selectionModel");
        PsiElement element2 = this.getPossiblyInjectedElement(file, selectionModel2.getSelectionEnd() - 1);
        if (element1 instanceof PsiWhiteSpace) {
            TextRange textRange = element1.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element1.getTextRange()");
            element1 = file.findElementAt(textRange.getEndOffset());
        }
        if (element2 instanceof PsiWhiteSpace) {
            TextRange textRange = element2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element2.getTextRange()");
            element2 = file.findElementAt(textRange.getStartOffset() - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiTreeUtil.findCommonPa\u2026 element2) ?: return null");
        PsiElement parent2 = psiElement;
        return (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)parent2, SqlExpression.class, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void smartChooseExpression(Project project, Editor editor, SqlFile file, Helper helper) {
        Sequence parents2;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement currentElement = file.findElementAt(offset);
        if (helper.findTopmostBlock(currentElement) == null) {
            this.showNoContainerError(project, editor);
            return;
        }
        Sequence $this$filterIsInstance$iv = parents2 = SequencesKt.generateSequence((Object)currentElement, (Function1)smartChooseExpression.parents.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)smartChooseExpression$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List expressions2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<SqlExpression, Boolean>(this){
            final /* synthetic */ SqlIntroduceHandlerBase this$0;

            public final boolean invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return !SqlIntroduceHandlerBase.access$isCalleeExpression(this.this$0, (PsiElement)it2);
            }
            {
                this.this$0 = sqlIntroduceHandlerBase;
                super(1);
            }
        })));
        if (expressions2.isEmpty()) {
            String string = SqlBundle.message("dialog.message.no.valid.expressions.were.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"dialo\u2026.expressions.were.found\")");
            this.showError(project, editor, string);
            return;
        }
        if (expressions2.size() != 1) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions2, (Pass)((Pass)new Pass<SqlExpression>(this, project, editor){
                    final /* synthetic */ SqlIntroduceHandlerBase this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;

                    public void pass(@NotNull SqlExpression expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        this.this$0.invoke(this.$project, this.$editor, expression);
                    }
                    {
                        this.this$0 = this$0;
                        this.$project = $captured_local_variable$1;
                        this.$editor = $captured_local_variable$2;
                    }
                }), (Function)smartChooseExpression.2.INSTANCE);
                return;
            }
        }
        this.invoke(project, editor, (SqlExpression)CollectionsKt.first((List)expressions2));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public SqlIntroduceHandlerBase(@Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    public static final /* synthetic */ boolean access$isCalleeExpression(SqlIntroduceHandlerBase $this, PsiElement e) {
        return $this.isCalleeExpression(e);
    }
}

